/*
 * Decompiled with CFR 0.152.
 */
package Utility.Magnifier;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class JImage
extends JComponent {
    protected BufferedImage original;
    protected BufferedImage currentScaled;
    protected Dimension lastSize;

    public JImage() {
    }

    public JImage(String url) {
        try {
            this.original = ImageIO.read(this.getClass().getClassLoader().getResource(url));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics g) {
        Graphics scratchGraphics = g == null ? null : g.create();
        try {
            if (this.original != null) {
                if (this.lastSize != null) {
                    this.lastSize = this.getSize();
                    this.currentScaled = GraphicsUtil.scale((BufferedImage)this.original, (int)this.lastSize.width, (int)this.lastSize.height);
                } else {
                    Dimension currentDim = this.getSize();
                    if (!currentDim.equals(this.lastSize)) {
                        this.lastSize = currentDim;
                        this.currentScaled = GraphicsUtil.scale((BufferedImage)this.original, (int)this.lastSize.width, (int)this.lastSize.height);
                    }
                }
                if (this.currentScaled != null) {
                    g.drawImage(this.currentScaled, 0, 0, this);
                }
            }
        }
        finally {
            scratchGraphics.dispose();
        }
    }

    public void setImage(BufferedImage image) {
        this.original = image;
        SwingUtil.repaint((Component)this);
    }

    public BufferedImage getImage() {
        return this.original;
    }
}

