/*
 * Decompiled with CFR 0.152.
 */
package SearchUitlity;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class AccessJDBCUtil {
    private static final String accessDBURLPrefix = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=";
    private static final String accessDBURLSuffix = ";DriverID=22;READONLY=true}";

    public static Connection getAccessDBConnection(String filename) throws SQLException {
        filename = filename.replace('\\', '/').trim();
        String databaseURL = accessDBURLPrefix + filename + accessDBURLSuffix;
        return DriverManager.getConnection(databaseURL, "", "");
    }

    public static void printResultSet(PrintStream p, ResultSet rs, String title) throws SQLException {
        if (rs != null) {
            ResultSetMetaData metaData = rs.getMetaData();
            int cols = metaData.getColumnCount();
            p.println("\n--------------------------\n" + title + "\n--------------------------");
            for (int i = 1; i <= cols; ++i) {
                p.print(metaData.getColumnLabel(i) + "\t");
            }
            p.println("\n--------------------------");
            int count = 0;
            while (rs.next()) {
                for (int i = 1; i <= cols; ++i) {
                    p.print(rs.getString(i) + "\t");
                }
                p.println("\n--------------------------");
                ++count;
            }
            p.println("Rows: " + count);
        }
    }

    static {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("JdbcOdbc Bridge Driver not found!");
        }
    }
}

