/*
 * Decompiled with CFR 0.152.
 */
package Plot;

import Data.BOOST.BOOSTMarginalAssociationFile;
import Data.BOOST.BOOSTMarginalAssociationItem;
import java.util.List;
import java.util.Vector;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class MarginalAssociationDataset
extends AbstractIntervalXYDataset
implements XYDataset {
    private List<XYSeries> xySeriesList = new Vector<XYSeries>();

    public MarginalAssociationDataset(BOOSTMarginalAssociationFile inputFile) {
        for (int i = 0; i < 23; ++i) {
            this.xySeriesList.add(new XYSeries((Comparable)((Object)("Chr " + (i + 1)))));
        }
        List<BOOSTMarginalAssociationItem> itemList = inputFile.getItemList();
        for (BOOSTMarginalAssociationItem item : itemList) {
            this.xySeriesList.get(item.chr - 1).add(item.location, item.value);
        }
    }

    public int getSeriesCount() {
        return this.xySeriesList.size();
    }

    public Comparable getSeriesKey(int series) {
        return this.xySeriesList.get(series).getKey();
    }

    public int getItemCount(int series) {
        return this.xySeriesList.get(series).getItemCount();
    }

    public Number getX(int series, int item) {
        return this.xySeriesList.get(series).getX(item);
    }

    public Number getY(int series, int item) {
        return this.xySeriesList.get(series).getY(item);
    }

    public Number getStartX(int series, int item) {
        return this.xySeriesList.get(series).getX(item);
    }

    public Number getEndX(int series, int item) {
        return this.xySeriesList.get(series).getX(item);
    }

    public Number getStartY(int series, int item) {
        return this.xySeriesList.get(series).getY(item);
    }

    public Number getEndY(int series, int item) {
        return this.xySeriesList.get(series).getY(item);
    }
}

