/*
 * Decompiled with CFR 0.152.
 */
package Plot;

import Data.BOOST.BOOSTMarginalAssociationFile;
import Plot.MarginalAssociationDataset;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;

public class MarginalAssociationChartPanel
extends JPanel
implements ChangeListener,
ActionListener,
ItemListener {
    private static String SET_INTERVAL_COMMAND = "SET_INTERVAL";
    private int interval = 1000;
    private BOOSTMarginalAssociationFile file = null;
    private MarginalAssociationPlot plot = null;
    private JSlider slider = new JSlider();
    private JRadioButton fullRangeOptionButton = new JRadioButton();
    private JLabel displayFullIntervalLabel = new JLabel("Display Full Interval");
    private JRadioButton selectedRangeOptionButton = new JRadioButton();
    private JLabel intervalLabel = new JLabel("Interval");
    private JTextField intervalTextField = new JTextField();
    private JButton setButton = new JButton("Set");

    public MarginalAssociationChartPanel() {
        this.slider.setEnabled(false);
        this.intervalTextField.setEnabled(false);
        this.intervalTextField.setEditable(false);
        this.setButton.setEnabled(false);
        this.intervalLabel.setEnabled(false);
        this.slider.setBorder(BorderFactory.createTitledBorder("Starting point of the marginal association plot"));
        this.slider.addChangeListener(this);
        this.intervalTextField = new JTextField();
        this.intervalTextField.setText(Integer.toString(this.interval));
        this.setButton.setActionCommand(SET_INTERVAL_COMMAND);
        this.setButton.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.fullRangeOptionButton);
        group.add(this.selectedRangeOptionButton);
        this.fullRangeOptionButton.setSelected(true);
        this.fullRangeOptionButton.addItemListener(this);
        this.selectedRangeOptionButton.addItemListener(this);
        JPanel optionPanel = new JPanel();
        TableLayout tableLayout = new TableLayout(new double[]{10.0, -1.0, 0.05, 0.1, 0.1, 0.1, 10.0}, new double[]{0.0});
        optionPanel.setLayout((LayoutManager)tableLayout);
        tableLayout.insertRow(1, -2.0);
        tableLayout.insertRow(2, -2.0);
        tableLayout.insertRow(3, -2.0);
        optionPanel.add((Component)this.slider, "1,1,1,3");
        optionPanel.add((Component)this.fullRangeOptionButton, "2,1");
        optionPanel.add((Component)this.displayFullIntervalLabel, "3,1,4,1");
        optionPanel.add((Component)this.selectedRangeOptionButton, "2,2");
        optionPanel.add((Component)this.intervalLabel, "3,2");
        optionPanel.add((Component)this.intervalTextField, "4,2");
        optionPanel.add((Component)this.setButton, "5,2");
        JPanel tempPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)tempPanel, "Center");
        this.add((Component)optionPanel, "South");
    }

    public void setMarginalAssociationPlot(BOOSTMarginalAssociationFile file) {
        this.file = file;
        this.removeAll();
        this.plot = new MarginalAssociationPlot(file);
        int max = Math.max(0, file.getItemCount() - 1 - this.interval);
        if (max != 0) {
            int majorTicking = max / 5;
            int minorTicking = majorTicking / 4;
            this.slider.setMinimum(0);
            this.slider.setMaximum(file.getItemCount() - 1);
            this.slider.setMajorTickSpacing(majorTicking);
            this.slider.setMinorTickSpacing(minorTicking);
        }
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        JPanel optionPanel = new JPanel();
        TableLayout tableLayout = new TableLayout(new double[]{10.0, -1.0, 0.05, 0.1, 0.1, 0.1, 10.0}, new double[]{0.0});
        optionPanel.setLayout((LayoutManager)tableLayout);
        tableLayout.insertRow(1, -2.0);
        tableLayout.insertRow(2, -2.0);
        tableLayout.insertRow(3, -2.0);
        optionPanel.add((Component)this.slider, "1,1,1,3");
        optionPanel.add((Component)this.fullRangeOptionButton, "2,1");
        optionPanel.add((Component)this.displayFullIntervalLabel, "3,1,4,1");
        optionPanel.add((Component)this.selectedRangeOptionButton, "2,2");
        optionPanel.add((Component)this.intervalLabel, "3,2");
        optionPanel.add((Component)this.intervalTextField, "4,2");
        optionPanel.add((Component)this.setButton, "5,2");
        this.fullRangeOptionButton.setSelected(true);
        this.add((Component)((Object)this.plot), "Center");
        this.add((Component)optionPanel, "South");
        this.getParent().validate();
    }

    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting() && source.isEnabled()) {
            int newValue = source.getValue();
            if (this.plot != null) {
                this.plot.setXRange(newValue, newValue + this.interval);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(SET_INTERVAL_COMMAND)) {
            String value = this.intervalTextField.getText();
            try {
                double dbvalue = Double.parseDouble(value);
                this.interval = (int)dbvalue;
                this.intervalTextField.setText(Integer.toString(this.interval));
                if (this.plot != null) {
                    int start = this.slider.getValue();
                    this.plot.setXRange(start, start + this.interval);
                }
            }
            catch (NumberFormatException ex) {
                this.intervalTextField.setText(Integer.toString(this.interval));
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.fullRangeOptionButton.isSelected()) {
            this.displayFullIntervalLabel.setEnabled(true);
            this.slider.setEnabled(false);
            this.intervalTextField.setEnabled(false);
            this.intervalTextField.setEditable(false);
            this.setButton.setEnabled(false);
            this.intervalLabel.setEnabled(false);
            if (this.plot != null) {
                this.plot.setXRange(0, this.file.getItemCount() - 1);
            }
        }
        if (this.selectedRangeOptionButton.isSelected()) {
            this.displayFullIntervalLabel.setEnabled(false);
            this.slider.setEnabled(true);
            this.intervalTextField.setEnabled(true);
            this.intervalTextField.setEditable(true);
            this.setButton.setEnabled(true);
            this.intervalLabel.setEnabled(true);
            if (this.plot != null) {
                int start = this.slider.getValue();
                this.plot.setXRange(start, start + this.interval);
            }
        }
    }

    public int writeImage(String filename, String type) {
        if (this.plot != null) {
            int width = this.plot.getWidth();
            int height = this.plot.getHeight();
            BufferedImage bi = new BufferedImage(width, height, 1);
            Graphics2D graphics = bi.createGraphics();
            this.plot.paint(graphics);
            graphics.dispose();
            try {
                ImageIO.write((RenderedImage)bi, type, new File(filename));
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        MarginalAssociationChartPanel panel = new MarginalAssociationChartPanel();
        BOOSTMarginalAssociationFile file = new BOOSTMarginalAssociationFile("C:\\Documents and Settings\\timyung\\Desktop\\TestFolder\\outputMarginalAssociation.txt", "C:\\Documents and Settings\\timyung\\Desktop\\TestFolder\\filenamelist.txt");
        panel.setMarginalAssociationPlot(file);
        JFrame frame = new JFrame("Test Frame");
        frame.setSize(new Dimension(720, 480));
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add((Component)panel, "Center");
        frame.setVisible(true);
    }

    class MarginalAssociationPlot
    extends ChartPanel {
        private BOOSTMarginalAssociationFile file;
        private MarginalAssociationDataset dataset;
        private JFreeChart chart;

        public MarginalAssociationPlot(BOOSTMarginalAssociationFile inputFile) {
            super(null, true);
            this.file = null;
            this.dataset = null;
            this.chart = null;
            this.file = inputFile;
            this.chart = null;
            this.constructDataset();
            this.buildChart();
        }

        private void constructDataset() {
            this.dataset = new MarginalAssociationDataset(this.file);
        }

        protected void buildChart() {
            this.chart = ChartFactory.createScatterPlot((String)"Marginal Association", (String)"Location", (String)"Value", (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            this.getChartRenderingInfo().setEntityCollection(null);
            this.setChart(this.chart);
        }

        public int getXMin() {
            return (int)this.chart.getXYPlot().getDomainAxis().getLowerBound();
        }

        public int getXMax() {
            return (int)this.chart.getXYPlot().getDomainAxis().getUpperBound();
        }

        public void setXRange(int lower, int upper) {
            this.chart.getXYPlot().getDomainAxis().setRange((double)lower, (double)upper);
        }
    }
}

