/*
 * Decompiled with CFR 0.152.
 */
package Graph.Tool;

import Graph.GraphPanel;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import gboost_gui.RuntimeVariables;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class GraphOptionPanel
extends JPanel
implements ActionListener {
    public static final String SET_FILTER_VERTICE_VALUE_COMMAND = "Set_FilterVerticeValue";
    public static final String SET_HIGHLIGHT_EDGE_VALUE_COMMAND = "Set_HighlightEdgeValue";
    private JRadioButton transformingButton = null;
    private JRadioButton pickingButton = null;
    private JRadioButton annotatingButton = null;
    private JToolBar annotationControlToolBar = null;
    private JPanel vertexOptionPanel = new JPanel();
    private JCheckBox showVertexDominantPathway = null;
    private JCheckBox showVertexNameButton = null;
    private JCheckBox showVertexValueButton = null;
    private JCheckBox highlightVertexButton = null;
    private JCheckBox filterVertexButton = null;
    private JTextField filterVerticeValueTextField = null;
    private JButton filterVerticeSetButton = null;
    private JPanel edgeOptionPanel = new JPanel();
    private JRadioButton lineEdgeShapeButton = null;
    private JRadioButton curveEdgeShapeButton = null;
    private JRadioButton orthogonalEdgeShapeButton = null;
    private JCheckBox showEdgeValueButton = null;
    private JCheckBox highlightEdgeButton = null;
    private JTextField highlightEdgeValueTextField = new JTextField();
    private JButton highlightEdgeValueSetButton = new JButton("Set");

    public GraphOptionPanel() {
        TableLayout tableLayout = null;
        double tableLayoutBorderSize = 10.0;
        int rowIndex = 0;
        TitledBorder titleBorder = null;
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        ButtonGroup workingModeOptions = new ButtonGroup();
        this.transformingButton = new JRadioButton("Transforming");
        this.transformingButton.addActionListener(this);
        this.pickingButton = new JRadioButton("Picking");
        this.pickingButton.addActionListener(this);
        this.annotatingButton = new JRadioButton("Annotating");
        this.annotatingButton.addActionListener(this);
        workingModeOptions.add(this.transformingButton);
        workingModeOptions.add(this.pickingButton);
        workingModeOptions.add(this.annotatingButton);
        switch (RuntimeVariables.WORKING_MODE) {
            case TRANSFORMING: {
                this.transformingButton.setSelected(true);
                break;
            }
            case PICKING: {
                this.pickingButton.setSelected(true);
                break;
            }
            case ANNOTATING: {
                this.annotatingButton.setSelected(true);
                break;
            }
        }
        this.showVertexDominantPathway = new JCheckBox("Show vertex dominant pathway");
        this.showVertexDominantPathway.addActionListener(this);
        this.showVertexDominantPathway.setSelected(RuntimeVariables.ShowVertexDominantPathway);
        this.showVertexNameButton = new JCheckBox("Show vertex name");
        this.showVertexNameButton.addActionListener(this);
        this.showVertexNameButton.setSelected(RuntimeVariables.ShowVertexName);
        this.showVertexValueButton = new JCheckBox("Show vertex value");
        this.showVertexValueButton.addActionListener(this);
        this.showVertexValueButton.setSelected(RuntimeVariables.ShowVertexValue);
        this.highlightVertexButton = new JCheckBox("Highlight selected vertices and its neighbors");
        this.highlightVertexButton.addActionListener(this);
        this.highlightVertexButton.setSelected(RuntimeVariables.VertexStrokeHighlight);
        this.filterVertexButton = new JCheckBox("Filter vertices");
        this.filterVertexButton.addActionListener(this);
        this.filterVertexButton.setSelected(RuntimeVariables.FilterVertices);
        this.filterVerticeValueTextField = new JTextField();
        this.filterVerticeValueTextField.setText(Double.toString(RuntimeVariables.FilterVerticesValue));
        this.filterVerticeSetButton = new JButton("Set");
        this.filterVerticeSetButton.setActionCommand(SET_FILTER_VERTICE_VALUE_COMMAND);
        this.filterVerticeSetButton.addActionListener(this);
        this.filterVerticeValueTextField.setEnabled(this.filterVertexButton.isSelected());
        this.filterVerticeSetButton.setEnabled(this.filterVertexButton.isSelected());
        tableLayout = new TableLayout(new double[]{tableLayoutBorderSize, 0.5, -1.0, tableLayoutBorderSize}, new double[]{0.0});
        this.vertexOptionPanel.setLayout((LayoutManager)tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        this.vertexOptionPanel.add((Component)this.showVertexDominantPathway, "1,1,2,1");
        this.vertexOptionPanel.add((Component)this.showVertexNameButton, "1,2,2,2");
        this.vertexOptionPanel.add((Component)this.showVertexValueButton, "1,3,2,3");
        this.vertexOptionPanel.add((Component)this.highlightVertexButton, "1,4,2,4");
        this.vertexOptionPanel.add((Component)this.filterVertexButton, "1,5,2,5");
        this.vertexOptionPanel.add((Component)this.filterVerticeValueTextField, "1,6");
        this.vertexOptionPanel.add((Component)this.filterVerticeSetButton, "2,6");
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Vertices' Option");
        titleBorder.setTitleJustification(1);
        this.vertexOptionPanel.setBorder(titleBorder);
        ButtonGroup edgeShapeButtonGroup = new ButtonGroup();
        this.lineEdgeShapeButton = new JRadioButton("Line");
        this.curveEdgeShapeButton = new JRadioButton("Curve");
        this.orthogonalEdgeShapeButton = new JRadioButton("Orthogonal");
        edgeShapeButtonGroup.add(this.lineEdgeShapeButton);
        edgeShapeButtonGroup.add(this.curveEdgeShapeButton);
        edgeShapeButtonGroup.add(this.orthogonalEdgeShapeButton);
        switch (RuntimeVariables.EdgeShape) {
            case LINE: {
                this.lineEdgeShapeButton.setSelected(true);
                break;
            }
            case CURVE: {
                this.curveEdgeShapeButton.setSelected(true);
                break;
            }
            case ORTHOGONAL: {
                this.orthogonalEdgeShapeButton.setSelected(true);
                break;
            }
        }
        this.lineEdgeShapeButton.addActionListener(this);
        this.curveEdgeShapeButton.addActionListener(this);
        this.orthogonalEdgeShapeButton.addActionListener(this);
        JPanel edgeShapeOptionPanel = new JPanel();
        tableLayout = new TableLayout(new double[]{0.5, 0.5}, new double[]{0.0});
        edgeShapeOptionPanel.setLayout((LayoutManager)tableLayout);
        tableLayout.insertRow(1, -2.0);
        tableLayout.insertRow(2, -2.0);
        edgeShapeOptionPanel.add((Component)this.lineEdgeShapeButton, "0,1");
        edgeShapeOptionPanel.add((Component)this.curveEdgeShapeButton, "1,1");
        edgeShapeOptionPanel.add((Component)this.orthogonalEdgeShapeButton, "0,2,1,2");
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Edge Shape");
        titleBorder.setTitleJustification(1);
        edgeShapeOptionPanel.setBorder(titleBorder);
        this.showEdgeValueButton = new JCheckBox("Show edge value");
        this.showEdgeValueButton.addActionListener(this);
        this.showEdgeValueButton.setSelected(RuntimeVariables.ShowEdgeValue);
        this.highlightEdgeButton = new JCheckBox("Hightlight Edge");
        this.highlightEdgeButton.addActionListener(this);
        this.highlightEdgeButton.setSelected(RuntimeVariables.HighlightEdge);
        this.highlightEdgeValueTextField = new JTextField();
        this.highlightEdgeValueTextField.setText(Double.toString(RuntimeVariables.HighlightEdgeValue));
        this.highlightEdgeValueSetButton = new JButton("Set");
        this.highlightEdgeValueSetButton.setActionCommand(SET_HIGHLIGHT_EDGE_VALUE_COMMAND);
        this.highlightEdgeValueSetButton.addActionListener(this);
        this.highlightEdgeValueTextField.setEnabled(this.highlightEdgeButton.isSelected());
        this.highlightEdgeValueSetButton.setEnabled(this.highlightEdgeButton.isSelected());
        tableLayout = new TableLayout(new double[]{tableLayoutBorderSize, -1.0, 0.5, tableLayoutBorderSize}, new double[]{0.0});
        this.edgeOptionPanel.setLayout((LayoutManager)tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        this.edgeOptionPanel.add((Component)edgeShapeOptionPanel, "1, 1, 2, 1");
        this.edgeOptionPanel.add((Component)this.showEdgeValueButton, "1, 2, 2, 2");
        this.edgeOptionPanel.add((Component)this.highlightEdgeButton, "1, 3, 2, 3");
        this.edgeOptionPanel.add((Component)this.highlightEdgeValueTextField, "1, 4");
        this.edgeOptionPanel.add((Component)this.highlightEdgeValueSetButton, "2, 4");
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Edges' Option");
        titleBorder.setTitleJustification(1);
        this.edgeOptionPanel.setBorder(titleBorder);
        tableLayout = new TableLayout(new double[]{tableLayoutBorderSize, -1.0, tableLayoutBorderSize}, new double[]{0.0});
        this.setLayout((LayoutManager)tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        this.add((Component)new JLabel("Working Mode :"), "1,1");
        this.add((Component)this.transformingButton, "1,2");
        this.add((Component)this.pickingButton, "1,3");
        this.add((Component)this.annotatingButton, "1,4");
        this.add((Component)this.vertexOptionPanel, "1,6");
        this.add((Component)this.edgeOptionPanel, "1,7");
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        AbstractButton source = (AbstractButton)e.getSource();
        if (source == this.transformingButton) {
            if (source.isSelected()) {
                RuntimeVariables.WORKING_MODE = ModalGraphMouse.Mode.TRANSFORMING;
                RuntimeVariables.PathwayGraphPanel.setGraphMouse(ModalGraphMouse.Mode.TRANSFORMING);
            }
        } else if (source == this.pickingButton) {
            if (source.isSelected()) {
                RuntimeVariables.WORKING_MODE = ModalGraphMouse.Mode.PICKING;
                RuntimeVariables.PathwayGraphPanel.setGraphMouse(ModalGraphMouse.Mode.PICKING);
            }
        } else if (source == this.annotatingButton) {
            if (source.isSelected()) {
                RuntimeVariables.WORKING_MODE = ModalGraphMouse.Mode.ANNOTATING;
                RuntimeVariables.PathwayGraphPanel.setGraphMouse(ModalGraphMouse.Mode.ANNOTATING);
            }
        } else if (source == this.highlightVertexButton) {
            RuntimeVariables.VertexStrokeHighlight = source.isSelected();
            RuntimeVariables.PathwayGraphPanel.setVertexStokeHighlight(source.isSelected());
        } else if (source == this.showVertexDominantPathway) {
            RuntimeVariables.ShowVertexDominantPathway = source.isSelected();
            RuntimeVariables.PathwayGraphPanel.showVertexLabel(RuntimeVariables.ShowVertexDominantPathway || RuntimeVariables.ShowVertexName || RuntimeVariables.ShowVertexValue);
        } else if (source == this.showVertexNameButton) {
            RuntimeVariables.ShowVertexName = source.isSelected();
            RuntimeVariables.PathwayGraphPanel.showVertexLabel(RuntimeVariables.ShowVertexDominantPathway || RuntimeVariables.ShowVertexName || RuntimeVariables.ShowVertexValue);
        } else if (source == this.showVertexValueButton) {
            RuntimeVariables.ShowVertexValue = source.isSelected();
            RuntimeVariables.PathwayGraphPanel.showVertexLabel(RuntimeVariables.ShowVertexDominantPathway || RuntimeVariables.ShowVertexName || RuntimeVariables.ShowVertexValue);
        } else if (source == this.filterVertexButton) {
            RuntimeVariables.FilterVertices = source.isSelected();
            this.filterVerticeValueTextField.setEnabled(this.filterVertexButton.isSelected());
            this.filterVerticeSetButton.setEnabled(this.filterVertexButton.isSelected());
            try {
                double value;
                RuntimeVariables.FilterVerticesValue = value = Double.parseDouble(this.filterVerticeValueTextField.getText());
                RuntimeVariables.PathwayGraphPanel.setVertexPredicate(RuntimeVariables.FilterVertices, value);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Unable to parse the edge value!", "Error Messages", 0);
                this.filterVerticeValueTextField.setText(Double.toString(RuntimeVariables.FilterVerticesValue));
            }
        } else if (source == this.lineEdgeShapeButton) {
            if (this.lineEdgeShapeButton.isSelected()) {
                RuntimeVariables.EdgeShape = GraphPanel.EDGE_SHAPE.LINE;
                RuntimeVariables.PathwayGraphPanel.setEdgeShape(GraphPanel.EDGE_SHAPE.LINE);
            }
        } else if (source == this.curveEdgeShapeButton) {
            if (this.curveEdgeShapeButton.isSelected()) {
                RuntimeVariables.EdgeShape = GraphPanel.EDGE_SHAPE.CURVE;
                RuntimeVariables.PathwayGraphPanel.setEdgeShape(GraphPanel.EDGE_SHAPE.CURVE);
            }
        } else if (source == this.orthogonalEdgeShapeButton) {
            if (this.orthogonalEdgeShapeButton.isSelected()) {
                RuntimeVariables.EdgeShape = GraphPanel.EDGE_SHAPE.ORTHOGONAL;
                RuntimeVariables.PathwayGraphPanel.setEdgeShape(GraphPanel.EDGE_SHAPE.ORTHOGONAL);
            }
        } else if (source == this.showEdgeValueButton) {
            RuntimeVariables.ShowEdgeValue = source.isSelected();
            RuntimeVariables.PathwayGraphPanel.showEdgeValue(source.isSelected());
        } else if (source == this.highlightEdgeButton) {
            RuntimeVariables.HighlightEdge = source.isSelected();
            this.highlightEdgeValueTextField.setEnabled(this.highlightEdgeButton.isSelected());
            this.highlightEdgeValueSetButton.setEnabled(this.highlightEdgeButton.isSelected());
            if (RuntimeVariables.HighlightEdge) {
                try {
                    double value;
                    RuntimeVariables.HighlightEdgeValue = value = Double.parseDouble(this.highlightEdgeValueTextField.getText());
                    RuntimeVariables.PathwayGraphPanel.setEdgeWeight(true, value);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Unable to parse the edge value!", "Error Messages", 0);
                    this.highlightEdgeValueTextField.setText(Double.toString(RuntimeVariables.HighlightEdgeValue));
                }
            }
        }
        if (SET_FILTER_VERTICE_VALUE_COMMAND.equals(actionCommand)) {
            try {
                double value;
                RuntimeVariables.FilterVerticesValue = value = Double.parseDouble(this.filterVerticeValueTextField.getText());
                RuntimeVariables.PathwayGraphPanel.setVertexPredicate(RuntimeVariables.FilterVertices, value);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Unable to parse the edge value!", "Error Messages", 0);
                this.filterVerticeValueTextField.setText(Double.toString(RuntimeVariables.FilterVerticesValue));
            }
        } else if (SET_HIGHLIGHT_EDGE_VALUE_COMMAND.equals(actionCommand)) {
            try {
                double value;
                RuntimeVariables.HighlightEdgeValue = value = Double.parseDouble(this.highlightEdgeValueTextField.getText());
                RuntimeVariables.PathwayGraphPanel.setEdgeWeight(true, value);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Unable to parse the edge value!", "Error Messages", 0);
                this.highlightEdgeValueTextField.setText(Double.toString(RuntimeVariables.HighlightEdgeValue));
            }
        }
    }
}

