/*
 * Decompiled with CFR 0.152.
 */
package Graph.Tool;

import Data.Record;
import Graph.Element.GraphVertex;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class GraphNodePropertyPanel
extends JPanel {
    private GraphVertex currentVertex = null;
    private JPanel vertexInfoPanel = null;
    private JLabel vertexNameLabel = new JLabel();
    private JLabel vertexValueLabel = new JLabel();
    private JLabel dominentPathwayLabel = new JLabel();
    private JPanel pathwayListPanel = null;
    private JList pathwayList = null;
    private JPanel tablePanel = null;
    private JScrollPane tableScrollPanel = null;
    private DefaultTableModel tableModel = null;
    private JTable propertyTable = null;

    public GraphNodePropertyPanel() {
        double tableLayoutBorderSize = 10.0;
        int tableLayoutVGap = 2;
        int tableLayoutHGap = 5;
        TableLayout tableLayout = null;
        int rowIndex = 0;
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        TitledBorder titleBorder = null;
        this.pathwayList = new JList();
        JScrollPane pathwayListScrollPane = new JScrollPane(this.pathwayList);
        this.pathwayListPanel = new JPanel();
        this.pathwayListPanel.setLayout(new BorderLayout());
        this.pathwayListPanel.add((Component)pathwayListScrollPane, "Center");
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Pathway List");
        titleBorder.setTitleJustification(1);
        this.pathwayListPanel.setBorder(titleBorder);
        this.vertexInfoPanel = new JPanel();
        tableLayout = new TableLayout(new double[]{tableLayoutBorderSize, 0.6, -1.0, tableLayoutBorderSize}, new double[]{0.0});
        this.vertexInfoPanel.setLayout((LayoutManager)tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        this.vertexInfoPanel.add((Component)new JLabel("Vertex Name : "), "1,1");
        this.vertexInfoPanel.add((Component)this.vertexNameLabel, "2,1");
        this.vertexInfoPanel.add((Component)new JLabel("Vertex Value : "), "1,2");
        this.vertexInfoPanel.add((Component)this.vertexValueLabel, "2,2");
        this.vertexInfoPanel.add((Component)new JLabel("Dominent Pathway : "), "1,3");
        this.vertexInfoPanel.add((Component)this.dominentPathwayLabel, "2,3");
        this.vertexInfoPanel.add((Component)this.pathwayListPanel, "1,4,2,4");
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Graph Vertex Info");
        titleBorder.setTitleJustification(1);
        this.vertexInfoPanel.setBorder(titleBorder);
        this.tableModel = new DefaultTableModel();
        this.tableModel.setColumnIdentifiers(new String[]{"Field Name", "Value"});
        this.propertyTable = new JTable(this.tableModel);
        this.propertyTable.setColumnSelectionAllowed(false);
        this.tableScrollPanel = new JScrollPane(this.propertyTable);
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)this.tableScrollPanel, "Center");
        titleBorder = BorderFactory.createTitledBorder(loweredetched, "Database Vertex Info");
        titleBorder.setTitleJustification(1);
        this.tablePanel.setBorder(titleBorder);
        tableLayout = new TableLayout(new double[]{tableLayoutBorderSize, -1.0, tableLayoutBorderSize}, new double[]{0.0});
        this.setLayout((LayoutManager)tableLayout);
        rowIndex = 0;
        tableLayout.insertRow(++rowIndex, -2.0);
        tableLayout.insertRow(++rowIndex, -2.0);
        this.add((Component)this.vertexInfoPanel, "1,1");
        this.add((Component)this.tablePanel, "1,2");
        this.setVisible(true);
    }

    public void setCurrentNode(GraphVertex vertex) {
        this.currentVertex = vertex;
        if (this.currentVertex != null) {
            this.vertexNameLabel.setText(this.currentVertex.getVertexLabel());
            this.vertexValueLabel.setText(Double.toString(this.currentVertex.getVertexValue()));
            this.dominentPathwayLabel.setText(this.currentVertex.getDomainPathWay());
            this.pathwayList.setModel(new DefaultListModel());
            DefaultListModel model = (DefaultListModel)this.pathwayList.getModel();
            if (this.currentVertex.getPathWayList() != null) {
                for (String s : this.currentVertex.getPathWayList()) {
                    model.addElement(s);
                }
            }
            this.tableModel.setRowCount(0);
            Record record = Record.getRecord(vertex.getVertexLabel());
            if (record != null) {
                for (int i = 0; i < Record.attributeNameArray.length; ++i) {
                    this.tableModel.addRow(new String[]{Record.attributeNameArray[i], record.getAttributeObject(i).toString()});
                }
            }
        }
    }

    public GraphVertex getCurrentVertex() {
        return this.currentVertex;
    }
}

