/*
 * Decompiled with CFR 0.152.
 */
package Graph;

import Data.BOOST.BOOSTResultItem;
import Data.SNPPathWayDataFile;
import Graph.CustomRenderContext.EdgeWeightStrokeFunction;
import Graph.CustomRenderContext.VertexDisplayPredicate;
import Graph.CustomRenderContext.VertexFillPaint;
import Graph.CustomRenderContext.VertexStrokeHighlight;
import Graph.Element.GraphEdge;
import Graph.Element.GraphVertex;
import Graph.GraphComparator;
import edu.uci.ics.jung.algorithms.layout.AggregateLayout;
import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.EditingModalGraphMouse;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import gboost_gui.Configuration;
import gboost_gui.RuntimeVariables;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphPanel
extends JPanel
implements GraphMouseListener {
    public static Transformer NULL_TRANSFORMER = new ConstantTransformer(null);
    private Graph<GraphVertex, GraphEdge> graph = null;
    private AggregateLayout<GraphVertex, GraphEdge> graphLayout = null;
    private VisualizationViewer visViewer = null;
    private PickedState<GraphVertex> pickState = null;
    private VisualizationViewer.GraphMouse graphMouse = null;
    private Hashtable<String, GraphVertex> vertexHashtable = new Hashtable();
    private List<GraphEdge> edgeList = new Vector<GraphEdge>();
    private double threshold = 40.0;

    public GraphPanel() throws SQLException {
        this.graph = new SparseMultigraph();
        this.graphLayout = new AggregateLayout((Layout)new StaticLayout(this.graph));
        this.graphLayout.setSize(Configuration.GraphLayoutDimension);
        DefaultVisualizationModel visualizationModel = new DefaultVisualizationModel(this.graphLayout, Configuration.GraphLayoutDimension);
        this.visViewer = new VisualizationViewer((VisualizationModel)visualizationModel, Configuration.GraphLayoutDimension);
        this.pickState = this.visViewer.getPickedVertexState();
        this.setupPaintStyle();
        this.createAndSetGraphMouse();
        this.setLayout(new BorderLayout());
        this.add((Component)this.visViewer, "Center");
        this.visViewer.addGraphMouseListener((GraphMouseListener)this);
    }

    protected void createAndSetGraphMouse() {
        if (this.visViewer != null) {
            this.graphMouse = new EditingModalGraphMouse(this.visViewer.getRenderContext(), (Factory)new VertexFactory(), (Factory)new EdgeFactory());
            ((EditingModalGraphMouse)this.graphMouse).setMode(RuntimeVariables.WORKING_MODE);
            this.visViewer.setGraphMouse(this.graphMouse);
            this.visViewer.addGraphMouseListener((GraphMouseListener)this);
        }
    }

    protected void setupPaintStyle() {
        this.showVertexLabel(RuntimeVariables.ShowVertexDominantPathway || RuntimeVariables.ShowVertexName || RuntimeVariables.ShowVertexValue);
        this.setVertexStokeHighlight(RuntimeVariables.VertexStrokeHighlight);
        this.setVertexPredicate(RuntimeVariables.FilterVertices, RuntimeVariables.FilterVerticesValue);
        this.showEdgeValue(RuntimeVariables.ShowEdgeValue);
        this.setEdgeShape(RuntimeVariables.EdgeShape);
        this.setEdgeWeight(RuntimeVariables.HighlightEdge, RuntimeVariables.HighlightEdgeValue);
    }

    public VisualizationViewer getVisualizationViewer() {
        return this.visViewer;
    }

    public void graphClicked(Object v, MouseEvent e) {
    }

    public void graphPressed(Object v, MouseEvent e) {
    }

    public void graphReleased(Object v, MouseEvent e) {
        if (RuntimeVariables.WORKING_MODE == ModalGraphMouse.Mode.PICKING) {
            EditingModalGraphMouse gm = (EditingModalGraphMouse)this.visViewer.getGraphMouse();
            Set pickedVertices = this.pickState.getPicked();
            if (pickedVertices.size() == 1) {
                GraphVertex[] vertices = new GraphVertex[1];
                pickedVertices.toArray(vertices);
                RuntimeVariables.NodePropertyPanel.setCurrentNode(vertices[0]);
                RuntimeVariables.NodePropertyPanel.invalidate();
            }
        }
    }

    public void setGraph(List<BOOSTResultItem> itemList) {
        this.vertexHashtable.clear();
        this.edgeList.clear();
        this.graph = new SparseMultigraph();
        this.graphLayout = new AggregateLayout((Layout)new StaticLayout(this.graph));
        this.graphLayout.setSize(Configuration.GraphLayoutDimension);
        this.visViewer.setGraphLayout(this.graphLayout);
        DefaultVisualizationModel visualizationModel = new DefaultVisualizationModel(this.graphLayout, Configuration.GraphLayoutDimension);
        this.visViewer = new VisualizationViewer((VisualizationModel)visualizationModel, Configuration.GraphLayoutDimension);
        this.pickState = this.visViewer.getPickedVertexState();
        this.setupPaintStyle();
        this.createAndSetGraphMouse();
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.visViewer, "Center");
        GraphVertex vertex = null;
        for (BOOSTResultItem item : itemList) {
            if (!this.vertexHashtable.containsKey(item.snpName1)) {
                vertex = new GraphVertex(item.snpName1, item.snpValue1);
                this.vertexHashtable.put(item.snpName1, vertex);
                this.graph.addVertex((Object)vertex);
            }
            if (this.vertexHashtable.containsKey(item.snpName2)) continue;
            vertex = new GraphVertex(item.snpName2, item.snpValue2);
            this.vertexHashtable.put(item.snpName2, vertex);
            this.graph.addVertex((Object)vertex);
        }
        Hashtable<String, SparseMultigraph> subGraphHashtable = new Hashtable<String, SparseMultigraph>();
        SparseMultigraph subGraph = null;
        SparseMultigraph subGraphWithUnknownPathway = new SparseMultigraph();
        SNPPathWayDataFile snpPathWayDataFile = RuntimeVariables.snpPathWayDataFile;
        Hashtable<String, Integer> snpPathwayCountTable = new Hashtable<String, Integer>();
        List<String> pathWayList = null;
        Enumeration<GraphVertex> vertexSet = this.vertexHashtable.elements();
        snpPathwayCountTable.put("UnKnownPathWay", 0);
        String dominentPathway = null;
        while (vertexSet.hasMoreElements()) {
            vertex = vertexSet.nextElement();
            pathWayList = snpPathWayDataFile.getPathwayList(vertex.getVertexLabel());
            if (pathWayList != null) {
                vertex.setPathWayList(pathWayList);
                for (String s : pathWayList) {
                    if (!snpPathwayCountTable.containsKey(s)) {
                        snpPathwayCountTable.put(s, 1);
                        continue;
                    }
                    int count = (Integer)snpPathwayCountTable.get(s);
                    snpPathwayCountTable.put(s, count + 1);
                }
                continue;
            }
            int count = (Integer)snpPathwayCountTable.get("UnKnownPathWay");
            snpPathwayCountTable.put("UnKnownPathWay", count + 1);
        }
        vertexSet = this.vertexHashtable.elements();
        while (vertexSet.hasMoreElements()) {
            vertex = vertexSet.nextElement();
            pathWayList = vertex.getPathWayList();
            if (pathWayList != null) {
                int max = -1;
                int curr = 0;
                int index = 0;
                int dominentIndex = -1;
                for (String s : pathWayList) {
                    curr = (Integer)snpPathwayCountTable.get(s);
                    if (max < curr) {
                        max = curr;
                        dominentIndex = index;
                    }
                    ++index;
                }
                dominentPathway = pathWayList.get(dominentIndex);
                vertex.setDominantPathWay(dominentPathway);
                if (!subGraphHashtable.containsKey(dominentPathway)) {
                    subGraph = new SparseMultigraph();
                    subGraph.addVertex((Object)vertex);
                    subGraphHashtable.put(dominentPathway, subGraph);
                    continue;
                }
                subGraph = (SparseMultigraph)subGraphHashtable.get(dominentPathway);
                subGraph.addVertex((Object)vertex);
                continue;
            }
            vertex.setDominantPathWay("UnknownPathWay");
            subGraphWithUnknownPathway.addVertex((Object)vertex);
        }
        GraphEdge edge = null;
        GraphVertex start = null;
        GraphVertex end = null;
        for (BOOSTResultItem item : itemList) {
            start = this.vertexHashtable.get(item.snpName1);
            end = this.vertexHashtable.get(item.snpName2);
            edge = new GraphEdge(item);
            this.graph.addEdge((Object)edge, (Object)start, (Object)end);
        }
        int pathwayDrawSize = 200;
        Dimension pathwayDrawDimension = new Dimension(pathwayDrawSize, pathwayDrawSize);
        int numberOfPathwayOn2DPlane = (int)Math.floor(Math.sqrt(snpPathwayCountTable.size()));
        if (numberOfPathwayOn2DPlane % 2 == 0) {
            ++numberOfPathwayOn2DPlane;
        }
        int centerX = numberOfPathwayOn2DPlane / 2;
        int centerY = numberOfPathwayOn2DPlane / 2;
        this.graphLayout.setSize(new Dimension(numberOfPathwayOn2DPlane * pathwayDrawSize, numberOfPathwayOn2DPlane * pathwayDrawSize));
        CircleLayout subLayout = null;
        if (subGraphWithUnknownPathway.getVertexCount() != 0) {
            subLayout = new CircleLayout((Graph)subGraphWithUnknownPathway);
            subLayout.setInitializer((Transformer)this.visViewer.getGraphLayout());
            subLayout.setSize(pathwayDrawDimension);
            this.graphLayout.put((Layout)subLayout, (Point2D)new Point2D.Double(centerX * pathwayDrawSize + pathwayDrawSize / 2, centerY * pathwayDrawSize + pathwayDrawSize / 2));
        }
        if (subGraphHashtable.size() != 0) {
            ArrayList subGraphSetList = new ArrayList();
            Enumeration e = subGraphHashtable.elements();
            while (e.hasMoreElements()) {
                subGraphSetList.add(e.nextElement());
            }
            Collections.sort(subGraphSetList, new GraphComparator());
            int upperLeftX = centerX - 1;
            int upperLeftY = centerY - 1;
            int upperRightX = centerX + 1;
            int upperRightY = centerY - 1;
            int lowerLeftX = centerX - 1;
            int lowerLeftY = centerY + 1;
            int lowerRightX = centerX + 1;
            int lowerRightY = centerY + 1;
            int direction = 0;
            int currX = centerX;
            int currY = centerY - 1;
            int count = 0;
            Iterator i$ = subGraphSetList.iterator();
            while (i$.hasNext()) {
                SparseMultigraph g;
                subGraph = g = (SparseMultigraph)i$.next();
                subLayout = new CircleLayout((Graph)subGraph);
                subLayout.setInitializer((Transformer)this.visViewer.getGraphLayout());
                subLayout.setSize(pathwayDrawDimension);
                this.graphLayout.put((Layout)subLayout, (Point2D)new Point2D.Double(currX * pathwayDrawSize + pathwayDrawSize / 2, currY * pathwayDrawSize + pathwayDrawSize / 2));
                if (currX == upperLeftX && currY == upperLeftY) {
                    direction = 0;
                    --upperLeftX;
                    --upperLeftY;
                    ++upperRightX;
                    --upperRightY;
                    --lowerLeftX;
                    ++lowerLeftY;
                    ++lowerRightX;
                    ++lowerRightY;
                    --currY;
                } else {
                    if (currX == upperRightX && currY == upperRightY || currX == lowerRightX && currY == lowerRightY || currX == lowerLeftX && currY == lowerLeftY) {
                        ++direction;
                    }
                    switch (direction) {
                        case 0: {
                            ++currX;
                            break;
                        }
                        case 1: {
                            ++currY;
                            break;
                        }
                        case 2: {
                            --currX;
                            break;
                        }
                        case 3: {
                            --currY;
                            break;
                        }
                    }
                }
                ++count;
            }
        }
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        this.visViewer.scaleToLayout((ScalingControl)scaler);
        this.visViewer.setGraphLayout(this.graphLayout);
        this.getParent().validate();
    }

    public RenderContext getRenderContext() {
        if (this.visViewer != null) {
            return this.visViewer.getRenderContext();
        }
        return null;
    }

    public VisualizationViewer.GraphMouse getGraphMouse() {
        if (this.visViewer != null) {
            return this.visViewer.getGraphMouse();
        }
        return null;
    }

    public void setGraphMouse(ModalGraphMouse.Mode mode) {
        if (this.visViewer != null) {
            ModalGraphMouse gm = (ModalGraphMouse)this.visViewer.getGraphMouse();
            gm.setMode(mode);
        }
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public void setVertexStokeHighlight(boolean isVertexStokeHighlight) {
        if (this.visViewer != null) {
            VertexStrokeHighlight<GraphVertex, GraphEdge> vsh = new VertexStrokeHighlight<GraphVertex, GraphEdge>(this.graph, (PickedInfo<GraphVertex>)this.visViewer.getPickedVertexState());
            VertexFillPaint<GraphVertex, GraphEdge> vfp = new VertexFillPaint<GraphVertex, GraphEdge>(this.graph, (PickedInfo<GraphVertex>)this.visViewer.getPickedVertexState());
            vsh.setHighlight(isVertexStokeHighlight);
            vfp.setHighlight(isVertexStokeHighlight);
            this.visViewer.getRenderContext().setVertexStrokeTransformer(vsh);
            this.visViewer.getRenderContext().setVertexFillPaintTransformer(vfp);
            this.repaint();
        }
    }

    public void showVertexLabel(boolean showVertexLabel) {
        if (this.visViewer != null) {
            if (showVertexLabel) {
                this.visViewer.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
                this.visViewer.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.S);
            } else {
                this.visViewer.getRenderContext().setVertexLabelTransformer(NULL_TRANSFORMER);
            }
            this.repaint();
        }
    }

    public void showVertexValue(boolean showVertexValue) {
        if (this.visViewer != null) {
            if (showVertexValue) {
                this.visViewer.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
                this.visViewer.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.S);
            } else {
                this.visViewer.getRenderContext().setVertexLabelTransformer(NULL_TRANSFORMER);
            }
            this.repaint();
        }
    }

    public void setEdgeShape(EDGE_SHAPE edgeShape) {
        if (this.visViewer != null) {
            switch (edgeShape) {
                case LINE: {
                    this.visViewer.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.Line());
                    break;
                }
                case CURVE: {
                    this.visViewer.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.QuadCurve());
                    break;
                }
                case ORTHOGONAL: {
                    this.visViewer.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.Orthogonal());
                    break;
                }
                default: {
                    this.visViewer.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.Line());
                }
            }
            this.repaint();
        }
    }

    public void showEdgeValue(boolean showEdgeValue) {
        if (this.visViewer != null) {
            if (showEdgeValue) {
                this.visViewer.getRenderContext().setEdgeLabelTransformer((Transformer)new ToStringLabeller());
            } else {
                this.visViewer.getRenderContext().setEdgeLabelTransformer(NULL_TRANSFORMER);
            }
            this.repaint();
        }
    }

    public void setEdgeWeight(boolean weighted, double value) {
        if (this.visViewer != null) {
            if (weighted) {
                this.visViewer.getRenderContext().setEdgeStrokeTransformer(new EdgeWeightStrokeFunction(weighted, value));
            } else {
                this.visViewer.getRenderContext().setEdgeStrokeTransformer(NULL_TRANSFORMER);
            }
            this.repaint();
        }
    }

    public void setVertexPredicate(boolean filterVertexValue, double value) {
        if (this.visViewer != null) {
            this.visViewer.getRenderContext().setVertexIncludePredicate(new VertexDisplayPredicate(filterVertexValue, value, false, 1));
            this.repaint();
        }
    }

    public int writeImage(String filename, String type) {
        if (this.visViewer != null) {
            int width = this.visViewer.getWidth();
            int height = this.visViewer.getHeight();
            BufferedImage bi = new BufferedImage(width, height, 1);
            Graphics2D graphics = bi.createGraphics();
            this.visViewer.paint((Graphics)graphics);
            graphics.dispose();
            try {
                ImageIO.write((RenderedImage)bi, type, new File(filename));
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
            return 0;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EdgeFactory
    implements Factory<GraphEdge> {
        private EdgeFactory() {
        }

        public GraphEdge create() {
            return new GraphEdge(0.0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VertexFactory
    implements Factory<GraphVertex> {
        private VertexFactory() {
        }

        public GraphVertex create() {
            return new GraphVertex("", 0.0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EDGE_SHAPE {
        LINE,
        CURVE,
        ORTHOGONAL;

    }
}

