/*
 * Decompiled with CFR 0.152.
 */
package Graph.CustomRenderContext;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import java.awt.BasicStroke;
import java.awt.Stroke;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertexStrokeHighlight<V, E>
implements Transformer<V, Stroke> {
    protected boolean highlight = false;
    protected Stroke heavy = new BasicStroke(5.0f);
    protected Stroke medium = new BasicStroke(5.0f);
    protected Stroke light = new BasicStroke(1.0f);
    protected PickedInfo<V> pi;
    protected Graph<V, E> graph;

    public VertexStrokeHighlight(Graph<V, E> graph, PickedInfo<V> pi) {
        this.graph = graph;
        this.pi = pi;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    public Stroke transform(V v) {
        if (this.highlight) {
            if (this.pi.isPicked(v)) {
                return this.heavy;
            }
            for (Object w : this.graph.getNeighbors(v)) {
                if (!this.pi.isPicked(w)) continue;
                return this.medium;
            }
            return this.light;
        }
        return this.light;
    }
}

