/*
 * Decompiled with CFR 0.152.
 */
package Graph.CustomRenderContext;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.decorators.AbstractVertexShapeTransformer;
import java.awt.Shape;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertexShapeSize<V, E>
extends AbstractVertexShapeTransformer<V>
implements Transformer<V, Shape> {
    protected boolean stretch = false;
    protected boolean scale = false;
    protected boolean funny_shapes = false;
    protected Transformer<V, Double> voltages;
    protected Graph<V, E> graph;

    public VertexShapeSize(Graph<V, E> graphIn, Transformer<V, Double> voltagesIn) {
        this.graph = graphIn;
        this.voltages = voltagesIn;
        this.setSizeTransformer(new Transformer<V, Integer>(){

            public Integer transform(V v) {
                if (VertexShapeSize.this.scale) {
                    return (int)((Double)VertexShapeSize.this.voltages.transform(v) * 30.0) + 20;
                }
                return 20;
            }
        });
    }

    public void setScaling(boolean scale) {
        this.scale = scale;
    }

    public void useFunnyShapes(boolean use) {
        this.funny_shapes = use;
    }

    public Shape transform(V v) {
        if (this.funny_shapes) {
            if (this.graph.degree(v) < 5) {
                int sides = Math.max(this.graph.degree(v), 3);
                return this.factory.getRegularPolygon(v, sides);
            }
            return this.factory.getRegularStar(v, this.graph.degree(v));
        }
        return this.factory.getEllipse(v);
    }
}

