/*
 * Decompiled with CFR 0.152.
 */
package Graph.CustomRenderContext;

import Graph.Element.GraphVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import org.apache.commons.collections15.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertexDisplayPredicate<V, E>
implements Predicate<Context<Graph<V, E>, V>> {
    protected boolean filterVertexValue;
    protected double filterValue;
    protected boolean filterVertexDegree;
    protected int minDegree = 0;

    public VertexDisplayPredicate(boolean filterVertexValue, double filterValue, boolean filterVertexDegree, int minDegree) {
        this.filterVertexValue = filterVertexValue;
        this.filterValue = filterValue;
        this.filterVertexDegree = filterVertexDegree;
        this.minDegree = minDegree;
    }

    public boolean isFilterVertexValue() {
        return this.filterVertexValue;
    }

    public void setFilterVertexValue(boolean filterVertexValue) {
        this.filterVertexValue = filterVertexValue;
    }

    public boolean isFilterVertexDegree() {
        return this.filterVertexDegree;
    }

    public void setFilterVertexDegree(boolean filterVertexDegree) {
        this.filterVertexDegree = filterVertexDegree;
    }

    public double getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(double filterValue) {
        this.filterValue = filterValue;
    }

    public int getMinDegree() {
        return this.minDegree;
    }

    public void setMinDegree(int minDegree) {
        this.minDegree = minDegree;
    }

    public boolean evaluate(Context<Graph<V, E>, V> context) {
        Graph graph = (Graph)context.graph;
        GraphVertex v = (GraphVertex)context.element;
        boolean result = true;
        if (this.filterVertexValue) {
            result = result && v.getVertexValue() >= this.filterValue;
        } else {
            boolean bl = result = result;
        }
        result = this.filterVertexDegree ? result && graph.degree(context.element) >= this.minDegree : result;
        return result;
    }
}

