/*
 * Decompiled with CFR 0.152.
 */
package Graph.CustomRenderContext;

import Graph.Element.GraphEdge;
import edu.uci.ics.jung.visualization.RenderContext;
import java.awt.BasicStroke;
import java.awt.Stroke;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeWeightStrokeFunction<E>
implements Transformer<E, Stroke> {
    protected static final Stroke basic = new BasicStroke(1.0f);
    protected static final Stroke heavy = new BasicStroke(3.0f);
    protected static final Stroke dotted = RenderContext.DOTTED;
    protected boolean weighted = false;
    protected double edgeValue;

    public EdgeWeightStrokeFunction(boolean weighted, double edgeValue) {
        this.weighted = weighted;
        this.edgeValue = edgeValue;
    }

    public boolean isWeighted() {
        return this.weighted;
    }

    public void setWeighted(boolean weighted) {
        this.weighted = weighted;
    }

    public double getEdgeValue() {
        return this.edgeValue;
    }

    public void setEdgeValue(double edgeValue) {
        this.edgeValue = edgeValue;
    }

    public Stroke transform(E e) {
        if (this.weighted) {
            if (this.drawHeavy(e)) {
                return heavy;
            }
            return dotted;
        }
        return basic;
    }

    protected boolean drawHeavy(E e) {
        GraphEdge edge = (GraphEdge)e;
        return edge.getEdgeWeight() > this.edgeValue;
    }
}

