/*
 * Decompiled with CFR 0.152.
 */
package Data;

import Data.PathwayList;
import Data.SNPPathWayDataFile;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

class LoadSNPPathWayDataFileTask
extends SwingWorker {
    private SNPPathWayDataFile parentFile = null;

    public LoadSNPPathWayDataFileTask(SNPPathWayDataFile file) {
        this.parentFile = file;
    }

    protected Object doInBackground() throws Exception {
        FileReader reader = null;
        Scanner scanner = null;
        try {
            List<PathwayList> snpPathwayList = this.parentFile.getFullSNPPathwayList();
            String filename = this.parentFile.getFilename();
            reader = new FileReader(filename);
            scanner = new Scanner(reader);
            String line = null;
            PathwayList pathwayList = null;
            StringTokenizer tokenizer = null;
            String token = null;
            int numberOfLine = 0;
            int currLine = 0;
            while (scanner.hasNextLine()) {
                scanner.nextLine();
                ++numberOfLine;
            }
            reader = new FileReader(filename);
            scanner = new Scanner(reader);
            while (scanner.hasNextLine()) {
                if (this.isCancelled()) {
                    snpPathwayList.clear();
                    return null;
                }
                if (currLine % 100000 == 0) {
                    this.setProgress((int)((double)currLine / (double)numberOfLine * 100.0));
                }
                line = scanner.nextLine();
                tokenizer = new StringTokenizer(line, ",");
                token = tokenizer.nextToken();
                pathwayList = new PathwayList(token);
                while (tokenizer.hasMoreTokens()) {
                    pathwayList.add(tokenizer.nextToken());
                }
                snpPathwayList.add(pathwayList);
                ++currLine;
            }
            Collections.sort(snpPathwayList);
            this.setProgress(100);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(LoadSNPPathWayDataFileTask.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "All Completed";
    }

    protected void done() {
        super.done();
        this.setProgress(100);
    }
}

