/*
 * Decompiled with CFR 0.152.
 */
package Data.BOOST;

import Data.BOOST.BOOSTResultItem;
import Data.BOOST.SNPNameHashtable;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BOOSTResultFile {
    private String BOOSTResultFilename = null;
    private String snpnameListFilename = null;
    private int numberOfItem = 0;
    private List<BOOSTResultItem> itemList = null;
    private SNPNameHashtable snpNameHastable = null;

    public BOOSTResultFile(String BOOSTResultFilename, String snpnameListFilename) {
        this.BOOSTResultFilename = BOOSTResultFilename;
        this.snpnameListFilename = snpnameListFilename;
        try {
            this.snpNameHastable = new SNPNameHashtable(snpnameListFilename);
            this.buildBOOSTResultItemList();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(BOOSTResultFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(BOOSTResultFile.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void buildBOOSTResultItemList() throws FileNotFoundException, IOException {
        this.itemList = new Vector<BOOSTResultItem>();
        FileReader reader = null;
        Scanner scanner = null;
        StringTokenizer tokenizer = null;
        BOOSTResultItem item = null;
        reader = new FileReader(this.BOOSTResultFilename);
        scanner = new Scanner(reader);
        while (scanner.hasNextLine()) {
            tokenizer = new StringTokenizer(scanner.nextLine());
            item = new BOOSTResultItem();
            tokenizer.nextToken();
            item.snpIndex1 = Integer.parseInt(tokenizer.nextToken());
            item.snpName1 = this.snpNameHastable.getSNPName(item.snpIndex1);
            item.snpIndex2 = Integer.parseInt(tokenizer.nextToken());
            item.snpName2 = this.snpNameHastable.getSNPName(item.snpIndex2);
            item.snpValue1 = Double.parseDouble(tokenizer.nextToken());
            item.snpValue2 = Double.parseDouble(tokenizer.nextToken());
            item.boostValue = Double.parseDouble(tokenizer.nextToken());
            item.zValue = Double.parseDouble(tokenizer.nextToken());
            this.itemList.add(item);
            ++this.numberOfItem;
        }
        scanner.close();
        reader.close();
    }

    public String getBOOSTResultFilename() {
        return this.BOOSTResultFilename;
    }

    public String getSNPNameListFilename() {
        return this.snpnameListFilename;
    }

    public int getTotalNumberOfItem() {
        return this.numberOfItem;
    }

    public BOOSTResultItem getBOOSTResultItem(int index) {
        return this.itemList.get(index);
    }

    public List<BOOSTResultItem> getBOOSTResultItemList() {
        return this.itemList;
    }

    public List<BOOSTResultItem> getFilteredResultItemList(double thresholdValue) {
        Vector<BOOSTResultItem> filteredItemList = new Vector<BOOSTResultItem>();
        for (BOOSTResultItem item : this.itemList) {
            if (!(item.boostValue > thresholdValue)) continue;
            filteredItemList.add(item);
        }
        return filteredItemList;
    }
}

