/*
 * Decompiled with CFR 0.152.
 */
package Data.BOOST;

import Data.BOOST.BOOSTMarginalAssociationItem;
import Data.BOOST.SNPNameHashtable;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BOOSTMarginalAssociationFile {
    private String filename = null;
    private List<BOOSTMarginalAssociationItem> itemList = null;

    public BOOSTMarginalAssociationFile(String BOOSTMarginalAssoicationFilename, String snpnameListFilename) {
        this.filename = BOOSTMarginalAssoicationFilename;
        this.itemList = new Vector<BOOSTMarginalAssociationItem>();
        SNPNameHashtable snpNameHastable = null;
        try {
            snpNameHastable = new SNPNameHashtable(snpnameListFilename);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(BOOSTMarginalAssociationFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        FileReader reader = null;
        Scanner scanner = null;
        String line = null;
        StringTokenizer tokenizer = null;
        BOOSTMarginalAssociationItem item = null;
        int index = 0;
        try {
            reader = new FileReader(BOOSTMarginalAssoicationFilename);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(BOOSTMarginalAssociationFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        scanner = new Scanner(reader);
        while (scanner.hasNextLine()) {
            line = scanner.nextLine();
            tokenizer = new StringTokenizer(line);
            item = new BOOSTMarginalAssociationItem();
            item.snpName = snpNameHastable.getSNPName(Integer.parseInt(tokenizer.nextToken()));
            item.value = Double.parseDouble(tokenizer.nextToken());
            item.location = index + 1;
            item.chr = snpNameHastable.getChr(index);
            ++index;
            this.itemList.add(item);
        }
        scanner.close();
        try {
            reader.close();
        }
        catch (IOException ex) {
            Logger.getLogger(SNPNameHashtable.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public List<BOOSTMarginalAssociationItem> getItemList() {
        return this.itemList;
    }

    public BOOSTMarginalAssociationItem getItem(int index) {
        if (index >= 0 && index < this.itemList.size()) {
            return this.itemList.get(index);
        }
        return null;
    }

    public int getItemCount() {
        return this.itemList.size();
    }

    public static void main(String[] args) throws Exception {
        BOOSTMarginalAssociationFile file = new BOOSTMarginalAssociationFile("C:\\Documents and Settings\\timyung\\Desktop\\TestFolder\\outputMarginalAssociation.txt", "C:\\Documents and Settings\\timyung\\Desktop\\TestFolder\\filenamelist.txt");
    }
}

