/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.metal.MetalLabelUI;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.LineBorder;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ToolScrollBarArrowUI
extends MetalLabelUI {
    protected LineBorder labelBorder;
    protected ResourceManager resourceManager;

    public ToolScrollBarArrowUI(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.labelBorder = new LineBorder(Color.GRAY, 1, true, 3, 3);
        c.setBorder(this.labelBorder);
    }

    protected void installListeners(JLabel c) {
        super.installListeners(c);
        c.addMouseListener(new ScrollToolBarArrowMouseAdapter());
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            GraphicsUtil.fillRect(g, new Rectangle(0, 0, c.getWidth(), c.getHeight()), this.resourceManager.getColor("TOOL_SCROLL_BAR_UI_BCK_START"), this.resourceManager.getColor("TOOL_SCROLL_BAR_UI_BCK_END"), null, 1);
        } else {
            g.setColor(c.getParent().getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(g, c);
    }

    protected class ScrollToolBarArrowMouseAdapter
    extends MouseAdapter {
        protected ScrollToolBarArrowMouseAdapter() {
        }

        public void mouseEntered(MouseEvent e) {
            Component source = e.getComponent();
            if (!source.isOpaque()) {
                ToolScrollBarArrowUI.this.labelBorder.setLineColor(Color.BLACK);
                SwingUtil.repaint(source);
            }
        }

        public void mouseExited(MouseEvent e) {
            Component source = e.getComponent();
            if (!source.isOpaque()) {
                ToolScrollBarArrowUI.this.labelBorder.setLineColor(Color.GRAY);
                SwingUtil.repaint(source);
            }
        }
    }
}

