/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.look;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JDesktopPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.PanelUI;
import javax.swing.plaf.basic.BasicButtonUI;
import org.noos.common.context.Context;
import org.noos.common.object.ObjectCreator;
import org.noos.common.object.ObjectCustomizer;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.TitleBarButtons;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowContainer;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentDesktopManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.DebugSplitPane;
import org.noos.xing.mydoggy.plaf.ui.cmp.DefaultTitleBarButtons;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowActiveButton;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.LineBorder;
import org.noos.xing.mydoggy.plaf.ui.look.ToolScrollBarArrowUI;
import org.noos.xing.mydoggy.plaf.ui.look.ToolWindowRepresentativeAnchorUI;
import org.noos.xing.mydoggy.plaf.ui.look.ToolWindowTitleBarUI;
import org.noos.xing.mydoggy.plaf.ui.transparency.TransparencyManager;
import org.noos.xing.mydoggy.plaf.ui.transparency.WindowTransparencyManager;
import org.noos.xing.mydoggy.plaf.ui.util.Colors;
import org.noos.xing.mydoggy.plaf.ui.util.DummyResourceBundle;
import org.noos.xing.mydoggy.plaf.ui.util.ParentOfQuestion;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyDoggyResourceManager
extends PropertyChangeEventSource
implements ResourceManager {
    private static final String resourceName = "resources.properties";
    protected Properties resources;
    protected Map<String, Icon> icons = new Hashtable<String, Icon>();
    protected Map<String, BufferedImage> images;
    protected Map<String, Color> colors = new Hashtable<String, Color>();
    protected Map<String, ObjectCreator<Component>> cmpCreators;
    protected Map<String, ObjectCreator<ComponentUI>> cmpUiCreators;
    protected Map<String, ObjectCustomizer<Component>> cmpCustomizers;
    protected Map<Class, ObjectCreator> instanceCreators;
    protected Map cache;
    protected String bundlePath;
    protected ResourceBundle resourceBundle;
    protected ResourceBundle userResourceBundle;
    protected TransparencyManager<Window> transparencyManager;

    public MyDoggyResourceManager() {
        this.images = new Hashtable<String, BufferedImage>();
        this.cache = new HashMap();
        this.loadResources();
        this.initComponentCreators();
        this.initTransparencyManager();
    }

    @Override
    public <T> T createInstance(Class<T> clazz, Context context) {
        return (T)this.instanceCreators.get(clazz).create(context);
    }

    @Override
    public Component createComponent(String key, Context context) {
        return this.applyCustomization(key, this.cmpCreators.get(key).create(context), context);
    }

    @Override
    public ComponentUI createComponentUI(String key, Context context) {
        return this.cmpUiCreators.get(key).create(context);
    }

    @Override
    public Component applyCustomization(String key, Component component, Context context) {
        if (this.cmpCustomizers.containsKey(key)) {
            this.cmpCustomizers.get(key).customize(component, context);
        }
        return component;
    }

    @Override
    public Icon getIcon(String id) {
        return this.icons.get(id);
    }

    @Override
    public Icon putIcon(String id, Icon icon) {
        return this.icons.put(id, icon);
    }

    @Override
    public Color getColor(String id) {
        return this.colors.get(id);
    }

    @Override
    public Color putColor(String id, Color color) {
        Color oldColor = this.colors.put(id, color);
        this.firePropertyChangeEvent("color." + id, oldColor, color);
        return oldColor;
    }

    @Override
    public TransparencyManager<Window> getTransparencyManager() {
        return this.transparencyManager;
    }

    @Override
    public void setTransparencyManager(TransparencyManager<Window> transparencyManager) {
        this.transparencyManager = transparencyManager;
    }

    @Override
    public BufferedImage getBufferedImage(String id) {
        return this.images.get(id);
    }

    @Override
    public void setLocale(Locale locale) {
        this.resourceBundle = this.initResourceBundle(locale, this.bundlePath, this.getClass().getClassLoader());
    }

    @Override
    public void setUserBundle(Locale locale, String bundle, ClassLoader classLoader) {
        this.userResourceBundle = this.initResourceBundle(locale, bundle, classLoader);
    }

    @Override
    public void setUserBundle(ResourceBundle userBundle) {
        this.userResourceBundle = userBundle == null ? new DummyResourceBundle() : userBundle;
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    @Override
    public ResourceBundle getUserResourceBundle() {
        return this.userResourceBundle;
    }

    @Override
    public String getString(String key) {
        try {
            return this.resourceBundle.getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    @Override
    public String getUserString(String key) {
        try {
            return this.userResourceBundle != null ? this.userResourceBundle.getString(key) : key;
        }
        catch (Exception e) {
            return key;
        }
    }

    @Override
    public Map<String, Color> getColors() {
        return this.colors;
    }

    @Override
    public Map<String, Icon> getIcons() {
        return this.icons;
    }

    @Override
    public String getProperty(String name) {
        return this.resources.getProperty("Property." + name);
    }

    @Override
    public void putProperty(String name, String value) {
        if (name == null) {
            throw new NullPointerException("name must be not null.");
        }
        Object old = this.resources.put("Property." + name, value);
        this.cache.clear();
        this.firePropertyChangeEvent(name, old, value);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        Boolean result = (Boolean)this.cache.get("Bool." + name);
        if (result != null) {
            return result;
        }
        String propertyValue = this.getProperty(name);
        if (propertyValue == null || "".equals(propertyValue.trim())) {
            result = defaultValue;
        } else {
            try {
                result = Boolean.parseBoolean(propertyValue);
            }
            catch (Exception e) {
                result = defaultValue;
            }
        }
        this.cache.put("Bool." + name, result);
        return result;
    }

    @Override
    public void putBoolean(String name, boolean value) {
        this.putProperty(name, String.valueOf(value));
        this.cache.put("Bool." + name, value);
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        Float result = (Float)this.cache.get("Float." + name);
        if (result != null) {
            return result.floatValue();
        }
        String propertyValue = this.getProperty(name);
        if (propertyValue == null || "".equals(propertyValue.trim())) {
            result = Float.valueOf(defaultValue);
        } else {
            try {
                result = Float.valueOf(Float.parseFloat(propertyValue));
            }
            catch (Exception e) {
                result = Float.valueOf(defaultValue);
            }
        }
        this.cache.put("Float." + name, result);
        return result.floatValue();
    }

    @Override
    public void putFloat(String name, float value) {
        this.putProperty(name, String.valueOf(value));
        this.cache.put("Float." + name, Float.valueOf(value));
    }

    @Override
    public int getInt(String name, int defaultValue) {
        Integer result = (Integer)this.cache.get("Int." + name);
        if (result != null) {
            return result;
        }
        String propertyValue = this.getProperty(name);
        if (propertyValue == null || "".equals(propertyValue.trim())) {
            result = defaultValue;
        } else {
            try {
                result = Integer.parseInt(propertyValue);
            }
            catch (Exception e) {
                result = defaultValue;
            }
        }
        this.cache.put("Int." + name, result);
        return result;
    }

    @Override
    public void putInt(String name, int value) {
        this.putProperty(name, String.valueOf(value));
        this.cache.put("Int." + name, value);
    }

    @Override
    public void putObject(Object key, Object value) {
        this.resources.put(key, value);
    }

    @Override
    public <T> T getObject(Class<T> clazz, T defaultValue) {
        Object value = this.resources.get(clazz);
        if (clazz.isInstance(value)) {
            return (T)value;
        }
        return defaultValue;
    }

    public void putInstanceCreator(Class aClass, ObjectCreator instanceCreator) {
        this.instanceCreators.put(aClass, instanceCreator);
    }

    public void putComponentCreator(String key, ObjectCreator<Component> componentCreator) {
        this.cmpCreators.put(key, componentCreator);
    }

    public void putComponentCustomizer(String key, ObjectCustomizer<Component> componentCustomizer) {
        this.cmpCustomizers.put(key, componentCustomizer);
    }

    public void putComponentUICreator(String key, ObjectCreator<ComponentUI> componentUICreator) {
        this.cmpUiCreators.put(key, componentUICreator);
    }

    protected void loadResources() {
        this.resources = SwingUtil.loadPropertiesFile(resourceName, this.getClass().getClassLoader());
        this.loadIcons();
        this.loadColors();
        this.loadImages();
        this.loadResourceBundles();
    }

    protected void loadIcons() {
        String prefix = "Icon.";
        for (Object key : this.resources.keySet()) {
            String strKey = key.toString();
            if (!strKey.startsWith(prefix)) continue;
            String iconKey = strKey.substring(prefix.length());
            String iconUrl = this.resources.getProperty(strKey);
            this.icons.put(iconKey, this.loadIcon(iconUrl));
        }
    }

    protected void loadImages() {
        String prefix = "Image.";
        for (Object key : this.resources.keySet()) {
            String strKey = key.toString();
            if (!strKey.startsWith(prefix)) continue;
            String imageKey = strKey.substring(prefix.length());
            String imageUrl = this.resources.getProperty(strKey);
            this.images.put(imageKey, this.loadImage(imageUrl));
        }
    }

    protected void loadColors() {
        String prefix = "Color.";
        for (Object key : this.resources.keySet()) {
            String strKey = key.toString();
            if (!strKey.startsWith(prefix)) continue;
            String colorKey = strKey.substring(prefix.length());
            String colorDef = this.resources.getProperty(strKey);
            this.colors.put(colorKey, this.loadColor(colorDef));
        }
    }

    protected void loadResourceBundles() {
        this.bundlePath = this.resources.getProperty("ResourceBundle");
        if (this.bundlePath == null) {
            this.bundlePath = "org/noos/xing/mydoggy/plaf/ui/messages/messages";
        }
    }

    protected Icon loadIcon(String url) {
        return SwingUtil.loadIcon(url);
    }

    protected BufferedImage loadImage(String url) {
        try {
            return ImageIO.read(this.getClass().getClassLoader().getResource(url));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Color loadColor(String colorDef) {
        if ("black".equals(colorDef = colorDef.toLowerCase())) {
            return Color.BLACK;
        }
        if ("blue".equals(colorDef)) {
            return Color.BLUE;
        }
        if ("cyan".equals(colorDef)) {
            return Color.CYAN;
        }
        if ("dark_grey".equals(colorDef)) {
            return Color.DARK_GRAY;
        }
        if ("gray".equals(colorDef)) {
            return Color.GRAY;
        }
        if ("green".equals(colorDef)) {
            return Color.GREEN;
        }
        if ("magenta".equals(colorDef)) {
            return Color.MAGENTA;
        }
        if ("orange".equals(colorDef)) {
            return Color.ORANGE;
        }
        if ("pink".equals(colorDef)) {
            return Color.PINK;
        }
        if ("red".equals(colorDef)) {
            return Color.RED;
        }
        if ("white".equals(colorDef)) {
            return Color.WHITE;
        }
        if ("yellow".equals(colorDef)) {
            return Color.YELLOW;
        }
        String[] elms = colorDef.split(",");
        return new Color(Integer.parseInt(elms[0].trim()), Integer.parseInt(elms[1].trim()), Integer.parseInt(elms[2].trim()));
    }

    protected void initComponentCreators() {
        this.cmpCreators = new Hashtable<String, ObjectCreator<Component>>();
        this.cmpCreators.put("ANCHOR_SPLIT_PANE", new BarSplitPaneComponentCreator());
        this.cmpCreators.put("ANCHOR_CONTENT_PANE", new BarContentPaneComponentCreator());
        this.cmpCreators.put("CORNER_CONTENT_PANE", new CornerContentPaneComponentCreator());
        this.cmpCreators.put("TOOL_WINDOW_MANAGER_CONTENT_CONTAINER", new MyDoggyManagerMainContainerComponentCreator());
        this.cmpCreators.put("DESKTOP_CONTENT_PANE", new DesktopContentPaneComponentCreator());
        this.cmpCreators.put("TOOL_WINDOW_TITLE_BAR", new ToolWindowTitleBarComponentCreator());
        this.cmpCreators.put("TOOL_WINDOW_TITLE_BUTTON", new ToolWindowTitleButtonComponentCreator());
        this.cmpCreators.put("TOOL_SCROLL_BAR_ARROW", new ToolScrollBarArrowComponentCreator());
        this.cmpCreators.put("TOOL_WINDOW_CONTAINER", new ToolWindowCmpContainerComponentCreator());
        this.cmpCreators.put("MULTI_SPLIT_CONTAINER_SPLIT", new ObjectCreator<Component>(){

            @Override
            public Component create(Context context) {
                return new JSplitPane((Integer)context.get("newOrientation"));
            }
        });
        this.cmpUiCreators = new Hashtable<String, ObjectCreator<ComponentUI>>();
        this.cmpUiCreators.put("REPRESENTATIVE_ANCHOR_BUTTON_UI", new RepresentativeAnchorButtonComponentUICreator());
        this.cmpUiCreators.put("TOOL_WINDOW_TITLE_BAR_UI", new ToolWindowTitleBarComponentUICreator());
        this.cmpCustomizers = new Hashtable<String, ObjectCustomizer<Component>>();
        this.cmpCustomizers.put("TOOL_WINDOW_MANAGER", new MyDoggyManagerPanelComponentCustomizer());
        this.cmpCustomizers.put("TOOL_WINDOW_CONTAINER", new ToolWindowCmpContainerComponentCustomizer());
        this.instanceCreators = new Hashtable<Class, ObjectCreator>();
        this.instanceCreators.put(TitleBarButtons.class, new TitleBarButtonsInstanceCreator());
        this.instanceCreators.put(ParentOfQuestion.class, new ParentOfQuestionInstanceCreator());
    }

    protected ResourceBundle initResourceBundle(Locale locale, String bundle, ClassLoader classLoader) {
        ResourceBundle result;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            result = classLoader == null ? ResourceBundle.getBundle(bundle, locale) : ResourceBundle.getBundle(bundle, locale, classLoader);
        }
        catch (Throwable e) {
            e.printStackTrace();
            result = new DummyResourceBundle();
        }
        return result;
    }

    protected void initTransparencyManager() {
        this.setTransparencyManager(new WindowTransparencyManager());
    }

    public static class ParentOfQuestionInstanceCreator
    implements ObjectCreator {
        public Object create(Context context) {
            return new ParentOfQuestion(context.get(Component.class));
        }
    }

    public static class TitleBarButtonsInstanceCreator
    implements ObjectCreator {
        public Object create(Context context) {
            return new DefaultTitleBarButtons(context.get(ToolWindowDescriptor.class), context.get(ToolWindowContainer.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToolWindowCmpContainerComponentCustomizer
    implements ObjectCustomizer<Component> {
        @Override
        public Component customize(Component component, Context context) {
            JPanel panel = (JPanel)component;
            panel.setBorder(new LineBorder(Color.GRAY, 1, true, 3, 3));
            return panel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyDoggyManagerPanelComponentCustomizer
    implements ObjectCustomizer<Component> {
        @Override
        public Component customize(Component component, Context context) {
            return component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToolWindowTitleBarComponentUICreator
    implements ObjectCreator<ComponentUI> {
        @Override
        public ComponentUI create(Context context) {
            return new ToolWindowTitleBarUI(context.get(ToolWindowDescriptor.class), context.get(ToolWindowContainer.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RepresentativeAnchorButtonComponentUICreator
    implements ObjectCreator<ComponentUI> {
        @Override
        public ComponentUI create(Context context) {
            return new ToolWindowRepresentativeAnchorUI(context.get(ToolWindowDescriptor.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToolScrollBarArrowComponentCreator
    implements ObjectCreator<Component> {
        @Override
        public Component create(Context context) {
            ResourceManager resourceManager = context.get(ResourceManager.class);
            JLabel label = new JLabel(){

                public void setUI(LabelUI ui) {
                    if (ui instanceof ToolScrollBarArrowUI) {
                        super.setUI(ui);
                    }
                }
            };
            label.setUI(new ToolScrollBarArrowUI(resourceManager));
            label.setPreferredSize(new Dimension(16, 16));
            label.setHorizontalAlignment(0);
            label.setVerticalAlignment(0);
            label.setOpaque(false);
            label.setFocusable(false);
            label.setBackground(Colors.orange);
            label.setIcon(resourceManager.getIcon((String)context.get("icon")));
            return label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyDoggyManagerMainContainerComponentCreator
    implements ObjectCreator<Component> {
        @Override
        public Component create(Context context) {
            JPanel panel = new JPanel();
            panel.setBackground(Color.GRAY);
            return panel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToolWindowTitleButtonComponentCreator
    implements ObjectCreator<Component> {
        @Override
        public Component create(Context context) {
            ToolWindowActiveButton button = new ToolWindowActiveButton();
            ((AbstractButton)button).setUI((ButtonUI)BasicButtonUI.createUI(button));
            return button;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToolWindowTitleBarComponentCreator
    implements ObjectCreator<Component> {
        @Override
        public Component create(Context context) {
            JPanel titleBar = new JPanel(){

                public void setUI(PanelUI ui) {
                    if (ui instanceof ToolWindowTitleBarUI) {
                        super.setUI(ui);
                    }
                }
            };
            titleBar.setBorder(null);
            titleBar.setUI((PanelUI)context.get(ResourceManager.class).createComponentUI("TOOL_WINDOW_TITLE_BAR_UI", context));
            return titleBar;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DesktopContentPaneComponentCreator
    implements ObjectCreator<Component> {
        @Override
        public Component create(Context context) {
            JDesktopPane desktopPane = new JDesktopPane();
            desktopPane.setDesktopManager(new ContentDesktopManager());
            return desktopPane;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CornerContentPaneComponentCreator
    implements ObjectCreator<Component> {
        @Override
        public Component create(Context context) {
            return new JPanel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BarContentPaneComponentCreator
    implements ObjectCreator<Component> {
        @Override
        public Component create(Context context) {
            return new JPanel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BarSplitPaneComponentCreator
    implements ObjectCreator<Component> {
        @Override
        public Component create(Context context) {
            DebugSplitPane splitPane = new DebugSplitPane((Integer)context.get("newOrientation"));
            splitPane.setBorder(null);
            splitPane.setContinuousLayout(true);
            splitPane.setDividerSize(0);
            ((JSplitPane)splitPane).setDividerLocation(300);
            splitPane.setLeftComponent(null);
            splitPane.setRightComponent(null);
            return splitPane;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToolWindowCmpContainerComponentCreator
    implements ObjectCreator<Component> {
        @Override
        public Component create(Context context) {
            JPanel panel = new JPanel();
            panel.setBorder(new LineBorder(Color.GRAY, 1, true, 3, 3));
            return panel;
        }
    }
}

