/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.drag;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.GlassPanel;
import org.noos.xing.mydoggy.plaf.ui.drag.DragAndDropLock;
import org.noos.xing.mydoggy.plaf.ui.drag.DragGesture;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public abstract class DragGestureAdapter
implements DragGesture,
Cleaner {
    protected DockableDescriptor descriptor;
    protected MyDoggyToolWindowManager manager;
    protected BufferedImage ghostImage;
    protected BufferedImage updatedGhostImage;

    protected DragGestureAdapter(DockableDescriptor descriptor) {
        this.descriptor = descriptor;
        this.manager = descriptor.getManager();
    }

    protected DragGestureAdapter(MyDoggyToolWindowManager manager) {
        this.manager = manager;
    }

    public void cleanup() {
        this.descriptor = null;
        this.manager = null;
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
    }

    public void dragMouseMoved(DragSourceDragEvent dsde) {
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    protected boolean acquireLocks() {
        if (DragAndDropLock.isLocked()) {
            DragAndDropLock.setDragAndDropStarted(false);
            return false;
        }
        DragAndDropLock.setLocked(true);
        DragAndDropLock.setDragAndDropStarted(true);
        return true;
    }

    protected boolean checkStatus() {
        return DragAndDropLock.isDragAndDropStarted() && this.ghostImage != null;
    }

    protected void releaseLocks() {
        this.releaseLocksOne();
        this.releaseLocksTwo();
    }

    protected void releaseLocksOne() {
        DragAndDropLock.setDragAndDropStarted(false);
    }

    protected void releaseLocksTwo() {
        DragAndDropLock.setLocked(false);
    }

    protected void setGhostImage(Point point, BufferedImage ghostImage) {
        this.updateGhostImage(point, ghostImage);
        this.ghostImage = ghostImage;
    }

    protected void updateGhostImage(Point point, BufferedImage ghostImage) {
        GlassPanel glassPane = this.manager.getGlassPanel();
        glassPane.setVisible(true);
        glassPane.setPoint(SwingUtil.convertPointFromScreen(point, glassPane));
        glassPane.setDraggingImage(ghostImage);
        glassPane.repaint();
        this.updatedGhostImage = ghostImage;
    }

    protected void updateGhostImage(Point point) {
        GlassPanel glassPane = this.manager.getGlassPanel();
        glassPane.setPoint(SwingUtil.convertPointFromScreen(point, glassPane));
        glassPane.repaint();
    }

    protected void resetGhostImage() {
        GlassPanel glassPane = this.manager.getGlassPanel();
        Rectangle dirtyRegion = glassPane.getRepaintRect();
        glassPane.setDraggingImage(null);
        glassPane.repaint(dirtyRegion);
    }

    protected void cleanupGhostImage() {
        GlassPanel glassPane = this.manager.getGlassPanel();
        glassPane.setDraggingImage(null);
        glassPane.setVisible(false);
        this.ghostImage = null;
        SwingUtilities.getWindowAncestor(this.manager).repaint();
    }
}

