/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockablePanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.JTabbedContentPane;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitDockableContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitPane;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.LineBorder;
import org.noos.xing.mydoggy.plaf.ui.drag.DragGestureAdapter;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class MultiSplitTabbedContentContainer
extends MultiSplitDockableContainer {
    protected ContentPanel contentPanel;

    public MultiSplitTabbedContentContainer(MyDoggyToolWindowManager toolWindowManager) {
        super(toolWindowManager, 0);
        this.setStoreLayout(false);
        this.contentPanel = new ContentPanel("@@mydoggy.dockable.", 10);
        this.contentPanel.setDropTarget(new ContentDropTarget(this.contentPanel, toolWindowManager));
        this.add((Component)this.contentPanel, "0,0,FULL,FULL");
    }

    public Component[] getTabbedComponents() {
        Component component = this.contentPanel.getComponent();
        if (component instanceof MultiSplitPane) {
            return ((MultiSplitPane)component).getComponents();
        }
        return new Component[]{component};
    }

    protected Component getWrapperForComponent(Dockable dockable, Component component, MultiSplitDockableContainer.Action action) {
        if (this.isWrapRequest(dockable, action)) {
            return this.forceWrapperForComponent(dockable, component);
        }
        DockablePanel wrapper = new DockablePanel(dockable, component);
        wrapper.setName("@@mydoggy.dockable.panel");
        return wrapper;
    }

    protected Component forceWrapperForComponent(Dockable dockable, Component component) {
        JTabbedContentPane wrapper = new JTabbedContentPane();
        wrapper.setToolWindowManager(this.toolWindowManager);
        wrapper.setName("@@mydoggy.dockable.tabbedpane");
        wrapper.setFocusCycleRoot(true);
        wrapper.addTab((Content)dockable, (Component)new DockablePanel(dockable, component));
        SwingUtil.registerDragGesture(wrapper, new TabbedDragGesture(wrapper));
        return wrapper;
    }

    protected Component getComponentFromWrapper(Component wrapper) {
        if (wrapper instanceof JTabbedContentPane) {
            JTabbedContentPane tabbedPane = (JTabbedContentPane)wrapper;
            return ((DockablePanel)tabbedPane.getComponentAt(0)).getComponent();
        }
        if (wrapper instanceof DockablePanel) {
            return ((DockablePanel)wrapper).getComponent();
        }
        return wrapper;
    }

    protected Component getComponentFromWrapper(Component wrapper, Dockable dockable) {
        if (wrapper instanceof JTabbedContentPane) {
            JTabbedContentPane tabbedPane = (JTabbedContentPane)wrapper;
            return ((DockablePanel)tabbedPane.getComponentAt(tabbedPane.indexOfContent((Content)dockable))).getComponent();
        }
        if (wrapper instanceof DockablePanel) {
            return ((DockablePanel)wrapper).getComponent();
        }
        return wrapper;
    }

    protected void addToWrapper(Component wrapper, Dockable dockable, int aggregationIndexLocation, Component content) {
        if (wrapper instanceof JTabbedContentPane) {
            JTabbedContentPane tabbedContentPane = (JTabbedContentPane)wrapper;
            tabbedContentPane.addTab((Content)dockable, new DockablePanel(dockable, content), aggregationIndexLocation);
            tabbedContentPane.setSelectedIndex(aggregationIndexLocation < 0 || aggregationIndexLocation >= tabbedContentPane.getTabCount() ? tabbedContentPane.getTabCount() - 1 : aggregationIndexLocation);
        } else if (wrapper instanceof DockablePanel) {
            DockablePanel wrapperContainer = (DockablePanel)wrapper;
            JTabbedContentPane tabbedContentPane = (JTabbedContentPane)this.forceWrapperForComponent(wrapperContainer.getDockable(), wrapperContainer.getComponent());
            tabbedContentPane.addTab((Content)dockable, new DockablePanel(dockable, content), aggregationIndexLocation);
            tabbedContentPane.setSelectedIndex(aggregationIndexLocation < 0 || aggregationIndexLocation >= tabbedContentPane.getTabCount() ? tabbedContentPane.getTabCount() - 1 : aggregationIndexLocation);
            String leafName = this.getLeafName(wrapperContainer.getDockable());
            this.multiSplitPane.remove(this.multiSplitPane.getMultiSplitLayout().getChildMap().get(leafName));
            this.multiSplitPane.add(leafName, tabbedContentPane);
        } else {
            throw new IllegalArgumentException("Invalid Wrapper.");
        }
    }

    protected int removeFromWrapper(Component wrapperSource, Dockable dockable) {
        JTabbedContentPane tabbedPane = (JTabbedContentPane)wrapperSource;
        int index = tabbedPane.indexOfContent((Content)dockable);
        if (index != -1) {
            tabbedPane.removeTabAt(index);
            if (tabbedPane.getTabCount() == 1) {
                Content lastDockable = tabbedPane.getContentAt(0);
                if (!this.isWrapRequest((Dockable)tabbedPane.getContentAt(0), MultiSplitDockableContainer.Action.REMOVE_DOCK)) {
                    String leafName = this.getLeafName((Dockable)lastDockable);
                    this.multiSplitPane.remove(this.multiSplitPane.getMultiSplitLayout().getChildMap().get(leafName));
                    this.multiSplitPane.add(leafName, this.getWrapperForComponent((Dockable)lastDockable, ((DockablePanel)tabbedPane.getComponentAt(0)).getComponent(), MultiSplitDockableContainer.Action.REMOVE_DOCK));
                }
            }
            return index;
        }
        throw new IllegalArgumentException("Cannot find that dockable on the passed tabbedpane");
    }

    protected Component getRootComponent() {
        return this.contentPanel.getComponent();
    }

    protected void setRootComponent(Component component) {
        this.contentPanel.setComponent(component);
    }

    protected void resetRootComponent() {
        this.contentPanel.resetComponent();
    }

    protected boolean isWrapper(Component component) {
        return component instanceof JTabbedContentPane;
    }

    protected class ContentDropTargetListener
    implements DropTargetListener,
    PropertyChangeListener {
        protected ToolWindowManager toolWindowManager;
        protected JComponent component;
        protected Component dockableWrapper;
        protected Dockable onDockable;
        protected int indexAtLocation;
        protected ToolWindowAnchor dragAnchor;
        protected Border oldBorder;
        protected Border dragBorder = new LineBorder(Color.BLUE, 3);

        public ContentDropTargetListener(JComponent component, ToolWindowManager toolWindowManager) {
            this.component = component;
            this.toolWindowManager = toolWindowManager;
            this.component.addPropertyChangeListener("dragAnchor", this);
            this.component.addPropertyChangeListener("dragToolWindow", this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("dragAnchor".equals(propertyName)) {
                this.dragAnchor = (ToolWindowAnchor)evt.getNewValue();
            } else {
                this.onDockable = null;
            }
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (this.checkEvent(dtde)) {
                this.onDockable = null;
                dtde.acceptDrag(dtde.getDropAction());
                if (this.component.getBorder() != this.dragBorder) {
                    this.oldBorder = this.component.getBorder();
                }
                this.putProperty("dragStart");
            } else {
                dtde.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
            if (!this.checkEvent(dtde)) {
                return;
            }
            Point location = dtde.getLocation();
            this.component.putClientProperty("dragOver", location);
            Component deepestCmp = SwingUtilities.getDeepestComponentAt(this.component, location.x, location.y);
            if (deepestCmp != null) {
                this.dockableWrapper = SwingUtil.getParent(deepestCmp, "@@mydoggy.dockable.");
                if (this.dockableWrapper != null) {
                    if (this.dockableWrapper instanceof JTabbedContentPane) {
                        JTabbedContentPane tabbedContentPane = (JTabbedContentPane)this.dockableWrapper;
                        Point locationOnDeepest = SwingUtilities.convertPoint(this.component, location, this.dockableWrapper);
                        this.indexAtLocation = tabbedContentPane.indexAtLocation(locationOnDeepest.x, locationOnDeepest.y);
                        DockablePanel dockablePanel = SwingUtil.getParent(deepestCmp, DockablePanel.class);
                        this.onDockable = dockablePanel != null ? SwingUtil.getParent(deepestCmp, DockablePanel.class).getDockable() : (this.indexAtLocation != -1 ? ((DockablePanel)tabbedContentPane.getComponentAt(this.indexAtLocation)).getDockable() : ((DockablePanel)tabbedContentPane.getComponentAt(0)).getDockable());
                    } else if (this.dockableWrapper instanceof DockablePanel) {
                        this.onDockable = ((DockablePanel)this.dockableWrapper).getDockable();
                        this.indexAtLocation = -1;
                    } else {
                        this.onDockable = null;
                        this.indexAtLocation = -1;
                    }
                } else {
                    this.onDockable = null;
                    this.indexAtLocation = -1;
                }
            } else {
                this.dockableWrapper = null;
                this.onDockable = null;
                this.indexAtLocation = -1;
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
            if (this.checkEvent(dtde)) {
                this.dragEnter(dtde);
            }
        }

        public void dragExit(DropTargetEvent dte) {
            this.onDockable = null;
            this.oldBorder = null;
            this.putProperty("dragExit");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dtde) {
            block18: {
                try {
                    if (dtde.getDropAction() == 2) {
                        if (dtde.getTransferable().isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF)) {
                            try {
                                ContentManager contentManager = this.toolWindowManager.getContentManager();
                                Content content = contentManager.getContent(dtde.getTransferable().getTransferData(MyDoggyTransferable.CONTENT_ID_DF));
                                if (content != null) {
                                    boolean rejectDrop = false;
                                    if (content == this.onDockable) {
                                        DockablePanel dockablePanel;
                                        if (this.indexAtLocation == -1) {
                                            rejectDrop = true;
                                        } else if (this.dockableWrapper instanceof JTabbedContentPane) {
                                            JTabbedContentPane tabbedContentPane = (JTabbedContentPane)this.dockableWrapper;
                                            int size = tabbedContentPane.getTabCount();
                                            for (int i = 0; i < size; ++i) {
                                                DockablePanel dockablePanel2 = (DockablePanel)tabbedContentPane.getComponentAt(i);
                                                if (dockablePanel2.getDockable() != this.onDockable || i != this.indexAtLocation) continue;
                                                rejectDrop = true;
                                                break;
                                            }
                                        } else if (this.dockableWrapper instanceof DockablePanel && (dockablePanel = (DockablePanel)this.dockableWrapper).getDockable() == this.onDockable) {
                                            rejectDrop = true;
                                        }
                                    }
                                    if (rejectDrop) {
                                        dtde.dropComplete(false);
                                    } else {
                                        MultiSplitTabbedContentContainer.this.setConstraints((Dockable)content, content.getComponent(), this.onDockable, this.indexAtLocation, this.dragAnchor == null ? null : AggregationPosition.valueOf((String)this.dragAnchor.toString()));
                                        dtde.dropComplete(true);
                                    }
                                    break block18;
                                }
                                dtde.dropComplete(false);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                dtde.dropComplete(false);
                            }
                            break block18;
                        }
                        dtde.rejectDrop();
                        break block18;
                    }
                    dtde.rejectDrop();
                }
                finally {
                    this.putProperty("dragEnd");
                    this.dragExit(dtde);
                }
            }
        }

        protected void putProperty(String name) {
            Boolean value = (Boolean)this.component.getClientProperty(name);
            if (value != null) {
                this.component.putClientProperty(name, value == false);
            } else {
                this.component.putClientProperty(name, false);
            }
        }

        protected boolean checkEvent(DropTargetDragEvent dtde) {
            Transferable transferable = dtde.getTransferable();
            try {
                if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_MANAGER) && System.identityHashCode(this.toolWindowManager) == (Integer)transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_MANAGER) && transferable.isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF)) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }
    }

    protected class ContentDropTarget
    extends DropTarget {
        public ContentDropTarget(JComponent component, ToolWindowManager toolWindowManager) throws HeadlessException {
            super(component, 2, new ContentDropTargetListener(component, toolWindowManager));
        }
    }

    protected class TabbedDragGesture
    extends DragGestureAdapter {
        protected JTabbedContentPane dockableTabbedPane;

        public TabbedDragGesture(JTabbedContentPane dockableTabbedPane) {
            super(MultiSplitTabbedContentContainer.this.toolWindowManager);
            this.dockableTabbedPane = dockableTabbedPane;
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            if (!this.acquireLocks()) {
                return;
            }
            Point origin = dge.getDragOrigin();
            int index = this.dockableTabbedPane.indexAtLocation(origin.x, origin.y);
            if (index != -1) {
                Content dockable = this.dockableTabbedPane.getContentAt(index);
                if (dockable != null) {
                    dge.startDrag(Cursor.getDefaultCursor(), new MyDoggyTransferable(this.manager, MyDoggyTransferable.CONTENT_ID_DF, dockable.getId()), this);
                    if (MultiSplitTabbedContentContainer.this.resourceManager.getBoolean("drag.icon.useDefault", false)) {
                        this.setGhostImage(dge.getDragOrigin(), MultiSplitTabbedContentContainer.this.resourceManager.getBufferedImage("DRAG"));
                    } else {
                        Component component = this.dockableTabbedPane.getComponentAt(index);
                        BufferedImage ghostImage = new BufferedImage(component.getWidth(), component.getHeight(), 1);
                        component.print(ghostImage.getGraphics());
                        ghostImage = GraphicsUtil.scale(ghostImage, component.getWidth() / 4, component.getHeight() / 4);
                        this.setGhostImage(dge.getDragOrigin(), ghostImage);
                    }
                } else {
                    this.releaseLocks();
                }
            } else {
                this.releaseLocks();
            }
        }

        public void dragMouseMoved(DragSourceDragEvent dsde) {
            if (!this.checkStatus()) {
                return;
            }
            this.updateGhostImage(dsde.getLocation());
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (!this.checkStatus()) {
                return;
            }
            this.releaseLocks();
            this.cleanupGhostImage();
        }
    }
}

