/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.SwingPropertyChangeSupport;
import org.noos.xing.mydoggy.FloatingTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.TitleBarButtons;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowContainer;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class DefaultTitleBarButtons
extends JPanel
implements TitleBarButtons,
Cleaner {
    protected ToolWindow toolWindow;
    protected ToolWindowDescriptor descriptor;
    protected transient ResourceManager resourceManager;
    protected ToolWindowContainer dockedContainer;
    protected TableLayout containerLayout;
    protected Component focusable;
    protected PropertyChangeSupport propertyChangeSupport;

    public DefaultTitleBarButtons(ToolWindowDescriptor toolWindowDescriptor, ToolWindowContainer dockedContainer) {
        this.descriptor = toolWindowDescriptor;
        this.toolWindow = toolWindowDescriptor.getToolWindow();
        this.resourceManager = dockedContainer.getResourceManager();
        this.dockedContainer = dockedContainer;
        this.propertyChangeSupport = new SwingPropertyChangeSupport(this);
        this.descriptor.getCleaner().addCleaner(this);
        this.initComponents();
        this.initListeners();
    }

    public void cleanup() {
        this.descriptor = null;
        this.toolWindow = null;
        this.dockedContainer = null;
        this.resourceManager = null;
    }

    public Component getFocusable() {
        return this.focusable;
    }

    public Component getComponent() {
        return this;
    }

    public void setType(ToolWindowType type) {
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "type", null, type));
    }

    protected void initComponents() {
        this.containerLayout = new ExtendedTableLayout(new double[][]{{0.0, 0.0}, {1.0, 14.0, 1.0}}, false);
        this.setLayout((LayoutManager)this.containerLayout);
        this.setOpaque(false);
        this.addTitleBarAction(new DockAction());
        this.addTitleBarAction(new FloatingAction());
        this.addTitleBarAction(new PinAction());
        this.addTitleBarAction(new MaximizeAction());
        this.focusable = this.addTitleBarAction(new HideAction());
    }

    protected void initListeners() {
    }

    protected Component addTitleBarAction(TitleBarAction titleBarAction) {
        return this.addTitleBarAction(-1, titleBarAction);
    }

    protected Component addTitleBarAction(int index, TitleBarAction titleBarAction) {
        int row;
        double[] newCols;
        if (index == -1) {
            double[] oldCols = this.containerLayout.getColumn();
            if (oldCols.length == 2) {
                newCols = new double[]{0.0, 13.0, 0.0};
                row = 1;
            } else {
                newCols = new double[oldCols.length + 2];
                System.arraycopy(oldCols, 0, newCols, 0, oldCols.length);
                newCols[oldCols.length - 1] = 1.0;
                newCols[oldCols.length] = 13.0;
                newCols[oldCols.length + 1] = 0.0;
                row = oldCols.length;
            }
        } else {
            throw new IllegalStateException("Not implemented yet!!!");
        }
        this.containerLayout.setColumn(newCols);
        JButton button = (JButton)this.resourceManager.createComponent("TOOL_WINDOW_TITLE_BUTTON", this.descriptor.getManager().getContext());
        button.setAction(titleBarAction);
        button.setName((String)titleBarAction.getValue("action.name"));
        titleBarAction.putValue("component", button);
        this.add((Component)button, row + ",1,FULL,FULL");
        return button;
    }

    protected void setVisible(Component component, boolean visible) {
        for (Component cmp : this.getComponents()) {
            int col;
            if (cmp != component) continue;
            if (visible) {
                col = this.containerLayout.getConstraints((Component)component).col1;
                this.containerLayout.setColumn(col, 13.0);
                if (col == this.containerLayout.getColumn().length - 1) continue;
                this.containerLayout.setColumn(col + 1, 1.0);
                continue;
            }
            col = this.containerLayout.getConstraints((Component)component).col1;
            this.containerLayout.setColumn(col, 0.0);
            if (col == this.containerLayout.getColumn().length - 1) continue;
            this.containerLayout.setColumn(col + 1, 0.0);
        }
    }

    protected class FloatingAction
    extends TitleBarAction {
        protected ToolWindowType oldType;

        public FloatingAction() {
            super("toolWindow.floatingButton." + DefaultTitleBarButtons.this.toolWindow.getId(), "FLOATING_INACTIVE", "@@tool.tooltip.float");
            DefaultTitleBarButtons.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING).addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("enabled".equals(evt.getPropertyName())) {
                        FloatingAction.this.setVisible((Boolean)evt.getNewValue());
                    }
                }
            });
            DefaultTitleBarButtons.this.dockedContainer.addPropertyChangeListener("type", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getSource() != DefaultTitleBarButtons.this.descriptor || evt.getNewValue() != ToolWindowType.FLOATING && evt.getNewValue() != ToolWindowType.FLOATING_FREE) {
                        return;
                    }
                    FloatingAction.this.oldType = (ToolWindowType)evt.getOldValue();
                }
            });
            DefaultTitleBarButtons.this.dockedContainer.addPropertyChangeListener("active", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getSource() != DefaultTitleBarButtons.this.descriptor) {
                        return;
                    }
                    boolean active = (Boolean)evt.getNewValue();
                    if (active) {
                        if (DefaultTitleBarButtons.this.toolWindow.getType() == ToolWindowType.FLOATING || DefaultTitleBarButtons.this.toolWindow.getType() == ToolWindowType.FLOATING_FREE) {
                            FloatingAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("FIX"));
                        } else {
                            FloatingAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("FLOATING"));
                        }
                    } else if (DefaultTitleBarButtons.this.toolWindow.getType() == ToolWindowType.FLOATING || DefaultTitleBarButtons.this.toolWindow.getType() == ToolWindowType.FLOATING_FREE) {
                        FloatingAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("FIX_INACTIVE"));
                    } else {
                        FloatingAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("FLOATING_INACTIVE"));
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            DefaultTitleBarButtons.this.toolWindow.setActive(true);
            ToolWindowType type = DefaultTitleBarButtons.this.toolWindow.getType();
            switch (type) {
                case FLOATING: 
                case FLOATING_FREE: {
                    DefaultTitleBarButtons.this.toolWindow.setType(this.oldType != null ? this.oldType : ToolWindowType.DOCKED);
                    break;
                }
                default: {
                    DefaultTitleBarButtons.this.toolWindow.setType(DefaultTitleBarButtons.this.descriptor.isFloatingWindow() ? ToolWindowType.FLOATING_FREE : ToolWindowType.FLOATING);
                }
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowType type = (ToolWindowType)evt.getNewValue();
            switch (type) {
                case DOCKED: 
                case FLOATING_LIVE: {
                    this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("FLOATING"));
                    this.putValue("ShortDescription", DefaultTitleBarButtons.this.resourceManager.getString("@@tool.tooltip.float"));
                    this.setVisible(DefaultTitleBarButtons.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING).isEnabled());
                    break;
                }
                case SLIDING: {
                    this.setVisible(DefaultTitleBarButtons.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING).isEnabled());
                    break;
                }
                case FLOATING: 
                case FLOATING_FREE: {
                    this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("FIX"));
                    this.putValue("ShortDescription", DefaultTitleBarButtons.this.resourceManager.getString("@@tool.tooltip.fix"));
                    this.setVisible(true);
                }
            }
        }
    }

    protected class MaximizeAction
    extends TitleBarAction {
        public MaximizeAction() {
            super("toolWindow.maximizeButton." + DefaultTitleBarButtons.this.toolWindow.getId(), "MAXIMIZE_INACTIVE", "@@tool.tooltip.maximize");
            DefaultTitleBarButtons.this.dockedContainer.addPropertyChangeListener("maximized.before", new PropertyChangeListener(){
                private boolean flag = false;

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getSource() != DefaultTitleBarButtons.this.descriptor) {
                        return;
                    }
                    if (((Boolean)evt.getNewValue()).booleanValue()) {
                        MaximizeAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("MINIMIZE"));
                        this.flag = true;
                    } else if (this.flag) {
                        MaximizeAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("MAXIMIZE"));
                        this.flag = false;
                    }
                }
            });
            DefaultTitleBarButtons.this.dockedContainer.addPropertyChangeListener("active", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getSource() != DefaultTitleBarButtons.this.descriptor) {
                        return;
                    }
                    boolean active = (Boolean)evt.getNewValue();
                    if (active) {
                        if (DefaultTitleBarButtons.this.toolWindow.isMaximized()) {
                            MaximizeAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("MINIMIZE"));
                        } else {
                            MaximizeAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("MAXIMIZE"));
                        }
                    } else if (DefaultTitleBarButtons.this.toolWindow.isMaximized()) {
                        MaximizeAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("MINIMIZE_INACTIVE"));
                    } else {
                        MaximizeAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("MAXIMIZE_INACTIVE"));
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            DefaultTitleBarButtons.this.toolWindow.setActive(true);
            DefaultTitleBarButtons.this.toolWindow.setMaximized(!DefaultTitleBarButtons.this.toolWindow.isMaximized());
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    protected class PinAction
    extends TitleBarAction {
        public PinAction() {
            super("toolWindow.pinButton." + DefaultTitleBarButtons.this.toolWindow.getId(), "AUTO_HIDE_OFF_INACTIVE", "@@tool.tooltip.unpin");
            DefaultTitleBarButtons.this.dockedContainer.addPropertyChangeListener("autoHide", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    boolean newValue = (Boolean)evt.getNewValue();
                    if (newValue) {
                        PinAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("AUTO_HIDE_ON"));
                        PinAction.this.putValue("LongDescription", DefaultTitleBarButtons.this.resourceManager.getString("@@tool.tooltip.pin"));
                    } else {
                        PinAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("AUTO_HIDE_OFF"));
                        PinAction.this.putValue("LongDescription", DefaultTitleBarButtons.this.resourceManager.getString("@@tool.tooltip.unpin"));
                    }
                }
            });
            DefaultTitleBarButtons.this.dockedContainer.addPropertyChangeListener("active", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getSource() != DefaultTitleBarButtons.this.descriptor) {
                        return;
                    }
                    boolean active = (Boolean)evt.getNewValue();
                    if (active) {
                        if (DefaultTitleBarButtons.this.toolWindow.isAutoHide()) {
                            PinAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("AUTO_HIDE_ON"));
                        } else {
                            PinAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("AUTO_HIDE_OFF"));
                        }
                    } else if (DefaultTitleBarButtons.this.toolWindow.isAutoHide()) {
                        PinAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("AUTO_HIDE_ON_INACTIVE"));
                    } else {
                        PinAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("AUTO_HIDE_OFF_INACTIVE"));
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            DefaultTitleBarButtons.this.toolWindow.setActive(true);
            DefaultTitleBarButtons.this.toolWindow.setAutoHide(!DefaultTitleBarButtons.this.toolWindow.isAutoHide());
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowType type = (ToolWindowType)evt.getNewValue();
            switch (type) {
                case DOCKED: 
                case FLOATING_LIVE: {
                    this.setVisible(true);
                    break;
                }
                case SLIDING: {
                    this.setVisible(false);
                    break;
                }
                case FLOATING: 
                case FLOATING_FREE: {
                    this.setVisible(!((FloatingTypeDescriptor)DefaultTitleBarButtons.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING)).isModal());
                }
            }
        }
    }

    protected class DockAction
    extends TitleBarAction {
        public DockAction() {
            super("toolWindow.dockButton." + DefaultTitleBarButtons.this.toolWindow.getId(), "DOCKED_INACTIVE", "@@tool.tooltip.undock");
            DefaultTitleBarButtons.this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING).addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("enabled".equals(evt.getPropertyName())) {
                        DockAction.this.setVisible((Boolean)evt.getNewValue());
                    }
                }
            });
            DefaultTitleBarButtons.this.dockedContainer.addPropertyChangeListener("active", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getSource() != DefaultTitleBarButtons.this.descriptor) {
                        return;
                    }
                    boolean active = (Boolean)evt.getNewValue();
                    if (active) {
                        if (DefaultTitleBarButtons.this.toolWindow.getType() == ToolWindowType.SLIDING || DefaultTitleBarButtons.this.toolWindow.getType() == ToolWindowType.FLOATING_LIVE) {
                            DockAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("DOCKED"));
                        } else {
                            DockAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("SLIDING"));
                        }
                    } else if (DefaultTitleBarButtons.this.toolWindow.getType() == ToolWindowType.SLIDING || DefaultTitleBarButtons.this.toolWindow.getType() == ToolWindowType.FLOATING_LIVE) {
                        DockAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("DOCKED_INACTIVE"));
                    } else {
                        DockAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("SLIDING_INACTIVE"));
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            DefaultTitleBarButtons.this.toolWindow.setActive(true);
            ToolWindowType type = DefaultTitleBarButtons.this.toolWindow.getType();
            if (type == ToolWindowType.DOCKED) {
                DefaultTitleBarButtons.this.toolWindow.setType(ToolWindowType.SLIDING);
            } else if (type == ToolWindowType.SLIDING || type == ToolWindowType.FLOATING_LIVE) {
                DefaultTitleBarButtons.this.toolWindow.setType(ToolWindowType.DOCKED);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowType type = (ToolWindowType)evt.getNewValue();
            switch (type) {
                case DOCKED: {
                    this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("SLIDING"));
                    this.putValue("ShortDescription", DefaultTitleBarButtons.this.resourceManager.getString("@@tool.tooltip.undock"));
                    this.setVisible(DefaultTitleBarButtons.this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING).isEnabled());
                    break;
                }
                case FLOATING_LIVE: {
                    this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("DOCKED"));
                    this.putValue("ShortDescription", DefaultTitleBarButtons.this.resourceManager.getString("@@tool.tooltip.dock"));
                    this.setVisible(DefaultTitleBarButtons.this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING).isEnabled());
                    break;
                }
                case SLIDING: {
                    this.putValue("ShortDescription", DefaultTitleBarButtons.this.resourceManager.getString("@@tool.tooltip.dock"));
                    this.setVisible(DefaultTitleBarButtons.this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING).isEnabled());
                    break;
                }
                case FLOATING: 
                case FLOATING_FREE: {
                    this.setVisible(false);
                }
            }
        }
    }

    protected class HideAction
    extends TitleBarAction {
        public HideAction() {
            super("toolWindow.hideButton." + DefaultTitleBarButtons.this.toolWindow.getId(), "HIDE_TOOL_WINDOW_INACTIVE", "@@tool.tooltip.hide");
            DefaultTitleBarButtons.this.dockedContainer.addPropertyChangeListener("active", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getSource() != DefaultTitleBarButtons.this.descriptor) {
                        return;
                    }
                    boolean active = (Boolean)evt.getNewValue();
                    if (active) {
                        HideAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("HIDE_TOOL_WINDOW"));
                    } else {
                        HideAction.this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon("HIDE_TOOL_WINDOW_INACTIVE"));
                    }
                }
            });
        }

        public void actionPerformed(ActionEvent e) {
            DefaultTitleBarButtons.this.descriptor.hideToolWindow();
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    protected abstract class TitleBarAction
    extends AbstractAction
    implements PropertyChangeListener {
        protected TitleBarAction() {
            DefaultTitleBarButtons.this.propertyChangeSupport.addPropertyChangeListener(this);
        }

        protected TitleBarAction(String name, String icon, String tooltip) {
            this.putValue("action.name", name);
            this.putValue("SmallIcon", DefaultTitleBarButtons.this.resourceManager.getIcon(icon));
            this.putValue("ShortDescription", DefaultTitleBarButtons.this.resourceManager.getString(tooltip));
            DefaultTitleBarButtons.this.propertyChangeSupport.addPropertyChangeListener(this);
        }

        public void setVisible(boolean visible) {
            DefaultTitleBarButtons.this.setVisible((Component)this.getValue("component"), visible);
            SwingUtil.repaint(DefaultTitleBarButtons.this);
        }
    }
}

