/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.animation;

import java.awt.Component;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.TranslucentComponent;
import org.noos.xing.mydoggy.plaf.ui.transparency.TransparencyManager;

public class TransparencyAnimation
extends AbstractAnimation {
    private final TransparencyManager<Component> transparencyManager;
    private Component component;
    private float alpha;

    public TransparencyAnimation(TransparencyManager transparencyManager, Component component, float alpha) {
        this(transparencyManager, component, alpha, 2000.0f);
    }

    public TransparencyAnimation(TransparencyManager transparencyManager, Component component, float alpha, float duration) {
        super(duration);
        this.transparencyManager = transparencyManager;
        this.component = component;
        this.alpha = alpha;
    }

    public TransparencyAnimation(TranslucentComponent translucentComponent, Component component, float alpha, float duration) {
        super(duration);
        this.transparencyManager = new Translucent2TransparencyManager(translucentComponent);
        this.component = component;
        this.alpha = alpha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected float onAnimating(float animationPercent) {
        if (this.getAnimationDirection() == AbstractAnimation.Direction.INCOMING) {
            double animatingLengthX = animationPercent * (1.0f - this.alpha);
            TransparencyManager<Component> transparencyManager = this.transparencyManager;
            synchronized (transparencyManager) {
                this.transparencyManager.setAlphaModeRatio(this.component, 1.0f - (float)animatingLengthX);
            }
        }
        return animationPercent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFinishAnimation() {
        TransparencyManager<Component> transparencyManager = this.transparencyManager;
        synchronized (transparencyManager) {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    this.transparencyManager.setAlphaModeRatio(this.component, this.alpha);
                    break;
                }
                case OUTGOING: {
                    this.transparencyManager.setAlphaModeRatio(this.component, 0.0f);
                }
            }
        }
    }

    protected void onHide(Object ... params) {
    }

    protected void onShow(Object ... params) {
    }

    protected void onStartAnimation(AbstractAnimation.Direction direction) {
    }

    protected AbstractAnimation.Direction chooseFinishDirection(AbstractAnimation.Type type) {
        return type == AbstractAnimation.Type.SHOW ? AbstractAnimation.Direction.OUTGOING : AbstractAnimation.Direction.INCOMING;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public TransparencyManager getTransparencyManager() {
        return this.transparencyManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Translucent2TransparencyManager
    implements TransparencyManager<Component> {
        protected TranslucentComponent translucentComponent;

        public Translucent2TransparencyManager(TranslucentComponent translucentComponent) {
            this.translucentComponent = translucentComponent;
        }

        @Override
        public boolean isServiceAvailable() {
            return true;
        }

        @Override
        public void setAlphaModeRatio(Component component, float transparency) {
            this.translucentComponent.setAlphaModeRatio(transparency);
        }

        @Override
        public boolean isAlphaModeEnabled(Component component) {
            return true;
        }
    }
}

