/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.FloatingLiveTypeDescriptor;
import org.noos.xing.mydoggy.FloatingTypeDescriptor;
import org.noos.xing.mydoggy.SlidingTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowActionHandler;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.ToolWindowTypeDescriptor;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindow;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowBar;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.cleaner.CleanerAggregator;
import org.noos.xing.mydoggy.plaf.cleaner.DefaultCleanerAggregator;
import org.noos.xing.mydoggy.plaf.descriptors.InternalTypeDescriptor;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.DockedContainer;
import org.noos.xing.mydoggy.plaf.ui.FloatingContainer;
import org.noos.xing.mydoggy.plaf.ui.FloatingLiveContainer;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.SlidingContainer;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.AggregateIcon;
import org.noos.xing.mydoggy.plaf.ui.cmp.TextIcon;
import org.noos.xing.mydoggy.plaf.ui.util.FindFocusableQuestion;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;

public class ToolWindowDescriptor
implements PropertyChangeListener,
DockableDescriptor {
    protected MyDoggyToolWindowManager manager;
    protected MyDoggyToolWindow toolWindow;
    protected CleanerAggregator cleaner;
    protected DockedContainer dockedContainer;
    protected FloatingContainer floatingContainer;
    protected SlidingContainer slidingContainer;
    protected FloatingLiveContainer floatingLiveContainer;
    protected Component component;
    protected JLabel representativeAnchor;
    protected int divederLocation = -1;
    protected int tempDivederLocation;
    protected FloatingTypeDescriptor floatingTypeDescriptor;
    protected DockedTypeDescriptor dockedTypeDescriptor;
    protected SlidingTypeDescriptor slidingTypeDescriptor;
    protected FloatingLiveTypeDescriptor floatingLiveTypeDescriptor;
    protected boolean floatingWindow = false;
    boolean valueAdj = false;

    public ToolWindowDescriptor(MyDoggyToolWindowManager manager, MyDoggyToolWindow toolWindow) {
        this.manager = manager;
        this.toolWindow = toolWindow;
        this.cleaner = new ToolWindowDescriptorCleaner();
        this.initListeners();
        this.initTypeDescriptors();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("type".equals(propertyName)) {
            if (evt.getOldValue() == ToolWindowType.FLOATING_FREE || evt.getNewValue() == ToolWindowType.FLOATING_FREE) {
                this.setFloatingWindow(true);
            } else if (evt.getOldValue() == ToolWindowType.FLOATING || evt.getNewValue() == ToolWindowType.FLOATING) {
                this.setFloatingWindow(false);
            }
        } else if ("index".equals(propertyName)) {
            this.updateRepresentativeAnchor();
        } else if ("numberingEnabled".equals(propertyName)) {
            this.updateRepresentativeAnchor();
        } else if ("icon".equals(propertyName)) {
            this.updateRepresentativeAnchor();
        } else if ("dockLength".equals(propertyName)) {
            if (!this.valueAdj) {
                this.divederLocation = (Integer)evt.getNewValue();
                this.getToolBar(this.toolWindow.getAnchor()).propertyChange(new PropertyChangeEvent(this.toolWindow, propertyName, evt.getOldValue(), evt.getNewValue()));
            }
        } else if ("idVisibleOnTitleBar".equals(propertyName)) {
            this.setIdOnTitleBar();
        } else if ("autoHide".equals(propertyName)) {
            this.getToolWindowContainer().propertyChange(evt);
        } else if ("hideRepresentativeButtonOnVisible".equals(propertyName) && this.toolWindow.isVisible()) {
            this.toolWindow.setRepresentativeAnchorButtonVisible((Boolean)evt.getNewValue() == false);
        }
    }

    public String toString() {
        return "ToolWindowDescriptor{toolWindow=" + this.toolWindow + '}';
    }

    public ToolWindowAnchor getAnchor() {
        return this.toolWindow.getAnchor();
    }

    public void setAvailable(boolean available) {
        this.toolWindow.setAvailable(available);
    }

    public boolean isAvailable() {
        return this.toolWindow.isAvailable();
    }

    public DockableDescriptor.DockableType getDockableType() {
        return DockableDescriptor.DockableType.TOOL_WINDOW;
    }

    public Dockable getDockable() {
        return this.toolWindow;
    }

    public JLabel getRepresentativeAnchor(Component parent) {
        if (this.representativeAnchor == null) {
            ToolWindowAnchor anchor = this.toolWindow.getAnchor();
            String labelText = this.getResourceManager().getUserString(this.toolWindow.getId());
            String toolRepresentativeAnchorText = this.toolWindow.getIndex() > 0 && this.getManager().getToolWindowManagerDescriptor().isNumberingEnabled() ? this.toolWindow.getIndex() + " : " + labelText : labelText;
            Icon toolIcon = this.toolWindow.isAvailable() || this.toolWindow.getIcon() == null ? this.toolWindow.getIcon() : new ImageIcon(GrayFilter.createDisabledImage(GraphicsUtil.getImage(this.representativeAnchor, this.toolWindow.getIcon())));
            switch (anchor) {
                case BOTTOM: 
                case TOP: {
                    this.representativeAnchor = new RepresentativeAnchor(toolRepresentativeAnchorText, toolIcon, 0);
                    break;
                }
                case LEFT: {
                    TextIcon textIcon = new TextIcon(parent, toolRepresentativeAnchorText, 2);
                    textIcon.setForeground(this.toolWindow.isAvailable() ? this.manager.getResourceManager().getColor("RAB_FOREGROUND") : this.manager.getResourceManager().getColor("RAB_FOREGROUND_UNAVAILABLE"));
                    AggregateIcon compositeIcon = new AggregateIcon(textIcon, toolIcon, 1);
                    this.representativeAnchor = new RepresentativeAnchor((Icon)compositeIcon, 0);
                    break;
                }
                case RIGHT: {
                    TextIcon textIcon = new TextIcon(parent, toolRepresentativeAnchorText, 3);
                    textIcon.setForeground(this.toolWindow.isAvailable() ? this.manager.getResourceManager().getColor("RAB_FOREGROUND") : this.manager.getResourceManager().getColor("RAB_FOREGROUND_UNAVAILABLE"));
                    AggregateIcon compositeIcon = new AggregateIcon(toolIcon, textIcon, 1);
                    this.representativeAnchor = new RepresentativeAnchor((Icon)compositeIcon, 0);
                }
            }
            this.representativeAnchor.setName("toolWindow.rb." + this.toolWindow.getId());
            this.representativeAnchor.setOpaque(this.toolWindow.isActive());
            this.representativeAnchor.setFocusable(false);
            this.representativeAnchor.putClientProperty(ToolWindowDescriptor.class, this);
        }
        return this.representativeAnchor;
    }

    public JLabel getRepresentativeAnchor() {
        return this.representativeAnchor;
    }

    public void resetRepresentativeAnchor() {
        if (this.representativeAnchor != null) {
            this.representativeAnchor.putClientProperty(ToolWindowDescriptor.class, null);
        }
        this.representativeAnchor = null;
    }

    public int getAnchorIndex() {
        if (this.representativeAnchor == null) {
            return -1;
        }
        return this.getToolBar().getRepresentativeAnchorIndex(this.representativeAnchor);
    }

    public void updateRepresentativeAnchor() {
        if (this.representativeAnchor != null) {
            ToolWindowAnchor anchor = this.toolWindow.getAnchor();
            String labelText = this.getResourceManager().getUserString(this.toolWindow.getId());
            String toolRepresentativeAnchorText = this.toolWindow.getIndex() > 0 && this.getManager().getToolWindowManagerDescriptor().isNumberingEnabled() ? this.toolWindow.getIndex() + " : " + labelText : labelText;
            Icon toolIcon = this.toolWindow.isAvailable() || this.toolWindow.getIcon() == null ? this.toolWindow.getIcon() : new ImageIcon(GrayFilter.createDisabledImage(GraphicsUtil.getImage(this.representativeAnchor, this.toolWindow.getIcon())));
            switch (anchor) {
                case BOTTOM: 
                case TOP: {
                    this.representativeAnchor.setIcon(toolIcon);
                    this.representativeAnchor.setText(toolRepresentativeAnchorText);
                    break;
                }
                case LEFT: {
                    TextIcon textIcon = new TextIcon(((TextIcon)((AggregateIcon)this.representativeAnchor.getIcon()).getLeftIcon()).getComponent(), toolRepresentativeAnchorText, 2);
                    textIcon.setForeground(this.toolWindow.isAvailable() ? this.manager.getResourceManager().getColor("RAB_FOREGROUND") : this.manager.getResourceManager().getColor("RAB_FOREGROUND_UNAVAILABLE"));
                    AggregateIcon compositeIcon = new AggregateIcon(textIcon, toolIcon, 1);
                    this.representativeAnchor.setText(null);
                    this.representativeAnchor.setIcon(compositeIcon);
                    break;
                }
                case RIGHT: {
                    TextIcon textIcon = new TextIcon(((TextIcon)((AggregateIcon)this.representativeAnchor.getIcon()).getRightIcon()).getComponent(), toolRepresentativeAnchorText, 3);
                    textIcon.setForeground(this.toolWindow.isAvailable() ? this.manager.getResourceManager().getColor("RAB_FOREGROUND") : this.manager.getResourceManager().getColor("RAB_FOREGROUND_UNAVAILABLE"));
                    AggregateIcon compositeIcon = new AggregateIcon(toolIcon, textIcon, 1);
                    this.representativeAnchor.setText(null);
                    this.representativeAnchor.setIcon(compositeIcon);
                }
            }
        }
    }

    public MyDoggyToolWindowManager getManager() {
        return this.manager;
    }

    public MyDoggyToolWindowBar getToolBar(ToolWindowAnchor anchor) {
        return this.manager.getBar(anchor);
    }

    public MyDoggyToolWindowBar getToolBar() {
        return this.manager.getBar(this.toolWindow.getAnchor());
    }

    public boolean isDragImageAvailable() {
        return true;
    }

    public Component getComponentForDragImage() {
        return ((DockedContainer)this.getToolWindowContainer()).getContentContainer();
    }

    public void setAnchor(ToolWindowAnchor anchor, int index) {
        this.toolWindow.setAnchor(anchor, index);
    }

    public ResourceManager getResourceManager() {
        return this.manager.getResourceManager();
    }

    public CleanerAggregator getCleaner() {
        return this.cleaner;
    }

    public void cleanup() {
        this.getCleaner().cleanup();
    }

    public Component getComponent() {
        if (this.component == null && this.toolWindow.getToolWindowTabs().length > 0) {
            this.component = this.toolWindow.getToolWindowTabs()[0].getComponent();
        }
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public int getDividerLocation() {
        if (this.divederLocation == -1) {
            this.divederLocation = ((DockedTypeDescriptor)this.getTypeDescriptor(ToolWindowType.DOCKED)).getDockLength();
        }
        return this.divederLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDividerLocation(int divederLocation) {
        if (divederLocation <= 0) {
            return;
        }
        this.divederLocation = divederLocation;
        DockedTypeDescriptor dockedTypeDescriptor = (DockedTypeDescriptor)this.toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
        this.valueAdj = true;
        try {
            dockedTypeDescriptor.setDockLength(divederLocation);
        }
        finally {
            this.valueAdj = false;
        }
    }

    public int getTempDivederLocation() {
        return this.tempDivederLocation;
    }

    public void setTempDivederLocation(int tempDivederLocation) {
        this.tempDivederLocation = tempDivederLocation;
    }

    public boolean isFloatingWindow() {
        return this.floatingWindow;
    }

    public void setFloatingWindow(boolean floatingWindow) {
        this.floatingWindow = floatingWindow;
    }

    public boolean isIdVisibleOnTitleBar() {
        switch (this.toolWindow.getType()) {
            case DOCKED: {
                return this.toolWindow.getTypeDescriptor(ToolWindowType.DOCKED).isIdVisibleOnTitleBar();
            }
            case SLIDING: {
                return this.toolWindow.getTypeDescriptor(ToolWindowType.SLIDING).isIdVisibleOnTitleBar();
            }
            case FLOATING: 
            case FLOATING_FREE: {
                return this.toolWindow.getTypeDescriptor(ToolWindowType.FLOATING).isIdVisibleOnTitleBar();
            }
            case FLOATING_LIVE: {
                return this.toolWindow.getTypeDescriptor(ToolWindowType.FLOATING_LIVE).isIdVisibleOnTitleBar();
            }
            case EXTERN: {
                return true;
            }
        }
        throw new IllegalStateException("ToolWindowDescriptor.isIdVisibleOnTitleBar");
    }

    public void setIdOnTitleBar() {
        if (this.dockedContainer != null) {
            if (this.isIdVisibleOnTitleBar()) {
                this.dockedContainer.enableIdOnTitleBar();
            } else {
                this.dockedContainer.disableIdOnTitleBar();
            }
        }
    }

    public void updateUI() {
        this.getToolWindowContainer().updateUI();
        SwingUtilities.updateComponentTreeUI(this.getComponent());
        for (ToolWindowTab tab : this.toolWindow.getToolWindowTabs()) {
            SwingUtilities.updateComponentTreeUI(tab.getComponent());
        }
        if (this.getRepresentativeAnchor() != null) {
            this.getRepresentativeAnchor().updateUI();
        }
    }

    public MyDoggyToolWindow getToolWindow() {
        return this.toolWindow;
    }

    public Rectangle getToolWindowManagerContainerBounds() {
        return SwingUtilities.convertRectangle(this.manager, this.manager.getBounds(), this.manager.getRootPaneContainer().getContentPane());
    }

    public Window getWindowAnchestor() {
        return this.manager.getWindowAnchestor() instanceof Window ? (Window)this.manager.getWindowAnchestor() : null;
    }

    public ToolWindowContainer getToolWindowContainer() {
        if (this.dockedContainer == null) {
            this.dockedContainer = new DockedContainer(this);
            this.slidingContainer = new SlidingContainer(this.dockedContainer);
            this.floatingContainer = new FloatingContainer(this.dockedContainer);
            this.floatingLiveContainer = new FloatingLiveContainer(this.dockedContainer);
        }
        return this.dockedContainer;
    }

    public ToolWindowContainer getToolWindowContainer(ToolWindowType toolWindowType) {
        if (this.dockedContainer == null) {
            this.getToolWindowContainer();
        }
        switch (toolWindowType) {
            case FLOATING: 
            case FLOATING_FREE: {
                return this.floatingContainer;
            }
            case FLOATING_LIVE: {
                return this.floatingLiveContainer;
            }
            case DOCKED: {
                return this.dockedContainer;
            }
            case SLIDING: {
                return this.slidingContainer;
            }
        }
        throw new IllegalArgumentException("Type not recognized.");
    }

    public ToolWindowTypeDescriptor getTypeDescriptor(ToolWindowType type) {
        switch (type) {
            case FLOATING: 
            case FLOATING_FREE: {
                return this.floatingTypeDescriptor;
            }
            case FLOATING_LIVE: {
                return this.floatingLiveTypeDescriptor;
            }
            case DOCKED: {
                return this.dockedTypeDescriptor;
            }
            case SLIDING: {
                return this.slidingTypeDescriptor;
            }
        }
        throw new IllegalStateException("Doen't exist a TypeDescriptor for. [type : " + type + "]");
    }

    public DockedTypeDescriptor getDockedTypeDescriptor() {
        return this.dockedTypeDescriptor;
    }

    public FloatingContainer getFloatingContainer() {
        return this.floatingContainer;
    }

    public Component getContentContainer() {
        return ((DockedContainer)this.getToolWindowContainer()).getContentContainer();
    }

    public void hideToolWindow() {
        ToolWindowActionHandler toolWindowActionHandler = this.toolWindow.getTypeDescriptor(DockedTypeDescriptor.class).getToolWindowActionHandler();
        if (toolWindowActionHandler != null) {
            toolWindowActionHandler.onHideButtonClick((ToolWindow)this.toolWindow);
        } else {
            this.toolWindow.setVisible(false);
        }
    }

    public Component findFocusable(Component cmp) {
        return ((FindFocusableQuestion)this.manager.getResourceManager().getObject(FindFocusableQuestion.class, null)).getAnswer(cmp);
    }

    protected void initListeners() {
        this.toolWindow.addPlafPropertyChangeListener(this);
    }

    protected void initTypeDescriptors() {
        this.floatingTypeDescriptor = (FloatingTypeDescriptor)((InternalTypeDescriptor)this.manager.getTypeDescriptorTemplate(ToolWindowType.FLOATING)).cloneMe(this);
        this.floatingTypeDescriptor.addPropertyChangeListener((PropertyChangeListener)this);
        this.floatingLiveTypeDescriptor = (FloatingLiveTypeDescriptor)((InternalTypeDescriptor)this.manager.getTypeDescriptorTemplate(ToolWindowType.FLOATING_LIVE)).cloneMe(this);
        this.floatingLiveTypeDescriptor.addPropertyChangeListener((PropertyChangeListener)this);
        this.dockedTypeDescriptor = (DockedTypeDescriptor)((InternalTypeDescriptor)this.manager.getTypeDescriptorTemplate(ToolWindowType.DOCKED)).cloneMe(this);
        this.dockedTypeDescriptor.addPropertyChangeListener((PropertyChangeListener)this);
        this.slidingTypeDescriptor = (SlidingTypeDescriptor)((InternalTypeDescriptor)this.manager.getTypeDescriptorTemplate(ToolWindowType.SLIDING)).cloneMe(this);
        this.slidingTypeDescriptor.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public class RepresentativeAnchor
    extends JLabel {
        public RepresentativeAnchor(Icon image, int horizontalAlignment) {
            super(image, horizontalAlignment);
            super.setUI((LabelUI)this.createRepresentativeAnchorUI());
        }

        public RepresentativeAnchor(String text, Icon icon, int horizontalAlignment) {
            super(text, icon, horizontalAlignment);
            super.setUI((LabelUI)this.createRepresentativeAnchorUI());
        }

        public void setUI(LabelUI ui) {
        }

        public void updateUI() {
            this.firePropertyChange("UI", null, this.getUI());
        }

        protected ComponentUI createRepresentativeAnchorUI() {
            return ToolWindowDescriptor.this.manager.getResourceManager().createComponentUI("REPRESENTATIVE_ANCHOR_BUTTON_UI", ToolWindowDescriptor.this.manager.getContext(ToolWindowDescriptor.class, ToolWindowDescriptor.this));
        }
    }

    protected class ToolWindowDescriptorCleaner
    extends DefaultCleanerAggregator {
        protected ToolWindowDescriptorCleaner() {
        }

        public void cleanup() {
            super.cleanup();
            ToolWindowDescriptor.this.toolWindow.removePlafPropertyChangeListener(ToolWindowDescriptor.this);
            ToolWindowDescriptor.this.floatingTypeDescriptor.removePropertyChangeListener((PropertyChangeListener)ToolWindowDescriptor.this);
            ToolWindowDescriptor.this.floatingLiveTypeDescriptor.removePropertyChangeListener((PropertyChangeListener)ToolWindowDescriptor.this);
            ToolWindowDescriptor.this.dockedTypeDescriptor.removePropertyChangeListener((PropertyChangeListener)ToolWindowDescriptor.this);
            ToolWindowDescriptor.this.slidingTypeDescriptor.removePropertyChangeListener((PropertyChangeListener)ToolWindowDescriptor.this);
            ToolWindowDescriptor.this.resetRepresentativeAnchor();
            ToolWindowDescriptor.this.toolWindow.cleanup();
            ToolWindowDescriptor.this.toolWindow = null;
            ToolWindowDescriptor.this.manager = null;
        }
    }
}

