/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.noos.common.Question;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.PersistenceDelegate;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowListener;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.event.ToolWindowTabEvent;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.common.context.DefaultMutableContext;
import org.noos.xing.mydoggy.plaf.support.CleanablePropertyChangeSupport;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.TitleBarButtons;
import org.noos.xing.mydoggy.plaf.ui.TitleBarTabs;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowContainer;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowActiveButton;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowTabPanel;
import org.noos.xing.mydoggy.plaf.ui.util.ParentOfQuestion;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class DockedContainer
implements ToolWindowContainer,
Cleaner {
    protected ToolWindowDescriptor descriptor;
    protected ToolWindow toolWindow;
    protected transient ResourceManager resourceManager;
    protected JPanel container;
    protected JPanel titleBar;
    protected ToolWindowTabPanel titleBarTabs;
    protected TitleBarButtons titleBarButtons;
    protected JPanel componentContainer;
    protected TitleBarMouseAdapter titleBarMouseAdapter;
    protected CleanablePropertyChangeSupport propertyChangeSupport;
    protected PropertyChangeListener focusListener;
    protected Component focusRequester;
    protected PopupUpdater popupUpdater;
    boolean valueAdjusting;

    public DockedContainer(ToolWindowDescriptor descriptor) {
        this.descriptor = descriptor;
        this.toolWindow = descriptor.getToolWindow();
        this.resourceManager = descriptor.getResourceManager();
        descriptor.getCleaner().addCleaner(this);
        this.initComponents();
        this.initListeners();
    }

    public void cleanup() {
        this.container.putClientProperty(ToolWindow.class, null);
        this.container.removeAll();
        this.popupUpdater = null;
        this.toolWindow = null;
        this.descriptor = null;
        this.resourceManager = null;
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this.getContentContainer());
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void showPopupMenu(Component c, int x, int y) {
        this.titleBarMouseAdapter.showPopupMenu(c, x, y);
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property, listener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    public ToolWindowDescriptor getToolWindowDescriptor() {
        return this.descriptor;
    }

    public Container getContentContainer() {
        return this.container;
    }

    public TitleBarButtons getTitleBarButtons() {
        return this.titleBarButtons;
    }

    public TitleBarTabs getTitleBarTabs() {
        return this.titleBarTabs;
    }

    public Component getTitleBar() {
        return this.titleBar;
    }

    public void setMainComponent(Component component) {
        this.componentContainer.removeAll();
        this.descriptor.setComponent(component);
        this.componentContainer.add(component, "0,0,FULL,FULL");
        SwingUtil.repaint(this.componentContainer);
    }

    public MouseListener getTitleBarMouseAdapter() {
        return this.titleBarMouseAdapter;
    }

    public void setPopupUpdater(PopupUpdater popupUpdater) {
        this.popupUpdater = popupUpdater;
    }

    protected void initComponents() {
        this.propertyChangeSupport = new CleanablePropertyChangeSupport(this);
        this.descriptor.getCleaner().addCleaner(this.propertyChangeSupport);
        this.titleBarMouseAdapter = new TitleBarMouseAdapter();
        this.container = (JPanel)this.resourceManager.createComponent("TOOL_WINDOW_CONTAINER", this.descriptor.getManager().getContext());
        this.container.setLayout((LayoutManager)((Object)new ExtendedTableLayout(new double[][]{{-1.0}, {this.resourceManager.getFloat("toolwindow.title.font.size", 12.0f) + 4.0f, -1.0}}, false)));
        this.container.setName("toolWindow.container." + this.toolWindow.getId());
        this.container.setFocusTraversalPolicyProvider(true);
        this.container.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
        this.container.setFocusCycleRoot(true);
        this.container.setFocusable(false);
        this.container.putClientProperty(ToolWindow.class, this.toolWindow);
        String id = this.toolWindow.getId();
        ExtendedTableLayout titleBarLayout = new ExtendedTableLayout(new double[][]{{3.0, -1.0, 2.0, -2.0, 3.0}, {0.0, this.resourceManager.getFloat("toolwindow.title.font.size", 12.0f) + 4.0f, 0.0}}, false);
        this.titleBar = (JPanel)this.resourceManager.createComponent("TOOL_WINDOW_TITLE_BAR", this.descriptor.getManager().getContext(ToolWindowDescriptor.class, this.descriptor, ToolWindowContainer.class, this));
        this.titleBar.setLayout((LayoutManager)((Object)titleBarLayout));
        this.titleBar.setName("toolWindow.titleBar." + this.toolWindow.getId());
        this.titleBar.setEnabled(false);
        this.titleBar.setBorder(null);
        this.titleBar.addMouseListener(this.titleBarMouseAdapter);
        if (this.descriptor.isIdVisibleOnTitleBar()) {
            titleBarLayout.setColumn(0, this.titleBar.getFontMetrics(this.titleBar.getFont()).stringWidth(this.resourceManager.getUserString(id)) + 12);
        }
        this.titleBarTabs = new ToolWindowTabPanel(this, this.descriptor);
        this.toolWindow.getToolWindowTabs()[0].setSelected(true);
        this.titleBarButtons = this.resourceManager.createInstance(TitleBarButtons.class, new DefaultMutableContext(ToolWindowDescriptor.class, this.descriptor, ToolWindowContainer.class, this));
        this.titleBar.add((Component)this.titleBarTabs, "1,1");
        this.titleBar.add(this.titleBarButtons.getComponent(), "3,1,right,c");
        this.componentContainer = new JPanel();
        this.componentContainer.setLayout((LayoutManager)((Object)new ExtendedTableLayout(new double[][]{{-1.0}, {-1.0}})));
        this.componentContainer.setOpaque(false);
        this.componentContainer.add(this.descriptor.getComponent(), "0,0,FULL,FULL");
        this.container.add((Component)this.titleBar, "0,0");
        this.container.add((Component)this.componentContainer, "0,1");
        this.focusRequester = SwingUtil.findFocusable(this.descriptor.getComponent());
        if (this.focusRequester == null) {
            this.titleBarButtons.getFocusable().setFocusable(true);
            this.focusRequester = this.titleBarButtons.getFocusable();
        }
        this.titleBarButtons.setType(ToolWindowType.DOCKED);
    }

    protected void initListeners() {
        this.focusListener = new FocusOwnerPropertyChangeListener(this.resourceManager.createInstance(ParentOfQuestion.class, new DefaultMutableContext(ToolWindow.class, this.toolWindow, Component.class, this.container)));
        this.addPropertyChangeListener("active", new ActivePropertyChangeListener());
        this.addPropertyChangeListener("type", new TypePropertyChangeListener());
        this.addPropertyChangeListener("maximized.before", new MaximizedBeforePropertyChangeListener());
        this.addPropertyChangeListener("manager.window.anchestor", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    keyboardFocusManager.removePropertyChangeListener("focusOwner", DockedContainer.this.focusListener);
                    keyboardFocusManager.addPropertyChangeListener("focusOwner", DockedContainer.this.focusListener);
                } else {
                    DockedContainer.this.toolWindow.setFlashing(false);
                }
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusListener);
        this.toolWindow.addToolWindowListener((ToolWindowListener)new DockedToolWindowListener());
    }

    protected void assignFocus() {
        this.focusRequester = SwingUtil.findFocusable(this.descriptor.getComponent());
        if (this.focusRequester == null) {
            this.titleBarButtons.getFocusable().setFocusable(true);
            this.focusRequester = this.titleBarButtons.getFocusable();
        } else {
            this.titleBarButtons.getFocusable().setFocusable(false);
        }
        SwingUtil.requestFocus(this.focusRequester);
    }

    protected void enableIdOnTitleBar() {
        TableLayout layout = (TableLayout)this.titleBar.getLayout();
        layout.setColumn(0, (double)(this.titleBar.getFontMetrics(this.titleBar.getFont()).stringWidth(this.resourceManager.getUserString(this.toolWindow.getId())) + 12));
        SwingUtil.repaint(this.titleBar);
    }

    protected void disableIdOnTitleBar() {
        TableLayout layout = (TableLayout)this.titleBar.getLayout();
        layout.setColumn(0, 3.0);
        SwingUtil.repaint(this.titleBar);
    }

    protected class MaximizedBeforePropertyChangeListener
    implements PropertyChangeListener {
        ByteArrayOutputStream workspace;
        boolean valueAdj = false;

        protected MaximizedBeforePropertyChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() != DockedContainer.this.descriptor) {
                return;
            }
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                this.workspace = new ByteArrayOutputStream();
                DockedContainer.this.descriptor.getManager().getPersistenceDelegate().save((OutputStream)this.workspace);
            } else if (this.workspace != null) {
                if (this.valueAdj) {
                    return;
                }
                this.valueAdj = true;
                try {
                    DockedContainer.this.descriptor.getManager().getPersistenceDelegate().merge((InputStream)new ByteArrayInputStream(this.workspace.toByteArray()), DockedContainer.this.resourceManager.getObject(PersistenceDelegate.MergePolicy.class, PersistenceDelegate.MergePolicy.UNION));
                    this.workspace = null;
                }
                finally {
                    this.valueAdj = false;
                }
            }
        }
    }

    protected class TypePropertyChangeListener
    implements PropertyChangeListener {
        protected TypePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() != DockedContainer.this.descriptor) {
                return;
            }
            if (evt.getNewValue() == ToolWindowType.DOCKED) {
                DockedContainer.this.titleBarButtons.setType(ToolWindowType.DOCKED);
            }
            if (evt.getOldValue() == ToolWindowType.EXTERN) {
                DockedContainer.this.setMainComponent(DockedContainer.this.toolWindow.getToolWindowTabs()[0].getComponent());
            }
        }
    }

    protected class ActivePropertyChangeListener
    implements PropertyChangeListener {
        protected ActivePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() != DockedContainer.this.descriptor) {
                return;
            }
            boolean active = (Boolean)evt.getNewValue();
            DockedContainer.this.titleBar.setEnabled(active);
            boolean found = false;
            for (ToolWindowTab tab : DockedContainer.this.toolWindow.getToolWindowTabs()) {
                if (!tab.isSelected()) continue;
                found = true;
                break;
            }
            if (!found && DockedContainer.this.toolWindow.getToolWindowTabs().length > 0) {
                DockedContainer.this.toolWindow.getToolWindowTabs()[0].setSelected(true);
            }
            if (active && DockedContainer.this.focusRequester != null && !DockedContainer.this.valueAdjusting) {
                if (DockedContainer.this.focusRequester == DockedContainer.this.titleBarButtons.getFocusable()) {
                    DockedContainer.this.assignFocus();
                } else {
                    SwingUtil.requestFocus(DockedContainer.this.focusRequester);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FocusOwnerPropertyChangeListener
    implements PropertyChangeListener,
    Cleaner {
        protected Question<Component, Boolean> parentOf;

        public FocusOwnerPropertyChangeListener(Question<Component, Boolean> parentOf) {
            this.parentOf = parentOf;
            DockedContainer.this.descriptor.getCleaner().addBefore(DockedContainer.this, this);
        }

        @Override
        public void cleanup() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!DockedContainer.this.toolWindow.isVisible() || DockedContainer.this.valueAdjusting) {
                return;
            }
            Component component = (Component)evt.getNewValue();
            if (component == null) {
                return;
            }
            if (component instanceof JRootPane) {
                return;
            }
            DockedContainer.this.valueAdjusting = true;
            if (this.parentOf.getAnswer(component).booleanValue()) {
                DockedContainer.this.toolWindow.setActive(true);
                if (DockedContainer.this.focusRequester == null) {
                    DockedContainer.this.focusRequester = component;
                } else if (!(DockedContainer.this.focusRequester instanceof ToolWindowActiveButton)) {
                    DockedContainer.this.focusRequester = component;
                } else if (DockedContainer.this.focusRequester == DockedContainer.this.titleBarButtons.getFocusable()) {
                    DockedContainer.this.assignFocus();
                } else {
                    DockedContainer.this.focusRequester.requestFocusInWindow();
                }
            } else {
                DockedContainer.this.descriptor.getToolBar().deactiveTool(DockedContainer.this.toolWindow);
                if (DockedContainer.this.toolWindow.isAutoHide() && DockedContainer.this.toolWindow.getType() != ToolWindowType.EXTERN) {
                    DockedContainer.this.toolWindow.setVisible(false);
                }
            }
            DockedContainer.this.valueAdjusting = false;
        }
    }

    protected class DockedToolWindowListener
    implements Cleaner,
    ToolWindowListener,
    PropertyChangeListener {
        public DockedToolWindowListener() {
            DockedContainer.this.descriptor.getCleaner().addBefore(DockedContainer.this, this);
            for (ToolWindowTab tab : DockedContainer.this.toolWindow.getToolWindowTabs()) {
                tab.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void cleanup() {
            DockedContainer.this.toolWindow.removeToolWindowListener((ToolWindowListener)this);
            for (ToolWindowTab tab : DockedContainer.this.toolWindow.getToolWindowTabs()) {
                tab.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public boolean toolWindowTabRemoving(ToolWindowTabEvent event) {
            return true;
        }

        public void toolWindowTabAdded(ToolWindowTabEvent event) {
            ToolWindowTab tab = event.getToolWindowTab();
            tab.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void toolWindowTabRemoved(ToolWindowTabEvent event) {
            if (DockedContainer.this.toolWindow.getToolWindowTabs().length == 0) {
                DockedContainer.this.componentContainer.remove(event.getToolWindowTab().getComponent());
                SwingUtil.repaint(DockedContainer.this.componentContainer);
            }
            event.getToolWindowTab().removePropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            final ToolWindowTab tab = (ToolWindowTab)evt.getSource();
            String property = evt.getPropertyName();
            if ("selected".equals(property)) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DockedContainer.this.setMainComponent(tab.getComponent());
                            Component focusable = SwingUtil.findFocusable(tab.getComponent());
                            if (focusable != null) {
                                focusable.requestFocus();
                            } else {
                                DockedContainer.this.titleBarButtons.getFocusable().requestFocus();
                            }
                        }
                    });
                }
            } else if ("component".equals(property) && DockedContainer.this.descriptor.getComponent() == evt.getOldValue()) {
                DockedContainer.this.setMainComponent(tab.getComponent());
            }
        }
    }

    protected class TitleBarMouseAdapter
    extends MouseAdapter
    implements Cleaner,
    ActionListener,
    PropertyChangeListener {
        protected JPopupMenu popupMenu;
        protected JMenuItem visible;
        protected JMenuItem aggregate;
        protected JMenu aggregateMenu;
        protected JCheckBoxMenuItem floatingMode;
        protected JCheckBoxMenuItem floatingLiveMode;
        protected JCheckBoxMenuItem dockedMode;
        protected JCheckBoxMenuItem pinnedMode;
        protected JMenu old;
        protected JMenuItem maximize;
        protected JMenu moveTo;
        protected JMenuItem right;
        protected JMenuItem left;
        protected JMenuItem top;
        protected JMenuItem bottom;
        protected ToolWindowType oldType;

        public TitleBarMouseAdapter() {
            DockedContainer.this.descriptor.getCleaner().addBefore(DockedContainer.this, this);
            this.initPopupMenu();
            DockedContainer.this.descriptor.getToolWindow().addPlafPropertyChangeListener(this);
            DockedContainer.this.addPropertyChangeListener("type", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getSource() != DockedContainer.this.descriptor || evt.getNewValue() != ToolWindowType.FLOATING && evt.getNewValue() != ToolWindowType.FLOATING_FREE) {
                        return;
                    }
                    TitleBarMouseAdapter.this.oldType = (ToolWindowType)evt.getOldValue();
                }
            });
        }

        public void cleanup() {
            DockedContainer.this.descriptor.getToolWindow().removePlafPropertyChangeListener(this);
        }

        public void mouseClicked(MouseEvent e) {
            if (!DockedContainer.this.toolWindow.isAvailable()) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(e)) {
                DockedContainer.this.toolWindow.setActive(true);
                if (e.getClickCount() == 2) {
                    DockedContainer.this.toolWindow.setMaximized(!DockedContainer.this.toolWindow.isMaximized());
                }
            } else if (SwingUtilities.isRightMouseButton(e) && ((DockedTypeDescriptor)DockedContainer.this.toolWindow.getTypeDescriptor(ToolWindowType.DOCKED)).isPopupMenuEnabled()) {
                this.showPopupMenu(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if ("visible".equals(actionCommand)) {
                if (DockedContainer.this.toolWindow.isActive()) {
                    DockedContainer.this.toolWindow.setActive(false);
                    DockedContainer.this.descriptor.hideToolWindow();
                } else if (DockedContainer.this.toolWindow.isVisible()) {
                    DockedContainer.this.descriptor.hideToolWindow();
                } else {
                    DockedContainer.this.toolWindow.setActive(true);
                }
            } else if (actionCommand.startsWith("aggregate")) {
                if (DockedContainer.this.toolWindow.isActive()) {
                    DockedContainer.this.toolWindow.setActive(false);
                    DockedContainer.this.toolWindow.setVisible(false);
                } else if (DockedContainer.this.toolWindow.isVisible()) {
                    DockedContainer.this.toolWindow.setVisible(false);
                } else {
                    if (actionCommand.endsWith("left")) {
                        DockedContainer.this.toolWindow.aggregate(AggregationPosition.LEFT);
                    } else if (actionCommand.endsWith("right")) {
                        DockedContainer.this.toolWindow.aggregate(AggregationPosition.RIGHT);
                    } else if (actionCommand.endsWith("top")) {
                        DockedContainer.this.toolWindow.aggregate(AggregationPosition.TOP);
                    } else if (actionCommand.endsWith("bottom")) {
                        DockedContainer.this.toolWindow.aggregate(AggregationPosition.BOTTOM);
                    } else {
                        DockedContainer.this.toolWindow.aggregate();
                    }
                    DockedContainer.this.toolWindow.setActive(true);
                }
            } else if ("move.right".equals(actionCommand)) {
                DockedContainer.this.toolWindow.setAnchor(ToolWindowAnchor.RIGHT);
            } else if ("move.left".equals(actionCommand)) {
                DockedContainer.this.toolWindow.setAnchor(ToolWindowAnchor.LEFT);
            } else if ("move.top".equals(actionCommand)) {
                DockedContainer.this.toolWindow.setAnchor(ToolWindowAnchor.TOP);
            } else if ("move.bottom".equals(actionCommand)) {
                DockedContainer.this.toolWindow.setAnchor(ToolWindowAnchor.BOTTOM);
            } else if ("floating".equals(actionCommand)) {
                if (this.floatingMode.isSelected()) {
                    DockedContainer.this.toolWindow.setType(DockedContainer.this.descriptor.isFloatingWindow() ? ToolWindowType.FLOATING_FREE : ToolWindowType.FLOATING);
                    this.dockedMode.setVisible(!this.floatingMode.isSelected());
                } else {
                    DockedContainer.this.toolWindow.setType(this.oldType != null ? this.oldType : ToolWindowType.DOCKED);
                }
            } else if ("floatingLive".equals(actionCommand)) {
                DockedContainer.this.toolWindow.setType(this.floatingLiveMode.isSelected() ? ToolWindowType.FLOATING_LIVE : ToolWindowType.DOCKED);
            } else if ("docked".equals(actionCommand)) {
                DockedContainer.this.toolWindow.setType(this.dockedMode.isSelected() ? ToolWindowType.DOCKED : ToolWindowType.SLIDING);
            } else if ("pinned".equals(actionCommand)) {
                DockedContainer.this.toolWindow.setAutoHide(!DockedContainer.this.toolWindow.isAutoHide());
            } else if ("maximize".equals(actionCommand)) {
                DockedContainer.this.toolWindow.setMaximized(!DockedContainer.this.toolWindow.isMaximized());
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("autoHide".equals(evt.getPropertyName())) {
                this.pinnedMode.setState((Boolean)evt.getNewValue() == false);
            } else if ("type".equals(evt.getPropertyName())) {
                ToolWindowType type = (ToolWindowType)evt.getNewValue();
                this.dockedMode.setState(type == ToolWindowType.DOCKED);
                this.dockedMode.setVisible(type != ToolWindowType.FLOATING);
                this.pinnedMode.setVisible(type != ToolWindowType.SLIDING);
                this.floatingMode.setState(type == ToolWindowType.FLOATING);
            } else if ("UI".equals(evt.getPropertyName())) {
                SwingUtilities.updateComponentTreeUI(this.popupMenu);
                DockedTypeDescriptor descriptor = (DockedTypeDescriptor)DockedContainer.this.toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
                SwingUtilities.updateComponentTreeUI(descriptor.getToolsMenu());
            }
        }

        public void showPopupMenu(Component source, int x, int y) {
            if (source == DockedContainer.this.titleBar || SwingUtil.hasParent(source, DockedContainer.this.titleBar) || source instanceof ToolWindowDescriptor.RepresentativeAnchor) {
                this.popupMenu.removeAll();
                this.popupMenu.add(this.pinnedMode);
                this.popupMenu.add(this.dockedMode);
                this.popupMenu.add(this.floatingMode);
                this.popupMenu.add(this.floatingLiveMode);
                this.popupMenu.add(this.moveTo);
                this.popupMenu.add(this.maximize);
                this.popupMenu.addSeparator();
                this.popupMenu.add(this.visible);
                this.popupMenu.add(this.aggregate);
                this.popupMenu.add(this.aggregateMenu);
                this.enableVisible();
                this.enableMoveToItem();
                this.enableUserDefined();
                this.enableMaximize();
                if (DockedContainer.this.popupUpdater != null) {
                    DockedContainer.this.popupUpdater.update(source, this.popupMenu);
                }
                this.popupMenu.show(source, x, y);
            }
        }

        protected void initPopupMenu() {
            this.popupMenu = new JPopupMenu("ToolWindowBarPopupMenu");
            this.popupMenu.setLightWeightPopupEnabled(false);
            this.visible = new JMenuItem();
            this.visible.setName("toolWindow.popup.visible." + DockedContainer.this.toolWindow.getId());
            this.visible.setActionCommand("visible");
            this.visible.addActionListener(this);
            this.aggregate = new JMenuItem();
            this.aggregate.setName("toolWindow.popup.aggregate." + DockedContainer.this.toolWindow.getId());
            this.aggregate.setText(DockedContainer.this.resourceManager.getString("@@tool.aggregate"));
            this.aggregate.setActionCommand("aggregate");
            this.aggregate.addActionListener(this);
            this.aggregateMenu = new JMenu(DockedContainer.this.resourceManager.getString("@@tool.aggregateMenu"));
            JMenuItem aggregateLeft = new JMenuItem();
            aggregateLeft.setName("toolWindow.popup.aggregate.left." + DockedContainer.this.toolWindow.getId());
            aggregateLeft.setText(DockedContainer.this.resourceManager.getString("@@tool.aggregate.left"));
            aggregateLeft.setActionCommand("aggregate.left");
            aggregateLeft.addActionListener(this);
            this.aggregateMenu.add(aggregateLeft);
            JMenuItem aggregateRight = new JMenuItem();
            aggregateRight.setName("toolWindow.popup.aggregate.right." + DockedContainer.this.toolWindow.getId());
            aggregateRight.setText(DockedContainer.this.resourceManager.getString("@@tool.aggregate.right"));
            aggregateRight.setActionCommand("aggregate.right");
            aggregateRight.addActionListener(this);
            this.aggregateMenu.add(aggregateRight);
            JMenuItem aggregateTop = new JMenuItem();
            aggregateTop.setName("toolWindow.popup.aggregate.top." + DockedContainer.this.toolWindow.getId());
            aggregateTop.setText(DockedContainer.this.resourceManager.getString("@@tool.aggregate.top"));
            aggregateTop.setActionCommand("aggregate.top");
            aggregateTop.addActionListener(this);
            this.aggregateMenu.add(aggregateTop);
            JMenuItem aggregateBottom = new JMenuItem();
            aggregateBottom.setName("toolWindow.popup.aggregate.bottom." + DockedContainer.this.toolWindow.getId());
            aggregateBottom.setText(DockedContainer.this.resourceManager.getString("@@tool.aggregate.bottom"));
            aggregateBottom.setActionCommand("aggregate.bottom");
            aggregateBottom.addActionListener(this);
            this.aggregateMenu.add(aggregateBottom);
            this.floatingMode = new JCheckBoxMenuItem(null, DockedContainer.this.toolWindow.getType() == ToolWindowType.FLOATING);
            this.floatingMode.setText(DockedContainer.this.resourceManager.getString("@@tool.mode.floating"));
            this.floatingMode.setActionCommand("floating");
            this.floatingMode.addActionListener(this);
            this.floatingLiveMode = new JCheckBoxMenuItem(null, DockedContainer.this.toolWindow.getType() == ToolWindowType.FLOATING_LIVE);
            this.floatingLiveMode.setName("toolWindow.popup.floatingLive." + DockedContainer.this.toolWindow.getId());
            this.floatingLiveMode.setText(DockedContainer.this.resourceManager.getString("@@tool.mode.floatingLive"));
            this.floatingLiveMode.setActionCommand("floatingLive");
            this.floatingLiveMode.addActionListener(this);
            this.dockedMode = new JCheckBoxMenuItem(null, DockedContainer.this.toolWindow.getType() == ToolWindowType.DOCKED);
            this.dockedMode.setText(DockedContainer.this.resourceManager.getString("@@tool.mode.docked"));
            this.dockedMode.setActionCommand("docked");
            this.dockedMode.addActionListener(this);
            this.pinnedMode = new JCheckBoxMenuItem(null, !DockedContainer.this.toolWindow.isAutoHide());
            this.pinnedMode.setText(DockedContainer.this.resourceManager.getString("@@tool.mode.pinned"));
            this.pinnedMode.setActionCommand("pinned");
            this.pinnedMode.addActionListener(this);
            this.maximize = new JMenuItem();
            this.maximize.setText(DockedContainer.this.resourceManager.getString("@@tool.maximize"));
            this.maximize.setActionCommand("maximize");
            this.maximize.addActionListener(this);
            this.moveTo = new JMenu();
            this.moveTo.getPopupMenu().setLightWeightPopupEnabled(false);
            this.moveTo.setText(DockedContainer.this.resourceManager.getString("@@tool.moveTo"));
            this.right = new JMenuItem();
            this.right.setText(DockedContainer.this.resourceManager.getString("@@tool.move.right"));
            this.right.setActionCommand("move.right");
            this.right.addActionListener(this);
            this.left = new JMenuItem();
            this.left.setText(DockedContainer.this.resourceManager.getString("@@tool.move.left"));
            this.left.setActionCommand("move.left");
            this.left.addActionListener(this);
            this.top = new JMenuItem();
            this.top.setText(DockedContainer.this.resourceManager.getString("@@tool.move.top"));
            this.top.setActionCommand("move.top");
            this.top.addActionListener(this);
            this.bottom = new JMenuItem();
            this.bottom.setText(DockedContainer.this.resourceManager.getString("@@tool.move.bottom"));
            this.bottom.setActionCommand("move.bottom");
            this.bottom.addActionListener(this);
            this.moveTo.add(this.right);
            this.moveTo.add(this.left);
            this.moveTo.add(this.top);
            this.moveTo.add(this.bottom);
            this.popupMenu.add(this.pinnedMode);
            this.popupMenu.add(this.dockedMode);
            this.popupMenu.add(this.floatingMode);
            this.popupMenu.add(this.floatingLiveMode);
            this.popupMenu.add(this.moveTo);
            this.popupMenu.add(this.maximize);
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.visible);
            this.popupMenu.add(this.aggregate);
            this.popupMenu.add(this.aggregateMenu);
        }

        protected void enableVisible() {
            this.aggregate.setVisible(!DockedContainer.this.toolWindow.isVisible());
            this.aggregateMenu.setVisible(this.aggregate.isVisible());
            this.visible.setText(DockedContainer.this.toolWindow.isVisible() ? DockedContainer.this.resourceManager.getString("@@tool.hide") : DockedContainer.this.resourceManager.getString("@@tool.show"));
            if (DockedContainer.this.toolWindow.getType() == ToolWindowType.DOCKED) {
                this.dockedMode.setVisible(DockedContainer.this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING).isEnabled());
                this.floatingMode.setVisible(DockedContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING).isEnabled());
                this.floatingLiveMode.setState(false);
                this.floatingLiveMode.setVisible(DockedContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING_LIVE).isEnabled());
            } else if (DockedContainer.this.toolWindow.getType() == ToolWindowType.SLIDING) {
                this.floatingMode.setVisible(DockedContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING).isEnabled());
                this.floatingLiveMode.setState(false);
                this.floatingLiveMode.setVisible(DockedContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING_LIVE).isEnabled());
            } else if (DockedContainer.this.toolWindow.getType() == ToolWindowType.FLOATING) {
                this.floatingLiveMode.setState(false);
                this.floatingLiveMode.setVisible(DockedContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING_LIVE).isEnabled());
            } else if (DockedContainer.this.toolWindow.getType() == ToolWindowType.FLOATING_LIVE) {
                this.dockedMode.setState(false);
                this.floatingMode.setState(false);
                this.floatingMode.setVisible(DockedContainer.this.descriptor.getTypeDescriptor(ToolWindowType.FLOATING).isEnabled());
            }
        }

        protected void enableMoveToItem() {
            ToolWindowAnchor anchor = DockedContainer.this.toolWindow.getAnchor();
            if (anchor == ToolWindowAnchor.LEFT) {
                this.left.setVisible(false);
                this.right.setVisible(true);
                this.top.setVisible(true);
                this.bottom.setVisible(true);
            } else if (anchor == ToolWindowAnchor.RIGHT) {
                this.left.setVisible(true);
                this.right.setVisible(false);
                this.top.setVisible(true);
                this.bottom.setVisible(true);
            } else if (anchor == ToolWindowAnchor.BOTTOM) {
                this.left.setVisible(true);
                this.right.setVisible(true);
                this.top.setVisible(true);
                this.bottom.setVisible(false);
            } else if (anchor == ToolWindowAnchor.TOP) {
                this.left.setVisible(true);
                this.right.setVisible(true);
                this.top.setVisible(false);
                this.bottom.setVisible(true);
            }
        }

        protected void enableUserDefined() {
            JMenu menu;
            DockedTypeDescriptor descriptor = (DockedTypeDescriptor)DockedContainer.this.toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
            if (this.old != null) {
                this.popupMenu.remove(this.old);
            }
            if ((menu = descriptor.getToolsMenu()).getMenuComponentCount() > 0) {
                this.popupMenu.add((Component)menu, 4);
                this.old = menu;
            }
        }

        protected void enableMaximize() {
            this.maximize.setVisible(DockedContainer.this.toolWindow.isVisible());
            this.maximize.setText(DockedContainer.this.toolWindow.isMaximized() ? DockedContainer.this.resourceManager.getString("@@tool.maximize.restore") : DockedContainer.this.resourceManager.getString("@@tool.maximize"));
        }
    }

    public static interface PopupUpdater {
        public void update(Component var1, JPopupMenu var2);
    }
}

