/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.plaf.MyDoggyContentManager;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.ui.content.PlafContent;

public class MyDoggyContent
extends PropertyChangeEventSource
implements PlafContent {
    protected transient MyDoggyContentManager contentManager;
    protected String id;
    protected String title;
    protected Color foreground;
    protected Icon icon;
    protected Icon disabledIcon;
    protected String toolTipText;
    protected boolean enabled;
    protected transient Component component;
    protected JPopupMenu popupMenu;
    protected boolean detached;
    protected int mnemonic;
    protected boolean selected;
    protected boolean maximized;
    protected transient Dockable dockableDelegator;
    protected boolean flash;
    protected boolean minimized;

    public MyDoggyContent(MyDoggyContentManager contentManager, String id, String title, Icon icon, Component component, String toolTipText, Dockable dockableDelegator) {
        this.contentManager = contentManager;
        this.id = id;
        this.title = title;
        this.icon = icon;
        this.component = component;
        this.toolTipText = toolTipText;
        this.enabled = true;
        this.mnemonic = -1;
        this.selected = false;
        this.maximized = false;
        this.dockableDelegator = dockableDelegator;
        this.flash = false;
    }

    public ContentManager getDockableManager() {
        return this.contentManager;
    }

    public String getId() {
        return this.id;
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean isFlashing() {
        return this.flash;
    }

    public void setFlashing(boolean flash) {
        if (flash && this.isSelected()) {
            return;
        }
        if (this.flash == flash) {
            return;
        }
        boolean old = this.flash;
        this.flash = flash;
        this.firePropertyChangeEvent("flash", old, flash);
    }

    public void setFlashing(int duration) {
        if (this.isSelected()) {
            return;
        }
        this.flash = true;
        this.firePropertyChangeEvent("flash.duration", null, duration);
    }

    public void setComponent(Component component) {
        if (this.component != null && this.component.equals(component)) {
            return;
        }
        Component old = this.component;
        this.component = component;
        this.firePropertyChangeEvent("component", old, component);
    }

    public Icon getDisabledIcon() {
        return this.disabledIcon;
    }

    public void setDisabledIcon(Icon disabledIcon) {
        if (this.disabledIcon != null && this.disabledIcon.equals(disabledIcon)) {
            return;
        }
        Icon old = this.disabledIcon;
        this.disabledIcon = disabledIcon;
        this.firePropertyChangeEvent("disabledIcon", old, disabledIcon);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            boolean old = this.enabled;
            this.enabled = enabled;
            this.firePropertyChangeEvent("enabled", old, enabled);
        }
    }

    public boolean isSelected() {
        if (this.contentManager.getPlafContentManagerUI().isInstalled()) {
            return this.contentManager.getPlafContentManagerUI().isSelected(this);
        }
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (this.isSelected() != selected || !this.contentManager.getPlafContentManagerUI().isInstalled()) {
            boolean old = this.isSelected();
            this.selected = selected;
            this.contentManager.getPlafContentManagerUI().setSelected(this, selected);
            this.firePropertyChangeEvent("selected", old, selected);
        }
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        if (this.foreground != null && this.foreground.equals(foreground)) {
            return;
        }
        Color old = this.foreground;
        this.foreground = foreground;
        this.firePropertyChangeEvent("foreground", old, foreground);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        if (this.icon != null && this.icon.equals(icon)) {
            return;
        }
        Icon old = this.icon;
        this.icon = icon;
        this.firePropertyChangeEvent("icon", old, icon);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        if (this.popupMenu != null && this.popupMenu.equals(popupMenu)) {
            return;
        }
        JPopupMenu old = this.popupMenu;
        this.popupMenu = popupMenu;
        this.firePropertyChangeEvent("popupMenu", old, popupMenu);
    }

    public void setDetached(boolean detached) {
        if (this.detached == detached) {
            return;
        }
        if (detached) {
            this.setMaximized(false);
        }
        boolean old = this.detached;
        this.detached = detached;
        this.firePropertyChangeEvent("detached", old, detached);
    }

    public boolean isDetached() {
        return this.detached;
    }

    public void setMnemonic(int mnemonic) {
        if (this.mnemonic == mnemonic) {
            return;
        }
        int old = this.mnemonic;
        this.mnemonic = mnemonic;
        this.firePropertyChangeEvent("mnemonic", old, mnemonic);
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public void setMaximized(boolean maximized) {
        if (this.maximized == maximized) {
            return;
        }
        if (this.isMinimized()) {
            this.setMinimized(false);
        }
        boolean old = this.maximized;
        if (maximized) {
            this.firePlafPropertyChangeEvent("maximized.before", false, maximized);
        }
        this.maximized = maximized;
        this.firePropertyChangeEvent("maximized", old, maximized);
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void setMinimized(boolean minimized) {
        if (this.minimized == minimized) {
            return;
        }
        if (this.isMaximized()) {
            this.setMaximized(false);
        }
        boolean old = this.minimized;
        this.minimized = minimized;
        this.firePropertyChangeEvent("minimized", old, minimized);
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void ensureVisible() {
        if (!this.isMinimized()) {
            this.firePlafPropertyChangeEvent("ensureVisible", null, this);
        }
    }

    public ContentUI getContentUI() {
        return this.contentManager.getContentManagerUI().getContentUI((Content)this);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (this.title != null && this.title.equals(title)) {
            return;
        }
        String old = this.title;
        this.title = title;
        this.firePropertyChangeEvent("title", old, title);
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        String old = this.toolTipText;
        this.toolTipText = toolTipText;
        this.firePropertyChangeEvent("toolTipText", old, toolTipText);
    }

    public Dockable getDockableDelegator() {
        return this.dockableDelegator;
    }

    public String toString() {
        return this.id;
    }

    public void cleanup() {
        super.cleanup();
        this.contentManager = null;
        this.dockableDelegator = null;
    }
}

