/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp.event;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;

public class FloatingResizeMouseInputHandler
implements MouseInputListener {
    static final int BORDER_DRAG_THICKNESS = 5;
    static final int CORNER_DRAG_WIDTH = 16;
    static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};
    protected Cursor lastCursor = Cursor.getPredefinedCursor(0);
    protected int dragCursor;
    protected int dragOffsetX;
    protected int dragOffsetY;
    protected int dragWidth;
    protected int dragHeight;
    protected Component floatingContainer;
    protected boolean isWindow;
    protected Dimension minimumSize;

    public FloatingResizeMouseInputHandler(Component floatingContainer) {
        this.floatingContainer = floatingContainer;
        this.isWindow = floatingContainer instanceof Window;
        this.minimumSize = new Dimension(150, 24);
    }

    public void mousePressed(MouseEvent ev) {
        Point dragWindowOffset = ev.getPoint();
        Component w = (Component)ev.getSource();
        if (this.isWindow) {
            ((Window)this.floatingContainer).toFront();
        }
        this.dragOffsetX = dragWindowOffset.x;
        this.dragOffsetY = dragWindowOffset.y;
        this.dragWidth = w.getWidth();
        this.dragHeight = w.getHeight();
        this.dragCursor = this.getCursor(this.calculateCorner(w, dragWindowOffset.x, dragWindowOffset.y));
    }

    public void mouseReleased(MouseEvent ev) {
        if (this.dragCursor != 0 && this.floatingContainer != null && !this.floatingContainer.isValid()) {
            this.floatingContainer.validate();
        }
        this.dragCursor = 0;
        this.floatingContainer.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseMoved(MouseEvent ev) {
        Component w = (Component)ev.getSource();
        int cursor = this.getCursor(this.calculateCorner(w, ev.getX(), ev.getY()));
        if (cursor != 0) {
            w.setCursor(Cursor.getPredefinedCursor(cursor));
        } else {
            w.setCursor(this.lastCursor);
        }
    }

    public void mouseDragged(MouseEvent ev) {
        Point pt = ev.getPoint();
        if (this.dragCursor != 0) {
            Rectangle r = this.floatingContainer.getBounds();
            Rectangle startBounds = new Rectangle(r);
            Dimension min = this.minimumSize;
            switch (this.dragCursor) {
                case 11: {
                    this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, 0);
                    break;
                }
                case 9: {
                    this.adjust(r, min, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                    break;
                }
                case 8: {
                    this.adjust(r, min, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                    break;
                }
                case 10: {
                    this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                    break;
                }
                case 7: {
                    this.adjust(r, min, 0, pt.y - this.dragOffsetY, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, -(pt.y - this.dragOffsetY));
                    break;
                }
                case 5: {
                    this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                    break;
                }
                case 6: {
                    this.adjust(r, min, pt.x - this.dragOffsetX, pt.y - this.dragOffsetY, -(pt.x - this.dragOffsetX), -(pt.y - this.dragOffsetY));
                    break;
                }
                case 4: {
                    this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                    break;
                }
            }
            if (!r.equals(startBounds)) {
                if (r.width < this.minimumSize.width) {
                    r.width = this.minimumSize.width;
                }
                if (r.height < this.minimumSize.height) {
                    r.height = this.minimumSize.height;
                }
                this.floatingContainer.setBounds(r);
                if (this.isWindow) {
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        this.floatingContainer.validate();
                    }
                } else {
                    this.floatingContainer.validate();
                }
            }
        }
    }

    public void mouseEntered(MouseEvent ev) {
        Component w = (Component)ev.getSource();
        this.lastCursor = w.getCursor();
        this.mouseMoved(ev);
    }

    public void mouseExited(MouseEvent ev) {
        Component w = (Component)ev.getSource();
        w.setCursor(this.lastCursor);
    }

    public void mouseClicked(MouseEvent ev) {
    }

    public Dimension getMinimumSize() {
        return this.minimumSize;
    }

    public void setMinimumSize(Dimension minimumSize) {
        this.minimumSize = minimumSize;
    }

    protected void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
        bounds.x += deltaX;
        bounds.y += deltaY;
        bounds.width += deltaWidth;
        bounds.height += deltaHeight;
        if (min != null) {
            int correction;
            if (bounds.width < min.width) {
                correction = min.width - bounds.width;
                if (deltaX != 0) {
                    bounds.x -= correction;
                }
                bounds.width = min.width;
            }
            if (bounds.height < min.height) {
                correction = min.height - bounds.height;
                if (deltaY != 0) {
                    bounds.y -= correction;
                }
                bounds.height = min.height;
            }
        }
    }

    protected int calculateCorner(Component c, int x, int y) {
        int xPosition = this.calculatePosition(x, c.getWidth());
        int yPosition = this.calculatePosition(y, c.getHeight());
        if (xPosition == -1 || yPosition == -1) {
            return -1;
        }
        return yPosition * 5 + xPosition;
    }

    protected int getCursor(int corner) {
        if (corner == -1) {
            return 0;
        }
        return cursorMapping[corner];
    }

    protected int calculatePosition(int spot, int width) {
        if (spot < 5) {
            return 0;
        }
        if (spot < 16) {
            return 1;
        }
        if (spot >= width - 5) {
            return 4;
        }
        if (spot >= width - 16) {
            return 3;
        }
        return 2;
    }
}

