/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.noos.xing.mydoggy.plaf.common.context.DefaultMutableContext;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class JToolScrollBar
extends JComponent
implements ChangeListener {
    protected int orientation;
    protected JViewport viewport;
    protected Container container;
    protected boolean scrollEnabled;

    public JToolScrollBar(ResourceManager resourceManager, int orientation, Container container) {
        this.orientation = orientation;
        this.container = container;
        this.scrollEnabled = false;
        this.initComponents(resourceManager);
    }

    public void stateChanged(ChangeEvent e) {
        switch (this.orientation) {
            case 0: {
                if (this.viewport.getView().getHeight() > this.viewport.getExtentSize().height) {
                    TableLayout layout = (TableLayout)this.getLayout();
                    layout.setRow(0, 14.0);
                    layout.setRow(4, 14.0);
                    this.scrollEnabled = true;
                    break;
                }
                TableLayout layout = (TableLayout)this.getLayout();
                layout.setRow(0, 0.0);
                layout.setRow(4, 0.0);
                this.scrollEnabled = false;
                break;
            }
            case 1: {
                if (this.viewport.getView().getWidth() > this.viewport.getExtentSize().width) {
                    TableLayout layout = (TableLayout)this.getLayout();
                    layout.setColumn(0, 14.0);
                    layout.setColumn(4, 14.0);
                    this.scrollEnabled = true;
                    break;
                }
                TableLayout layout = (TableLayout)this.getLayout();
                layout.setColumn(0, 0.0);
                layout.setColumn(4, 0.0);
                this.scrollEnabled = false;
            }
        }
    }

    public void ensureVisible(Component component) {
        Rectangle cellBounds;
        boolean found = false;
        int size = this.container.getComponentCount();
        for (int i = 0; i < size; ++i) {
            if (this.container.getComponent(i) != component) continue;
            found = true;
        }
        if (found && (cellBounds = component.getBounds()) != null) {
            switch (this.orientation) {
                case 0: {
                    cellBounds.y -= this.viewport.getViewPosition().y;
                    this.viewport.scrollRectToVisible(cellBounds);
                    break;
                }
                case 1: {
                    cellBounds.x -= this.viewport.getViewPosition().x;
                    this.viewport.scrollRectToVisible(cellBounds);
                }
            }
        }
    }

    protected void initComponents(ResourceManager resourceManager) {
        this.viewport = new JViewport();
        this.viewport.setView(this.container);
        this.viewport.addMouseWheelListener(new WheelScroller());
        switch (this.orientation) {
            case 0: {
                this.setLayout((LayoutManager)((Object)new ExtendedTableLayout(new double[][]{{-1.0}, {0.0, 1.0, -1.0, 1.0, 0.0}})));
                this.add(this.renderArrow(resourceManager, Direction.LEFT, "TOOL_SCROLL_BAR_UP"), "0,0,c,c");
                this.add((Component)this.viewport, "0,2,FULL,FULL");
                this.add(this.renderArrow(resourceManager, Direction.RIGHT, "TOOL_SCROLL_BAR_DOWN"), "0,4,c,c");
                break;
            }
            case 1: {
                this.setLayout((LayoutManager)((Object)new ExtendedTableLayout(new double[][]{{0.0, 1.0, -1.0, 1.0, 0.0}, {-1.0}})));
                this.add(this.renderArrow(resourceManager, Direction.LEFT, "TOOL_SCROLL_BAR_LEFT"), "0,0,c,c");
                this.add((Component)this.viewport, "2,0,FULL,FULL");
                this.add(this.renderArrow(resourceManager, Direction.RIGHT, "TOOL_SCROLL_BAR_RIGHT"), "4,0,c,c");
            }
        }
        this.viewport.addChangeListener(this);
    }

    protected void scrollBy(int direction, int units) {
        block0 : switch (this.orientation) {
            case 0: {
                switch (direction) {
                    case 0: {
                        Rectangle visRect = this.viewport.getViewRect();
                        Rectangle bounds = this.container.getBounds();
                        visRect.y += units;
                        if (visRect.y + visRect.height >= bounds.height) {
                            visRect.y = bounds.height - visRect.height;
                        }
                        this.viewport.setViewPosition(new Point(visRect.x, visRect.y));
                        break;
                    }
                    case 1: {
                        Rectangle visRect = this.viewport.getViewRect();
                        visRect.y -= units;
                        if (visRect.y < 0) {
                            visRect.y = 0;
                        }
                        this.viewport.setViewPosition(new Point(visRect.x, visRect.y));
                    }
                }
                break;
            }
            case 1: {
                switch (direction) {
                    case 0: {
                        Rectangle visRect = this.viewport.getViewRect();
                        Rectangle bounds = this.container.getBounds();
                        visRect.x += units;
                        if (visRect.x + visRect.width >= bounds.width) {
                            visRect.x = bounds.width - visRect.width;
                        }
                        this.viewport.setViewPosition(new Point(visRect.x, visRect.y));
                        break block0;
                    }
                    case 1: {
                        Rectangle visRect = this.viewport.getViewRect();
                        visRect.x -= units;
                        if (visRect.x < 0) {
                            visRect.x = 0;
                        }
                        this.viewport.setViewPosition(new Point(visRect.x, visRect.y));
                    }
                }
            }
        }
    }

    protected Component renderArrow(ResourceManager resourceManager, Direction direction, String iconName) {
        JLabel label = (JLabel)resourceManager.createComponent("TOOL_SCROLL_BAR_ARROW", new DefaultMutableContext("icon", iconName, ResourceManager.class, resourceManager));
        label.addMouseListener(new ArrowListener(direction));
        return label;
    }

    protected class WheelScroller
    implements MouseWheelListener {
        protected WheelScroller() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (JToolScrollBar.this.scrollEnabled) {
                JToolScrollBar.this.scrollBy(e.getWheelRotation() == 1 ? 1 : 0, e.getScrollAmount() * 3);
            }
        }
    }

    protected class ArrowListener
    extends MouseAdapter
    implements ActionListener {
        protected Timer scrollTimer = new Timer(60, this);
        protected int direction;

        public ArrowListener(Direction direction) {
            this.direction = direction == Direction.RIGHT ? 0 : 1;
        }

        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            JComponent c = (JComponent)e.getComponent();
            c.setOpaque(true);
            SwingUtil.repaint(c);
            JToolScrollBar.this.scrollBy(this.direction, 10);
            this.scrollTimer.stop();
            this.scrollTimer.start();
        }

        public void mouseReleased(MouseEvent e) {
            JComponent c = (JComponent)e.getComponent();
            c.setOpaque(false);
            SwingUtil.repaint(c);
            this.scrollTimer.stop();
        }

        public void actionPerformed(ActionEvent e) {
            JToolScrollBar.this.scrollBy(this.direction, 15);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Direction {
        LEFT,
        RIGHT;

    }
}

