/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.noos.xing.mydoggy.SlidingTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindow;
import org.noos.xing.mydoggy.plaf.cleaner.Cleaner;
import org.noos.xing.mydoggy.plaf.ui.DockedContainer;
import org.noos.xing.mydoggy.plaf.ui.MyDoggyToolWindowContainer;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;
import org.noos.xing.mydoggy.plaf.ui.animation.TransparencyAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.TranslucentPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.SlidingBorder;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.SlidingMouseInputHandler;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class SlidingContainer
extends MyDoggyToolWindowContainer
implements Cleaner {
    protected SlidingAnimation slidingAnimation;
    protected SlidingBorder border;
    protected Container barContainer;
    protected JLayeredPane layeredPane;
    protected JPanel mainPanel;
    protected TranslucentPanel sheet;
    protected SlidingMouseInputHandler slidingMouseInputHandler;

    public SlidingContainer(DockedContainer dockedContainer) {
        super(dockedContainer);
        this.initComponents();
        this.initListeners();
    }

    public void cleanup() {
        if (this.sheet != null) {
            this.sheet.removeMouseMotionListener(this.slidingMouseInputHandler);
            this.sheet.removeMouseListener(this.slidingMouseInputHandler);
        }
        this.layeredPane = null;
        super.cleanup();
    }

    public void setVisible(boolean visible, Container barContainer) {
        this.barContainer = barContainer;
        Container content = this.dockedContainer.getContentContainer();
        this.sheet.remove(content);
        this.slidingAnimation.stop();
        if (visible) {
            this.descriptor.setIdOnTitleBar();
            this.titleBarButtons.setType(ToolWindowType.SLIDING);
            TableLayout layout = (TableLayout)this.sheet.getLayout();
            layout.setColumn(0, 0.0);
            layout.setColumn(2, 0.0);
            layout.setRow(0, 0.0);
            layout.setRow(2, 0.0);
            barContainer.getParent().getLayout().layoutContainer(barContainer.getParent());
            this.resize();
            content.setVisible(true);
            this.sheet.add((Component)content, "1,1,FULL,FULL");
            this.border.setAnchor(this.toolWindow.getAnchor());
            this.sheet.setBorder(this.border);
            int height = this.mainPanel.getHeight();
            Point point = SwingUtilities.convertPoint(this.mainPanel, 0, 0, this.layeredPane);
            this.sheet.setBounds(point.x, point.y, this.mainPanel.getWidth(), height);
            this.layeredPane.remove(this.sheet);
            this.layeredPane.setLayer(this.sheet, JLayeredPane.DEFAULT_LAYER + 2);
            this.layeredPane.add(this.sheet);
            if (this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING).isAnimating()) {
                this.slidingAnimation.show(this.sheet.getBounds());
            }
        } else {
            TableLayout layout = (TableLayout)this.sheet.getLayout();
            layout.setColumn(0, 2.0);
            layout.setColumn(2, 2.0);
            layout.setRow(0, 2.0);
            layout.setRow(2, 2.0);
            switch (this.descriptor.getToolWindow().getAnchor()) {
                case TOP: 
                case BOTTOM: {
                    this.descriptor.setDividerLocation(this.sheet.getHeight());
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    this.descriptor.setDividerLocation(this.sheet.getWidth());
                }
            }
            if (this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING).isAnimating()) {
                this.slidingAnimation.hide(this.sheet.getBounds());
            } else {
                this.layeredPane.remove(this.sheet);
                this.sheet.setBorder(null);
                this.sheet.removeAll();
                SwingUtil.repaint(this.layeredPane);
            }
        }
    }

    protected void initComponents() {
        this.mainPanel = new JPanel();
        this.sheet = new TranslucentPanel((LayoutManager)((Object)new ExtendedTableLayout(new double[][]{{2.0, -1.0, 2.0}, {2.0, -1.0, 2.0}})));
        this.border = new SlidingBorder();
        this.slidingAnimation = new SlidingAnimation();
        this.layeredPane = this.descriptor.getManager().getLayeredPane();
        this.descriptor.getManager().addComponentListener(new ComponentResizer());
    }

    protected void initListeners() {
        this.addPropertyChangeListener("anchor", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MyDoggyToolWindow evtToolWindow = ((ToolWindowDescriptor)evt.getSource()).getToolWindow();
                if (SlidingContainer.this.toolWindow.getType() == ToolWindowType.SLIDING && SlidingContainer.this.toolWindow.isVisible() && !evtToolWindow.isVisible()) {
                    SlidingContainer.this.update();
                }
            }
        });
        this.addPropertyChangeListener("type", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() != SlidingContainer.this.descriptor) {
                    return;
                }
                assert ("type".equals(evt.getPropertyName()));
                if (evt.getNewValue() == ToolWindowType.SLIDING) {
                    if (SlidingContainer.this.layeredPane != null) {
                        SlidingContainer.this.sheet.addMouseMotionListener(SlidingContainer.this.slidingMouseInputHandler);
                        SlidingContainer.this.sheet.addMouseListener(SlidingContainer.this.slidingMouseInputHandler);
                    }
                } else if (SlidingContainer.this.layeredPane != null) {
                    SlidingContainer.this.sheet.removeMouseMotionListener(SlidingContainer.this.slidingMouseInputHandler);
                    SlidingContainer.this.sheet.removeMouseListener(SlidingContainer.this.slidingMouseInputHandler);
                }
            }
        });
        this.addPropertyChangeListener("active", new ActivePropertyChangeListener());
        this.addPropertyChangeListener("maximized", new MaximizedPropertyChangeListener());
        this.addPropertyChangeListener("tempShowed", new TempShowedPropertyChangeListener());
        this.addPropertyChangeListener("manager.window.anchestor", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    SlidingContainer.this.layeredPane = SlidingContainer.this.descriptor.getManager().getLayeredPane();
                }
            }
        });
        this.slidingMouseInputHandler = new SlidingMouseInputHandler(this.descriptor);
        this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING).addPropertyChangeListener((PropertyChangeListener)new SlidingTypePropertyChangeListener());
    }

    protected void update() {
        this.titleBarButtons.setType(ToolWindowType.SLIDING);
        TableLayout layout = (TableLayout)this.sheet.getLayout();
        layout.setColumn(0, 0.0);
        layout.setColumn(2, 0.0);
        layout.setRow(0, 0.0);
        layout.setRow(2, 0.0);
        if (this.barContainer != null) {
            this.barContainer.getParent().getLayout().layoutContainer(this.barContainer.getParent());
        }
        this.resize();
        Container content = this.dockedContainer.getContentContainer();
        this.sheet.remove(content);
        this.sheet.add((Component)content, "1,1,FULL,FULL");
        this.border.setAnchor(this.toolWindow.getAnchor());
        this.sheet.setBorder(this.border);
        int height = this.mainPanel.getHeight();
        Point point = SwingUtilities.convertPoint(this.mainPanel, 0, 0, this.layeredPane);
        this.sheet.setBounds(point.x, point.y, this.mainPanel.getWidth(), height);
        this.layeredPane.remove(this.sheet);
        this.layeredPane.setLayer(this.sheet, JLayeredPane.DEFAULT_LAYER + 2);
        this.layeredPane.add(this.sheet);
        this.layeredPane.validate();
    }

    protected void resize() {
        int length = Math.max(this.descriptor.getDividerLocation(), this.descriptor.getDockedTypeDescriptor().getMinimumDockLength());
        if (length == -1) {
            length = 200;
        }
        switch (this.toolWindow.getAnchor()) {
            case LEFT: {
                int height = this.barContainer.getHeight();
                this.mainPanel.setSize(length, height);
                Point location = new Point(0, 0);
                SwingUtilities.convertPointToScreen(location, this.barContainer);
                location.x += this.barContainer.getWidth();
                this.mainPanel.setLocation(location);
                break;
            }
            case RIGHT: {
                int height = this.barContainer.getHeight();
                this.mainPanel.setSize(length, height);
                Point location = new Point(0, 0);
                SwingUtilities.convertPointToScreen(location, this.barContainer);
                location.x -= this.mainPanel.getWidth();
                this.mainPanel.setLocation(location);
                break;
            }
            case TOP: {
                int width = this.barContainer.getWidth();
                this.mainPanel.setSize(width, length);
                Point location = new Point(0, 0);
                SwingUtilities.convertPointToScreen(location, this.barContainer);
                location.y += this.barContainer.getHeight();
                this.mainPanel.setLocation(location);
                break;
            }
            case BOTTOM: {
                int width = this.barContainer.getWidth();
                this.mainPanel.setSize(width, length);
                Point location = new Point(0, 0);
                SwingUtilities.convertPointToScreen(location, this.barContainer);
                location.y -= this.mainPanel.getHeight();
                this.mainPanel.setLocation(location);
            }
        }
    }

    protected class ComponentResizer
    extends ComponentAdapter
    implements Cleaner {
        public ComponentResizer() {
            SlidingContainer.this.descriptor.getCleaner().addBefore(SlidingContainer.this, this);
        }

        public void cleanup() {
            SlidingContainer.this.descriptor.getManager().removeComponentListener(this);
        }

        public void componentResized(ComponentEvent e) {
            if (SlidingContainer.this.toolWindow.getType() == ToolWindowType.SLIDING && SlidingContainer.this.toolWindow.isVisible()) {
                SlidingContainer.this.update();
            }
        }
    }

    protected class TempShowedPropertyChangeListener
    implements PropertyChangeListener {
        protected TempShowedPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (SlidingContainer.this.toolWindow.getType() == ToolWindowType.SLIDING && SlidingContainer.this.toolWindow.isVisible()) {
                SlidingContainer.this.update();
            }
        }
    }

    protected class SlidingTypePropertyChangeListener
    implements PropertyChangeListener,
    Cleaner {
        public SlidingTypePropertyChangeListener() {
            SlidingContainer.this.descriptor.getCleaner().addBefore(SlidingContainer.this, this);
        }

        public void cleanup() {
            SlidingContainer.this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING).removePropertyChangeListener((PropertyChangeListener)this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            boolean newValue;
            if ("enabled".equals(evt.getPropertyName()) && !(newValue = ((Boolean)evt.getNewValue()).booleanValue()) && SlidingContainer.this.toolWindow.getType() == ToolWindowType.SLIDING) {
                SlidingContainer.this.toolWindow.setType(ToolWindowType.DOCKED);
            }
        }
    }

    protected class MaximizedPropertyChangeListener
    implements PropertyChangeListener {
        protected Rectangle oldBounds = null;

        protected MaximizedPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (SlidingContainer.this.toolWindow.getType() == ToolWindowType.SLIDING) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    this.oldBounds = SlidingContainer.this.sheet.getBounds();
                    switch (SlidingContainer.this.toolWindow.getAnchor()) {
                        case LEFT: {
                            SlidingContainer.this.sheet.setBounds(SlidingContainer.this.sheet.getX(), SlidingContainer.this.sheet.getY(), this.calcMaxWidth(), SlidingContainer.this.sheet.getHeight());
                            break;
                        }
                        case RIGHT: {
                            SlidingContainer.this.sheet.setBounds(this.calcFirstX(), SlidingContainer.this.sheet.getY(), this.calcMaxWidth(), SlidingContainer.this.sheet.getHeight());
                            break;
                        }
                        case TOP: {
                            SlidingContainer.this.sheet.setBounds(SlidingContainer.this.sheet.getX(), SlidingContainer.this.sheet.getY(), SlidingContainer.this.sheet.getWidth(), this.calcMaxHeight());
                            break;
                        }
                        case BOTTOM: {
                            SlidingContainer.this.sheet.setBounds(SlidingContainer.this.sheet.getX(), this.calcFirstY(), SlidingContainer.this.sheet.getWidth(), this.calcMaxHeight());
                        }
                    }
                } else {
                    SlidingContainer.this.sheet.setBounds(this.oldBounds);
                }
                SwingUtil.repaint(SlidingContainer.this.sheet);
            }
        }

        protected int calcFirstX() {
            return SlidingContainer.this.descriptor.getToolWindowManagerContainerBounds().x + SlidingContainer.this.descriptor.getToolBar(ToolWindowAnchor.LEFT).getSize();
        }

        protected int calcFirstY() {
            return SlidingContainer.this.descriptor.getToolWindowManagerContainerBounds().y + SlidingContainer.this.descriptor.getToolBar(ToolWindowAnchor.TOP).getSize() + SlidingContainer.this.descriptor.getManager().getJMenuBarExtraHeight();
        }

        protected int calcMaxWidth() {
            int width = SlidingContainer.this.descriptor.getToolWindowManagerContainerBounds().width;
            width -= SlidingContainer.this.descriptor.getToolBar(ToolWindowAnchor.LEFT).getSize();
            return width -= SlidingContainer.this.descriptor.getToolBar(ToolWindowAnchor.RIGHT).getSize();
        }

        protected int calcMaxHeight() {
            int height = SlidingContainer.this.descriptor.getToolWindowManagerContainerBounds().height;
            height -= SlidingContainer.this.descriptor.getToolBar(ToolWindowAnchor.TOP).getSize();
            return height -= SlidingContainer.this.descriptor.getToolBar(ToolWindowAnchor.BOTTOM).getSize();
        }
    }

    protected class ActivePropertyChangeListener
    implements PropertyChangeListener,
    ActionListener {
        protected TransparencyAnimation animation;
        protected Timer timer;

        public ActivePropertyChangeListener() {
            this.animation = new TransparencyAnimation(SlidingContainer.this.sheet, (Component)SlidingContainer.this.sheet, 1.0f, 500.0f);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (SlidingContainer.this.descriptor.getToolWindow().getType() == ToolWindowType.SLIDING) {
                if (Boolean.TRUE.equals(evt.getNewValue())) {
                    if (this.timer != null) {
                        this.timer.stop();
                        if (this.animation.isAnimating()) {
                            this.animation.stop();
                        }
                    }
                    SlidingContainer.this.sheet.setAlphaModeRatio(1.0f);
                } else {
                    SlidingTypeDescriptor slidingTypeDescriptor = (SlidingTypeDescriptor)SlidingContainer.this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING);
                    if (slidingTypeDescriptor.isTransparentMode()) {
                        this.timer = new Timer(slidingTypeDescriptor.getTransparentDelay(), this);
                        this.timer.start();
                    }
                }
                SwingUtil.repaint(SlidingContainer.this.layeredPane);
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (this.timer.isRunning()) {
                this.timer.stop();
                SlidingTypeDescriptor slidingTypeDescriptor = (SlidingTypeDescriptor)SlidingContainer.this.descriptor.getTypeDescriptor(ToolWindowType.SLIDING);
                this.animation.setAlpha(slidingTypeDescriptor.getTransparentRatio());
                this.animation.show(new Object[0]);
            }
        }
    }

    protected class SlidingAnimation
    extends AbstractAnimation {
        protected int length;
        protected Rectangle bounds;
        protected int lastLen;

        public SlidingAnimation() {
            super(60.0f);
            this.lastLen = 0;
        }

        protected void onStartAnimation(AbstractAnimation.Direction direction) {
            this.lastLen = 0;
            switch (SlidingContainer.this.toolWindow.getAnchor()) {
                case LEFT: 
                case RIGHT: {
                    this.length = this.bounds.width;
                    break;
                }
                case TOP: 
                case BOTTOM: {
                    this.length = this.bounds.height;
                }
            }
        }

        protected void onFinishAnimation() {
            switch (this.getAnimationDirection()) {
                case INCOMING: {
                    SlidingContainer.this.sheet.setBounds(this.bounds);
                    break;
                }
                case OUTGOING: {
                    SlidingContainer.this.layeredPane.remove(SlidingContainer.this.sheet);
                    SlidingContainer.this.sheet.setBorder(null);
                    SlidingContainer.this.sheet.removeAll();
                }
            }
        }

        protected void onHide(Object ... params) {
            this.bounds = (Rectangle)params[0];
        }

        protected void onShow(Object ... params) {
            this.bounds = (Rectangle)params[0];
            switch (SlidingContainer.this.toolWindow.getAnchor()) {
                case LEFT: {
                    SlidingContainer.this.sheet.setSize(0, SlidingContainer.this.sheet.getHeight());
                    break;
                }
                case RIGHT: {
                    SlidingContainer.this.sheet.setLocation(SlidingContainer.this.sheet.getX() + SlidingContainer.this.sheet.getWidth(), SlidingContainer.this.sheet.getY());
                    SlidingContainer.this.sheet.setSize(0, SlidingContainer.this.sheet.getHeight());
                    break;
                }
                case TOP: {
                    SlidingContainer.this.sheet.setSize(SlidingContainer.this.sheet.getWidth(), 0);
                    break;
                }
                case BOTTOM: {
                    SlidingContainer.this.sheet.setLocation(SlidingContainer.this.sheet.getX(), SlidingContainer.this.sheet.getY() + SlidingContainer.this.sheet.getHeight());
                    SlidingContainer.this.sheet.setSize(SlidingContainer.this.sheet.getWidth(), 0);
                }
            }
        }

        protected float onAnimating(float animationPercent) {
            int animatingLength = 0;
            AbstractAnimation.Direction direction = this.getAnimationDirection();
            switch (SlidingContainer.this.toolWindow.getAnchor()) {
                case LEFT: {
                    animatingLength = direction == AbstractAnimation.Direction.INCOMING ? (int)(animationPercent * (float)this.length) : (int)((1.0f - animationPercent) * (float)this.length);
                    SlidingContainer.this.sheet.setSize(animatingLength, SlidingContainer.this.sheet.getHeight());
                    break;
                }
                case RIGHT: {
                    animatingLength = (int)(animationPercent * (float)this.length);
                    if (direction == AbstractAnimation.Direction.INCOMING) {
                        SlidingContainer.this.sheet.setLocation(SlidingContainer.this.sheet.getX() - (animatingLength - this.lastLen), SlidingContainer.this.sheet.getY());
                        SlidingContainer.this.sheet.setSize(animatingLength, SlidingContainer.this.sheet.getHeight());
                        break;
                    }
                    SlidingContainer.this.sheet.setLocation(this.bounds.x + animatingLength, SlidingContainer.this.sheet.getY());
                    SlidingContainer.this.sheet.setSize((int)((1.0f - animationPercent) * (float)this.length), SlidingContainer.this.sheet.getHeight());
                    break;
                }
                case TOP: {
                    animatingLength = direction == AbstractAnimation.Direction.INCOMING ? (int)(animationPercent * (float)this.length) : (int)((1.0f - animationPercent) * (float)this.length);
                    SlidingContainer.this.sheet.setSize(SlidingContainer.this.sheet.getWidth(), animatingLength);
                    break;
                }
                case BOTTOM: {
                    animatingLength = (int)(animationPercent * (float)this.length);
                    if (direction == AbstractAnimation.Direction.INCOMING) {
                        SlidingContainer.this.sheet.setLocation(SlidingContainer.this.sheet.getX(), SlidingContainer.this.sheet.getY() - (animatingLength - this.lastLen));
                        SlidingContainer.this.sheet.setSize(SlidingContainer.this.sheet.getWidth(), animatingLength);
                        break;
                    }
                    SlidingContainer.this.sheet.setLocation(SlidingContainer.this.sheet.getX(), this.bounds.y + animatingLength);
                    SlidingContainer.this.sheet.setSize(SlidingContainer.this.sheet.getWidth(), (int)((1.0f - animationPercent) * (float)this.length));
                }
            }
            SlidingContainer.this.sheet.validate();
            SlidingContainer.this.sheet.repaint();
            this.lastLen = animatingLength;
            return animationPercent;
        }

        protected AbstractAnimation.Direction chooseFinishDirection(AbstractAnimation.Type type) {
            return type == AbstractAnimation.Type.SHOW ? AbstractAnimation.Direction.NONE : super.chooseFinishDirection(type);
        }
    }
}

