/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.persistence.xml;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.noos.common.context.Context;
import org.noos.common.element.ElementParser;
import org.noos.common.element.ElementWriter;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentManagerUI;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.DesktopContentManagerUI;
import org.noos.xing.mydoggy.DesktopContentUI;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.FloatingLiveTypeDescriptor;
import org.noos.xing.mydoggy.FloatingTypeDescriptor;
import org.noos.xing.mydoggy.MostRecentDescriptor;
import org.noos.xing.mydoggy.MultiSplitContentManagerUI;
import org.noos.xing.mydoggy.MultiSplitContentUI;
import org.noos.xing.mydoggy.PersistenceDelegate;
import org.noos.xing.mydoggy.PushAwayMode;
import org.noos.xing.mydoggy.SlidingTypeDescriptor;
import org.noos.xing.mydoggy.TabbedContentManagerUI;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowBar;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.ToolWindowManagerDescriptor;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowBar;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.common.context.DefaultMutableContext;
import org.noos.xing.mydoggy.plaf.persistence.xml.XMLWriter;
import org.noos.xing.mydoggy.plaf.persistence.xml.merge.MergePolicyApplier;
import org.noos.xing.mydoggy.plaf.persistence.xml.merge.ResetMergePolicy;
import org.noos.xing.mydoggy.plaf.persistence.xml.merge.UnionMergePolicy;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitDockableContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitLayout;
import org.noos.xing.mydoggy.plaf.ui.content.MyDoggyMultiSplitContentManagerUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLPersistenceDelegate
implements PersistenceDelegate {
    protected MyDoggyToolWindowManager toolWindowManager;
    protected ElementParser<Element> masterElementParser;
    protected ElementWriter<XMLWriter> masterElementWriter;
    protected Map<PersistenceDelegate.MergePolicy, MergePolicyApplier> mergePolicyApplierMap;

    public XMLPersistenceDelegate(MyDoggyToolWindowManager toolWindowManager) {
        this.toolWindowManager = toolWindowManager;
        this.masterElementParser = new MasterElementParser();
        this.masterElementWriter = new ToolWindowManagerElementWriter(toolWindowManager);
        this.initMaps();
    }

    public void save(OutputStream outputStream) {
        try {
            XMLWriter writer = new XMLWriter(new OutputStreamWriter(outputStream));
            this.masterElementWriter.write(writer, null);
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void apply(InputStream inputStream) {
        this.merge(inputStream, PersistenceDelegate.MergePolicy.RESET);
    }

    public void merge(InputStream inputStream, PersistenceDelegate.MergePolicy mergePolicy) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            DefaultMutableContext context = new DefaultMutableContext();
            context.put(ToolWindowManager.class, this.toolWindowManager);
            context.put(MyDoggyToolWindowManager.class, this.toolWindowManager);
            context.put(MergePolicyApplier.class, this.mergePolicyApplierMap.get(mergePolicy));
            this.masterElementParser.parse(document.getDocumentElement(), context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initMaps() {
        this.mergePolicyApplierMap = new Hashtable<PersistenceDelegate.MergePolicy, MergePolicyApplier>();
        this.mergePolicyApplierMap.put(PersistenceDelegate.MergePolicy.RESET, new ResetMergePolicy());
        this.mergePolicyApplierMap.put(PersistenceDelegate.MergePolicy.UNION, new UnionMergePolicy());
    }

    public class DekstopManagerUIElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, Context context) {
            if (context.get(ToolWindowManager.class).getContentManager().getContentManagerUI() instanceof DesktopContentManagerUI) {
                DesktopContentManagerUI managerUI = (DesktopContentManagerUI)context.get(ToolWindowManager.class).getContentManager().getContentManagerUI();
                managerUI.setCloseable(this.getBoolean(element, "closeable", true));
                managerUI.setDetachable(this.getBoolean(element, "detachable", false));
                managerUI.setMinimizable(this.getBoolean(element, "minimizable", false));
                ContentManager contentManager = context.get(ToolWindowManager.class).getContentManager();
                NodeList contentUIElms = element.getElementsByTagName("content");
                int size = contentUIElms.getLength();
                for (int i = 0; i < size; ++i) {
                    Element contentUIElm = (Element)contentUIElms.item(i);
                    Content content = contentManager.getContent((Object)contentUIElm.getAttribute("id"));
                    if (content == null) continue;
                    DesktopContentUI desktopContentUI = (DesktopContentUI)content.getContentUI();
                    desktopContentUI.setIconified(this.getBoolean(contentUIElm, "iconified", false));
                    desktopContentUI.setLocation(this.getInteger(contentUIElm, "x", 0), this.getInteger(contentUIElm, "y", 0));
                    desktopContentUI.setSize(this.getInteger(contentUIElm, "width", 100), this.getInteger(contentUIElm, "height", 1000));
                }
            }
            return false;
        }
    }

    public class TabbedContentManagerUIElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, Context context) {
            if (context.get(ToolWindowManager.class).getContentManager().getContentManagerUI() instanceof TabbedContentManagerUI) {
                TabbedContentManagerUI managerUI = (TabbedContentManagerUI)context.get(ToolWindowManager.class).getContentManager().getContentManagerUI();
                managerUI.setCloseable(this.getBoolean(element, "closeable", true));
                managerUI.setDetachable(this.getBoolean(element, "detachable", false));
                managerUI.setMinimizable(this.getBoolean(element, "minimizable", false));
                managerUI.setShowAlwaysTab(this.getBoolean(element, "showAlwaysTab", false));
                managerUI.setTabLayout(TabbedContentManagerUI.TabLayout.valueOf((String)element.getAttribute("tabLayout")));
                managerUI.setTabPlacement(TabbedContentManagerUI.TabPlacement.valueOf((String)element.getAttribute("tabPlacement")));
            }
            return false;
        }
    }

    public class MultiSplitContentManagerUIElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, Context context) {
            if (context.get(ToolWindowManager.class).getContentManager().getContentManagerUI() instanceof MultiSplitContentManagerUI) {
                MultiSplitContentManagerUI managerUI = (MultiSplitContentManagerUI)context.get(ToolWindowManager.class).getContentManager().getContentManagerUI();
                managerUI.setCloseable(this.getBoolean(element, "closeable", true));
                managerUI.setDetachable(this.getBoolean(element, "detachable", false));
                managerUI.setMinimizable(this.getBoolean(element, "minimizable", false));
                managerUI.setShowAlwaysTab(this.getBoolean(element, "showAlwaysTab", false));
                managerUI.setTabLayout(TabbedContentManagerUI.TabLayout.valueOf((String)element.getAttribute("tabLayout")));
                managerUI.setTabPlacement(TabbedContentManagerUI.TabPlacement.valueOf((String)element.getAttribute("tabPlacement")));
                ContentManager contentManager = context.get(ToolWindowManager.class).getContentManager();
                Element contents = this.getElement(element, "contents");
                if (contents != null) {
                    NodeList contentUIElms = contents.getElementsByTagName("content");
                    int size = contentUIElms.getLength();
                    for (int i = 0; i < size; ++i) {
                        Element contentUIElm = (Element)contentUIElms.item(i);
                        Content content = contentManager.getContent((Object)contentUIElm.getAttribute("id"));
                        if (content == null) continue;
                        MultiSplitContentUI multiSplitContentUI = (MultiSplitContentUI)content.getContentUI();
                        multiSplitContentUI.setShowAlwaysTab(this.getBoolean(contentUIElm, "showAlwaysTab", true));
                    }
                }
                Element layout = this.getElement(element, "layout");
                MyDoggyMultiSplitContentManagerUI myDoggyMultiSplitContentManagerUI = (MyDoggyMultiSplitContentManagerUI)managerUI;
                String text = layout.getTextContent();
                XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(text.getBytes()));
                myDoggyMultiSplitContentManagerUI.setLayout(decoder.readObject());
            }
            return false;
        }
    }

    public class MainContainerModelElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, final Context context) {
            Element modelElement = this.getElement(element, "model");
            if (modelElement != null) {
                String text = modelElement.getTextContent();
                XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(text.getBytes()));
                final MultiSplitLayout.Node model = (MultiSplitLayout.Node)decoder.readObject();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MultiSplitDockableContainer dockableContainer = (MultiSplitDockableContainer)((ContentPanel)context.get(MyDoggyToolWindowManager.class).getMainContent()).getComponent();
                        dockableContainer.setModel(model);
                    }
                });
            }
            return false;
        }
    }

    public class ToolWindowBarElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, final Context context) {
            final ToolWindowAnchor anchor = ToolWindowAnchor.valueOf((String)element.getAttribute("anchor"));
            ToolWindowBar toolWindowBar = context.get(ToolWindowManager.class).getToolWindowBar(anchor);
            toolWindowBar.setDividerSize(this.getInteger(element, "left", 3));
            toolWindowBar.setAggregateMode(this.getBoolean(element, "aggregateMode", false));
            Element layoutElement = this.getElement(element, "layout");
            if (layoutElement != null) {
                String layoutAsText = layoutElement.getTextContent();
                XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(layoutAsText.getBytes()));
                final MultiSplitLayout.Node layout = (MultiSplitLayout.Node)decoder.readObject();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((MyDoggyToolWindowBar)context.get(ToolWindowManager.class).getToolWindowBar(anchor)).setLayout(layout);
                    }
                });
            }
            return false;
        }
    }

    public class ContentManagerElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, final Context context) {
            Element modelElement;
            NodeList contents = element.getElementsByTagName("content");
            Content selectedContent = null;
            Content maximizedContent = null;
            int size = contents.getLength();
            for (int i = 0; i < size; ++i) {
                Element contentElement = (Element)contents.item(i);
                Content content = context.get(ToolWindowManager.class).getContentManager().getContent((Object)contentElement.getAttribute("id"));
                if (content == null) continue;
                if (this.getBoolean(contentElement, "selected", false)) {
                    selectedContent = content;
                }
                if (this.getBoolean(contentElement, "maximized", false)) {
                    maximizedContent = content;
                }
                content.setEnabled(this.getBoolean(contentElement, "enabled", true));
                content.setDetached(this.getBoolean(contentElement, "detached", false));
                content.setMaximized(false);
                content.setMaximized(this.getBoolean(contentElement, "minimized", false));
                content.setFlashing(this.getBoolean(contentElement, "flashing", false));
                ContentUI contentUI = content.getContentUI();
                contentUI.setCloseable(this.getBoolean(contentElement, "closeable", true));
                contentUI.setDetachable(this.getBoolean(contentElement, "detachable", true));
                contentUI.setMinimizable(this.getBoolean(contentElement, "minimizable", true));
                contentUI.setTransparentMode(this.getBoolean(contentElement, "transparentMode", true));
                contentUI.setTransparentDelay(this.getInteger(contentElement, "transparentDelay", 0));
                contentUI.setTransparentRatio(this.getFloat(contentElement, "transparentRatio", 0.7f));
                contentUI.setAddToTaskBarWhenDetached(this.getBoolean(contentElement, "addToTaskBarWhenDetached", false));
                NodeList list = contentElement.getElementsByTagName("detachedBounds");
                if (list.getLength() <= 0) continue;
                Element detachedBoundsElm = (Element)list.item(0);
                contentUI.setDetachedBounds(new Rectangle(this.getInteger(detachedBoundsElm, "x", 100), this.getInteger(detachedBoundsElm, "y", 100), this.getInteger(detachedBoundsElm, "width", 320), this.getInteger(detachedBoundsElm, "height", 200)));
            }
            if (selectedContent != null) {
                selectedContent.setSelected(true);
            }
            if (maximizedContent != null) {
                maximizedContent.setMaximized(true);
            }
            if ((modelElement = this.getElement(element, "layout")) != null && !XMLPersistenceDelegate.this.toolWindowManager.getContentManager().isEnabled()) {
                String text = modelElement.getTextContent();
                XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(text.getBytes()));
                final MultiSplitLayout.Node model = (MultiSplitLayout.Node)decoder.readObject();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MultiSplitDockableContainer dockableContainer = (MultiSplitDockableContainer)((ContentPanel)context.get(MyDoggyToolWindowManager.class).getMainContent()).getComponent();
                        dockableContainer.setModel(model);
                    }
                });
            }
            return false;
        }
    }

    public class ToolsElementParser
    extends ElementParserAdapter {
        protected MergePolicyApplier mergePolicyApplier;

        public boolean parse(Element element, Context context) {
            this.mergePolicyApplier = context.get(MergePolicyApplier.class);
            NodeList tools = element.getElementsByTagName("toolWindow");
            int size = tools.getLength();
            for (int i = 0; i < size; ++i) {
                ToolWindowType type;
                Element floatingLiveType;
                Element floatingType;
                Element slidingType;
                Element tool = (Element)tools.item(i);
                ToolWindow toolWindow = context.get(ToolWindowManager.class).getToolWindow((Object)tool.getAttribute("id"));
                if (toolWindow == null) continue;
                Element dockedType = this.getElement(tool, "docked");
                if (dockedType != null) {
                    DockedTypeDescriptor descriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
                    descriptor.setDockLength(this.getInteger(dockedType, "dockLength", 200));
                    descriptor.setMinimumDockLength(this.getInteger(dockedType, "minimumDockLength", 100));
                    descriptor.setPopupMenuEnabled(this.getBoolean(dockedType, "popupMenuEnabled", true));
                    descriptor.setAnimating(this.getBoolean(dockedType, "animating", true));
                    descriptor.setPreviewEnabled(this.getBoolean(dockedType, "previewEnabled", true));
                    descriptor.setPreviewDelay(this.getInteger(dockedType, "previewDelay", 0));
                    descriptor.setPreviewTransparentRatio(this.getFloat(dockedType, "previewTransparentRatio", 0.7f));
                    descriptor.setIdVisibleOnTitleBar(this.getBoolean(dockedType, "idVisibleOnTitleBar", true));
                    descriptor.setHideRepresentativeButtonOnVisible(this.getBoolean(dockedType, "hideRepresentativeButtonOnVisible", false));
                    descriptor.setAutoHide(this.getBoolean(dockedType, "autoHide", false));
                }
                if ((slidingType = this.getElement(tool, "sliding")) != null) {
                    SlidingTypeDescriptor descriptor = (SlidingTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.SLIDING);
                    descriptor.setEnabled(this.getBoolean(slidingType, "enabled", true));
                    descriptor.setTransparentDelay(this.getInteger(slidingType, "transparentDelay", 0));
                    descriptor.setTransparentMode(this.getBoolean(slidingType, "transparentMode", true));
                    descriptor.setTransparentRatio(this.getFloat(slidingType, "transparentRatio", 0.7f));
                    descriptor.setAnimating(this.getBoolean(slidingType, "animating", true));
                    descriptor.setIdVisibleOnTitleBar(this.getBoolean(slidingType, "idVisibleOnTitleBar", true));
                    descriptor.setAutoHide(this.getBoolean(slidingType, "autoHide", false));
                }
                if ((floatingType = this.getElement(tool, "floating")) != null) {
                    Element dimension;
                    FloatingTypeDescriptor descriptor = (FloatingTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.FLOATING);
                    descriptor.setEnabled(this.getBoolean(floatingType, "enabled", true));
                    descriptor.setTransparentDelay(this.getInteger(floatingType, "transparentDelay", 0));
                    descriptor.setTransparentMode(this.getBoolean(floatingType, "transparentMode", true));
                    descriptor.setTransparentRatio(this.getFloat(floatingType, "transparentRatio", 0.7f));
                    descriptor.setModal(this.getBoolean(floatingType, "modal", false));
                    descriptor.setAnimating(this.getBoolean(floatingType, "animating", true));
                    descriptor.setIdVisibleOnTitleBar(this.getBoolean(floatingType, "idVisibleOnTitleBar", true));
                    descriptor.setAutoHide(this.getBoolean(floatingType, "autoHide", false));
                    descriptor.setAddToTaskBar(this.getBoolean(floatingType, "addToTaskBar", false));
                    Element location = this.getElement(floatingType, "location");
                    if (location != null) {
                        descriptor.setLocation(this.getInteger(location, "x", 0), this.getInteger(location, "y", 0));
                    }
                    if ((dimension = this.getElement(floatingType, "size")) != null) {
                        descriptor.setSize(this.getInteger(dimension, "width", 100), this.getInteger(dimension, "height", 100));
                    }
                }
                if ((floatingLiveType = this.getElement(tool, "floatingLive")) != null) {
                    Element dimension;
                    FloatingLiveTypeDescriptor descriptor = (FloatingLiveTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.FLOATING_LIVE);
                    descriptor.setEnabled(this.getBoolean(floatingLiveType, "enabled", true));
                    descriptor.setTransparentDelay(this.getInteger(floatingLiveType, "transparentDelay", 0));
                    descriptor.setTransparentMode(this.getBoolean(floatingLiveType, "transparentMode", true));
                    descriptor.setTransparentRatio(this.getFloat(floatingLiveType, "transparentRatio", 0.7f));
                    descriptor.setAnimating(this.getBoolean(floatingLiveType, "animating", true));
                    descriptor.setIdVisibleOnTitleBar(this.getBoolean(floatingLiveType, "idVisibleOnTitleBar", true));
                    descriptor.setAutoHide(this.getBoolean(floatingType, "autoHide", false));
                    Element location = this.getElement(floatingType, "location");
                    if (location != null) {
                        descriptor.setLocation(this.getInteger(location, "x", 0), this.getInteger(location, "y", 0));
                    }
                    if ((dimension = this.getElement(floatingType, "size")) != null) {
                        descriptor.setSize(this.getInteger(dimension, "width", 100), this.getInteger(dimension, "height", 100));
                    }
                }
                if ((type = ToolWindowType.valueOf((String)tool.getAttribute("type"))) != ToolWindowType.EXTERN) {
                    toolWindow.setType(type);
                }
                toolWindow.setAutoHide(this.getBoolean(tool, "autoHide", false));
                toolWindow.setAvailable(this.getBoolean(tool, "available", false));
                int index = this.getInteger(tool, "index", -1);
                if (index != -1) {
                    toolWindow.setIndex(index);
                }
                toolWindow.setAggregateMode(this.getBoolean(tool, "aggregateMode", false));
                if (toolWindow.getType() != ToolWindowType.FLOATING_FREE) {
                    toolWindow.setRepresentativeAnchorButtonVisible(this.getBoolean(tool, "representativeAnchorButtonVisible", true));
                }
                toolWindow.setFlashing(this.getBoolean(tool, "flashing", false));
                Element tabs = this.getElement(tool, "tabs");
                if (tabs != null) {
                    NodeList tabList = tabs.getElementsByTagName("tab");
                    block1: for (ToolWindowTab tab : toolWindow.getToolWindowTabs()) {
                        if (tab.getDockableDelegator() == null) continue;
                        String dockableId = tab.getDockableDelegator().getId();
                        int sizej = tabList.getLength();
                        for (int j = 0; j < sizej; ++j) {
                            Element tabElement = (Element)tabList.item(j);
                            if (!dockableId.equals(tabElement.getAttribute("dockableId"))) continue;
                            toolWindow.removeToolWindowTab(tab);
                            continue block1;
                        }
                    }
                    ToolWindowTab selectedTab = null;
                    ToolWindowTab maximizedTab = null;
                    int sizej = tabList.getLength();
                    for (int j = 0; j < sizej; ++j) {
                        Element tabElement = (Element)tabList.item(j);
                        String dockableId = tabElement.getAttribute("dockableId");
                        boolean selected = this.getBoolean(tabElement, "selected", false);
                        boolean maximized = this.getBoolean(tabElement, "maximized", false);
                        Dockable dockable = context.get(ToolWindowManager.class).getDockable((Object)dockableId);
                        if (dockable == null) continue;
                        ToolWindowTab tab = toolWindow.addToolWindowTab(dockable);
                        if (selected) {
                            selectedTab = tab;
                        }
                        if (maximized) {
                            maximizedTab = tab;
                        }
                        tab.setSelected(false);
                        tab.setMaximized(false);
                        tab.setCloseable(this.getBoolean(tabElement, "closeable", true));
                        tab.setFlashing(this.getBoolean(tabElement, "flashing", false));
                        tab.setMinimized(this.getBoolean(tabElement, "minimized", false));
                    }
                    if (maximizedTab != null) {
                        maximizedTab.setMaximized(true);
                    }
                    if (selectedTab == null) continue;
                    selectedTab.setSelected(true);
                    continue;
                }
                for (ToolWindowTab tab : toolWindow.getToolWindowTabs()) {
                    if (tab.getDockableDelegator() == null) continue;
                    toolWindow.removeToolWindowTab(tab);
                }
            }
            this.apply(context, tools, ToolWindowAnchor.LEFT);
            this.apply(context, tools, ToolWindowAnchor.BOTTOM);
            this.apply(context, tools, ToolWindowAnchor.RIGHT);
            this.apply(context, tools, ToolWindowAnchor.TOP);
            return false;
        }

        protected void apply(Context context, NodeList tools, ToolWindowAnchor anchor) {
            ArrayList<Element> toolsByAnchor = new ArrayList<Element>();
            int size = tools.getLength();
            for (int i = 0; i < size; ++i) {
                Element tool = (Element)tools.item(i);
                if (ToolWindowAnchor.valueOf((String)tool.getAttribute("anchor")) != anchor) continue;
                toolsByAnchor.add(tool);
            }
            Collections.sort(toolsByAnchor, new Comparator<Element>(){

                @Override
                public int compare(Element o1, Element o2) {
                    int anchorIndex2;
                    int anchorIndex1 = ToolsElementParser.this.getInteger(o1, "anchorIndex", 0);
                    if (anchorIndex1 < (anchorIndex2 = ToolsElementParser.this.getInteger(o2, "anchorIndex", 0))) {
                        return -1;
                    }
                    if (anchorIndex1 == anchorIndex2) {
                        return 0;
                    }
                    return 1;
                }
            });
            ToolWindow activeTool = null;
            ToolWindow maximizedTool = null;
            for (Element tool : toolsByAnchor) {
                ToolWindow toolWindow = context.get(ToolWindowManager.class).getToolWindow((Object)tool.getAttribute("id"));
                if (toolWindow == null) continue;
                int anchorIndex = this.getInteger(tool, "anchorIndex", Integer.MIN_VALUE);
                ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
                if (this.isAttributePresent(tool, "anchor")) {
                    toolWindowAnchor = ToolWindowAnchor.valueOf((String)tool.getAttribute("anchor"));
                }
                if (anchorIndex == Integer.MIN_VALUE) {
                    toolWindow.setAnchor(toolWindowAnchor);
                } else {
                    toolWindow.setAnchor(toolWindowAnchor, anchorIndex);
                }
                this.mergePolicyApplier.applyToolWindow(toolWindow, tool);
                if (this.getBoolean(tool, "active", false)) {
                    activeTool = toolWindow;
                }
                if (!this.getBoolean(tool, "maximized", false)) continue;
                maximizedTool = toolWindow;
            }
            if (activeTool != null) {
                activeTool.setActive(true);
            }
            if (maximizedTool != null) {
                maximizedTool.setMaximized(true);
            }
        }
    }

    public class PushAwayModeElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, Context context) {
            ToolWindowManagerDescriptor descriptor = context.get(ToolWindowManager.class).getToolWindowManagerDescriptor();
            NodeList modes = element.getElementsByTagName("mode");
            int size = modes.getLength();
            for (int i = 0; i < size; ++i) {
                Element mode = (Element)modes.item(i);
                if (!"MOST_RECENT".equals(mode.getAttribute("type"))) continue;
                MostRecentDescriptor mostRecentDescriptor = (MostRecentDescriptor)descriptor.getPushAwayModeDescriptor(PushAwayMode.MOST_RECENT);
                NodeList anchors = element.getElementsByTagName("anchor");
                int sizej = anchors.getLength();
                for (int j = 0; j < sizej; ++j) {
                    Element anchor = (Element)anchors.item(j);
                    mostRecentDescriptor.append(new ToolWindowAnchor[]{ToolWindowAnchor.valueOf((String)anchor.getAttribute("type"))});
                }
            }
            if (this.isAttributePresent(element, "pushAwayMode")) {
                descriptor.setPushAwayMode(PushAwayMode.valueOf((String)element.getAttribute("pushAwayMode")));
            }
            return false;
        }
    }

    public class ToolWindowManagerDescriptorElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, Context context) {
            ToolWindowManagerDescriptor descriptor = context.get(ToolWindowManager.class).getToolWindowManagerDescriptor();
            descriptor.setNumberingEnabled(this.getBoolean(element, "numberingEnabled", true));
            descriptor.setPreviewEnabled(this.getBoolean(element, "previewEnabled", true));
            descriptor.setShowUnavailableTools(this.getBoolean(element, "showUnavailableTools", false));
            return true;
        }
    }

    public class MyDoggyElementParser
    extends ElementParserAdapter {
        public boolean parse(Element element, Context context) {
            if (!"1.4.2".equals(element.getAttribute("version"))) {
                throw new IllegalArgumentException("Invalid workspace version. Expected 1.4.2");
            }
            ContentManager contentManager = context.get(ToolWindowManager.class).getContentManager();
            contentManager.setEnabled(this.getBoolean(element, "contentManagerEnabled", true));
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ElementParserAdapter
    implements ElementParser<Element> {
        public Element getElement(Element root, String name) {
            NodeList list = root.getElementsByTagName(name);
            if (list.getLength() == 0) {
                return null;
            }
            return (Element)list.item(0);
        }

        public boolean getBoolean(Element element, String name, boolean defaultValue) {
            try {
                String attr = element.getAttribute(name);
                if (attr != null && !"".equals(attr.trim())) {
                    return Boolean.parseBoolean(attr);
                }
                return defaultValue;
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public int getInteger(Element element, String name, int defaultValue) {
            try {
                String attr = element.getAttribute(name);
                if (attr != null && !"".equals(attr.trim())) {
                    return Integer.parseInt(attr);
                }
                return defaultValue;
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public float getFloat(Element element, String name, float defaultValue) {
            try {
                String attr = element.getAttribute(name);
                if (attr != null && !"".equals(attr.trim())) {
                    return Float.parseFloat(attr);
                }
                return defaultValue;
            }
            catch (Exception e) {
                return defaultValue;
            }
        }

        public boolean isAttributePresent(Element element, String name) {
            String attr = element.getAttribute(name);
            return attr != null && !"".equals(attr.trim());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MasterElementParser
    implements ElementParser<Element> {
        protected Map<String, ElementParser<Element>> elementParserMap = new Hashtable<String, ElementParser<Element>>();

        public MasterElementParser() {
            this.populateParserMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean parse(Element element, Context context) {
            try {
                context.get(MyDoggyToolWindowManager.class).putClientProperty("PERSISTENCE_DELEGATE_PARSING", this);
                boolean bl = this.parseTree(element, context);
                return bl;
            }
            finally {
                context.get(MyDoggyToolWindowManager.class).putClientProperty("PERSISTENCE_DELEGATE_PARSING", null);
            }
        }

        public boolean parseTree(Element element, Context context) {
            ElementParser<Element> elementParser = this.elementParserMap.get(element.getNodeName());
            if (elementParser == null || elementParser.parse(element, context)) {
                NodeList children = element.getChildNodes();
                int size = children.getLength();
                for (int i = 0; i < size; ++i) {
                    Node node = children.item(i);
                    if (node.getNodeType() != 1) continue;
                    this.parse((Element)node, context);
                }
            }
            return false;
        }

        protected void populateParserMap() {
            this.elementParserMap.put("mydoggy", new MyDoggyElementParser());
            this.elementParserMap.put("toolWindowManagerDescriptor", new ToolWindowManagerDescriptorElementParser());
            this.elementParserMap.put("pushAway", new PushAwayModeElementParser());
            this.elementParserMap.put("toolWindows", new ToolsElementParser());
            this.elementParserMap.put("contentManager", new ContentManagerElementParser());
            this.elementParserMap.put("toolWindowBar", new ToolWindowBarElementParser());
            this.elementParserMap.put("MultiSplitContentManagerUI", new MultiSplitContentManagerUIElementParser());
            this.elementParserMap.put("TabbedContentManagerUI", new TabbedContentManagerUIElementParser());
            this.elementParserMap.put("DesktopContentManagerUI", new DekstopManagerUIElementParser());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ToolWindowAnchorEntityWriter
    implements ElementWriter<XMLWriter> {
        @Override
        public void write(XMLWriter writer, Context context) {
            try {
                ToolWindowManager toolWindowManager = context.get(ToolWindowManager.class);
                writer.startElement("toolWindowBars");
                this.saveBar(writer, (MyDoggyToolWindowBar)toolWindowManager.getToolWindowBar(ToolWindowAnchor.LEFT));
                this.saveBar(writer, (MyDoggyToolWindowBar)toolWindowManager.getToolWindowBar(ToolWindowAnchor.BOTTOM));
                this.saveBar(writer, (MyDoggyToolWindowBar)toolWindowManager.getToolWindowBar(ToolWindowAnchor.RIGHT));
                this.saveBar(writer, (MyDoggyToolWindowBar)toolWindowManager.getToolWindowBar(ToolWindowAnchor.TOP));
                writer.endElement("toolWindowBars");
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }

        protected void saveBar(XMLWriter writer, MyDoggyToolWindowBar toolWindowBar) throws SAXException {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(null, "anchor", null, null, toolWindowBar.getAnchor().toString());
            attributes.addAttribute(null, "dividerSize", null, null, String.valueOf(toolWindowBar.getDividerSize()));
            attributes.addAttribute(null, "aggregateMode", null, null, String.valueOf(toolWindowBar.isAggregateMode()));
            writer.startElement("toolWindowBar", attributes);
            if (toolWindowBar.getToolWindows().length > 0) {
                writer.startElement("layout");
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                XMLEncoder encoder = new XMLEncoder(os);
                encoder.writeObject(toolWindowBar.getLayout());
                encoder.flush();
                encoder.close();
                String model = os.toString();
                writer.cdata(model.substring(model.indexOf(10)));
                writer.endElement("layout");
            }
            writer.endElement("toolWindowBar");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DesktopContentManagerUIEntityWriter
    implements ElementWriter<XMLWriter> {
        @Override
        public void write(XMLWriter writer, Context context) {
            try {
                DesktopContentManagerUI desktopContentManagerUI = (DesktopContentManagerUI)context.get(ContentManagerUI.class);
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute(null, "closeable", null, null, String.valueOf(desktopContentManagerUI.isCloseable()));
                attributes.addAttribute(null, "detachable", null, null, String.valueOf(desktopContentManagerUI.isDetachable()));
                attributes.addAttribute(null, "minimizable", null, null, String.valueOf(desktopContentManagerUI.isMinimizable()));
                writer.startElement("DesktopContentManagerUI", attributes);
                writer.startElement("contents");
                for (Content content : context.get(ContentManager.class).getContents()) {
                    DesktopContentUI contentUI = (DesktopContentUI)content.getContentUI();
                    AttributesImpl contentUIAttributes = new AttributesImpl();
                    contentUIAttributes.addAttribute(null, "id", null, null, content.getId());
                    contentUIAttributes.addAttribute(null, "x", null, null, String.valueOf(contentUI.getLocation().x));
                    contentUIAttributes.addAttribute(null, "y", null, null, String.valueOf(contentUI.getLocation().y));
                    contentUIAttributes.addAttribute(null, "width", null, null, String.valueOf(contentUI.getSize().width));
                    contentUIAttributes.addAttribute(null, "height", null, null, String.valueOf(contentUI.getSize().height));
                    contentUIAttributes.addAttribute(null, "iconified", null, null, String.valueOf(contentUI.isIconified()));
                    writer.dataElement("content", contentUIAttributes);
                }
                writer.endElement("contents");
                writer.endElement("DesktopContentManagerUI");
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MultiSplitContentManagerUIEntityPWriter
    implements ElementWriter<XMLWriter> {
        @Override
        public void write(XMLWriter writer, Context context) {
            try {
                MultiSplitContentManagerUI multiSplitContentManagerUI = (MultiSplitContentManagerUI)context.get(ContentManagerUI.class);
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute(null, "closeable", null, null, String.valueOf(multiSplitContentManagerUI.isCloseable()));
                attributes.addAttribute(null, "detachable", null, null, String.valueOf(multiSplitContentManagerUI.isDetachable()));
                attributes.addAttribute(null, "minimizable", null, null, String.valueOf(multiSplitContentManagerUI.isMinimizable()));
                attributes.addAttribute(null, "showAlwaysTab", null, null, String.valueOf(multiSplitContentManagerUI.isShowAlwaysTab()));
                attributes.addAttribute(null, "tabLayout", null, null, multiSplitContentManagerUI.getTabLayout().toString());
                attributes.addAttribute(null, "tabPlacement", null, null, multiSplitContentManagerUI.getTabPlacement().toString());
                writer.startElement("MultiSplitContentManagerUI", attributes);
                writer.startElement("contents");
                for (Content content : context.get(ContentManager.class).getContents()) {
                    MultiSplitContentUI contentUI = (MultiSplitContentUI)content.getContentUI();
                    AttributesImpl contentUIAttributes = new AttributesImpl();
                    contentUIAttributes.addAttribute(null, "id", null, null, content.getId());
                    contentUIAttributes.addAttribute(null, "showAlwaysTab", null, null, String.valueOf(contentUI.isShowAlwaysTab()));
                    writer.dataElement("content", contentUIAttributes);
                }
                writer.endElement("contents");
                writer.startElement("layout");
                MyDoggyMultiSplitContentManagerUI splitContentManagerUI = (MyDoggyMultiSplitContentManagerUI)multiSplitContentManagerUI;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                XMLEncoder encoder = new XMLEncoder(os);
                encoder.writeObject(splitContentManagerUI.getLayout());
                encoder.flush();
                encoder.close();
                String model = os.toString();
                writer.cdata(model.substring(model.indexOf(10)));
                writer.endElement("layout");
                writer.endElement("MultiSplitContentManagerUI");
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TabbedContentManagerUIEntityPWriter
    implements ElementWriter<XMLWriter> {
        @Override
        public void write(XMLWriter writer, Context context) {
            try {
                TabbedContentManagerUI tabbedContentManagerUI = (TabbedContentManagerUI)context.get(ContentManagerUI.class);
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute(null, "closeable", null, null, String.valueOf(tabbedContentManagerUI.isCloseable()));
                attributes.addAttribute(null, "detachable", null, null, String.valueOf(tabbedContentManagerUI.isDetachable()));
                attributes.addAttribute(null, "minimizable", null, null, String.valueOf(tabbedContentManagerUI.isMinimizable()));
                attributes.addAttribute(null, "showAlwaysTab", null, null, String.valueOf(tabbedContentManagerUI.isShowAlwaysTab()));
                attributes.addAttribute(null, "tabLayout", null, null, tabbedContentManagerUI.getTabLayout().toString());
                attributes.addAttribute(null, "tabPlacement", null, null, tabbedContentManagerUI.getTabPlacement().toString());
                writer.dataElement("TabbedContentManagerUI", attributes);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ContentManagerEntityWriter
    implements ElementWriter<XMLWriter> {
        @Override
        public void write(XMLWriter writer, Context context) {
            try {
                ContentManager contentManager = context.get(ContentManager.class);
                writer.startElement("contentManager");
                writer.startElement("contents");
                for (Content content : contentManager.getContents()) {
                    ContentUI contentUI = content.getContentUI();
                    AttributesImpl contentAttributes = new AttributesImpl();
                    contentAttributes.addAttribute(null, "id", null, null, content.getId());
                    contentAttributes.addAttribute(null, "detached", null, null, String.valueOf(content.isDetached()));
                    contentAttributes.addAttribute(null, "enabled", null, null, String.valueOf(content.isEnabled()));
                    contentAttributes.addAttribute(null, "selected", null, null, String.valueOf(content.isSelected()));
                    contentAttributes.addAttribute(null, "maximized", null, null, String.valueOf(content.isMaximized()));
                    contentAttributes.addAttribute(null, "minimized", null, null, String.valueOf(content.isMinimized()));
                    contentAttributes.addAttribute(null, "flashing", null, null, String.valueOf(content.isFlashing()));
                    contentAttributes.addAttribute(null, "closeable", null, null, String.valueOf(contentUI.isCloseable()));
                    contentAttributes.addAttribute(null, "detachable", null, null, String.valueOf(contentUI.isDetachable()));
                    contentAttributes.addAttribute(null, "minimizable", null, null, String.valueOf(contentUI.isMinimizable()));
                    contentAttributes.addAttribute(null, "transparentMode", null, null, String.valueOf(contentUI.isTransparentMode()));
                    contentAttributes.addAttribute(null, "transparentDelay", null, null, String.valueOf(contentUI.getTransparentDelay()));
                    contentAttributes.addAttribute(null, "transparentRatio", null, null, String.valueOf(contentUI.getTransparentRatio()));
                    contentAttributes.addAttribute(null, "addToTaskBarWhenDetached", null, null, String.valueOf(contentUI.isAddToTaskBarWhenDetached()));
                    writer.startElement("content", contentAttributes);
                    Rectangle detachedBounds = contentUI.getDetachedBounds();
                    if (detachedBounds != null) {
                        AttributesImpl attributes = new AttributesImpl();
                        attributes.addAttribute(null, "x", null, null, String.valueOf(detachedBounds.x));
                        attributes.addAttribute(null, "y", null, null, String.valueOf(detachedBounds.y));
                        attributes.addAttribute(null, "width", null, null, String.valueOf(detachedBounds.width));
                        attributes.addAttribute(null, "height", null, null, String.valueOf(detachedBounds.height));
                        writer.dataElement("detachedBounds", attributes);
                    }
                    writer.endElement("content");
                }
                writer.endElement("contents");
                if (!contentManager.isEnabled()) {
                    MultiSplitDockableContainer dockableContainer = (MultiSplitDockableContainer)((ContentPanel)XMLPersistenceDelegate.this.toolWindowManager.getMainContent()).getComponent();
                    writer.startElement("layout");
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    XMLEncoder encoder = new XMLEncoder(os);
                    encoder.writeObject(dockableContainer.getModel());
                    encoder.flush();
                    encoder.close();
                    String model = os.toString();
                    writer.cdata(model.substring(model.indexOf(10)));
                    writer.endElement("layout");
                }
                writer.endElement("contentManager");
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ToolWindowManagerDescriptorEntityWriter
    implements ElementWriter<XMLWriter> {
        @Override
        public void write(XMLWriter writer, Context context) {
            try {
                ToolWindowManagerDescriptor descriptor = context.get(ToolWindowManagerDescriptor.class);
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute(null, "numberingEnabled", null, null, String.valueOf(descriptor.isNumberingEnabled()));
                attributes.addAttribute(null, "previewEnabled", null, null, String.valueOf(descriptor.isPreviewEnabled()));
                attributes.addAttribute(null, "showUnavailableTools", null, null, String.valueOf(descriptor.isShowUnavailableTools()));
                writer.startElement("toolWindowManagerDescriptor", attributes);
                attributes = new AttributesImpl();
                attributes.addAttribute(null, "pushAwayMode", null, null, descriptor.getPushAwayMode().toString());
                writer.startElement("pushAway", attributes);
                attributes = new AttributesImpl();
                attributes.addAttribute(null, "type", null, null, String.valueOf(PushAwayMode.MOST_RECENT));
                writer.startElement("mode", attributes);
                MostRecentDescriptor mostRecentDescriptor = (MostRecentDescriptor)descriptor.getPushAwayModeDescriptor(PushAwayMode.MOST_RECENT);
                for (ToolWindowAnchor toolWindowAnchor : mostRecentDescriptor.getMostRecentAnchors()) {
                    AttributesImpl anchorAttributes = new AttributesImpl();
                    anchorAttributes.addAttribute(null, "type", null, null, String.valueOf(toolWindowAnchor));
                    writer.dataElement("anchor", anchorAttributes);
                }
                writer.endElement("mode");
                writer.endElement("pushAway");
                writer.endElement("toolWindowManagerDescriptor");
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ToolWindowEntityWriter
    implements ElementWriter<XMLWriter> {
        @Override
        public void write(XMLWriter writer, Context context) {
            try {
                ToolWindow toolWindow = context.get(ToolWindow.class);
                AttributesImpl toolAttributes = new AttributesImpl();
                toolAttributes.addAttribute(null, "id", null, null, String.valueOf(toolWindow.getId()));
                toolAttributes.addAttribute(null, "available", null, null, String.valueOf(toolWindow.isAvailable()));
                toolAttributes.addAttribute(null, "visible", null, null, String.valueOf(toolWindow.isVisible()));
                toolAttributes.addAttribute(null, "active", null, null, String.valueOf(toolWindow.isActive()));
                toolAttributes.addAttribute(null, "autoHide", null, null, String.valueOf(toolWindow.isAutoHide()));
                toolAttributes.addAttribute(null, "anchor", null, null, String.valueOf(toolWindow.getAnchor()));
                toolAttributes.addAttribute(null, "anchorIndex", null, null, String.valueOf(toolWindow.getAnchorIndex()));
                toolAttributes.addAttribute(null, "type", null, null, String.valueOf(toolWindow.getType()));
                toolAttributes.addAttribute(null, "aggregateMode", null, null, String.valueOf(toolWindow.isAggregateMode()));
                toolAttributes.addAttribute(null, "maximized", null, null, String.valueOf(toolWindow.isMaximized()));
                toolAttributes.addAttribute(null, "index", null, null, String.valueOf(toolWindow.getIndex()));
                toolAttributes.addAttribute(null, "representativeAnchorButtonVisible", null, null, String.valueOf(toolWindow.isRepresentativeAnchorButtonVisible()));
                toolAttributes.addAttribute(null, "flashing", null, null, String.valueOf(toolWindow.isFlashing()));
                writer.startElement("toolWindow", toolAttributes);
                writer.startElement("descriptors");
                DockedTypeDescriptor dockedTypeDescriptor = (DockedTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.DOCKED);
                AttributesImpl dockedDescriptorAttributes = new AttributesImpl();
                dockedDescriptorAttributes.addAttribute(null, "dockLength", null, null, String.valueOf(dockedTypeDescriptor.getDockLength()));
                dockedDescriptorAttributes.addAttribute(null, "minimumDockLength", null, null, String.valueOf(dockedTypeDescriptor.getMinimumDockLength()));
                dockedDescriptorAttributes.addAttribute(null, "popupMenuEnabled", null, null, String.valueOf(dockedTypeDescriptor.isPopupMenuEnabled()));
                dockedDescriptorAttributes.addAttribute(null, "animating", null, null, String.valueOf(dockedTypeDescriptor.isAnimating()));
                dockedDescriptorAttributes.addAttribute(null, "previewEnabled", null, null, String.valueOf(dockedTypeDescriptor.isPreviewEnabled()));
                dockedDescriptorAttributes.addAttribute(null, "previewDelay", null, null, String.valueOf(dockedTypeDescriptor.getPreviewDelay()));
                dockedDescriptorAttributes.addAttribute(null, "previewTransparentRatio", null, null, String.valueOf(dockedTypeDescriptor.getPreviewTransparentRatio()));
                dockedDescriptorAttributes.addAttribute(null, "hideRepresentativeButtonOnVisible", null, null, String.valueOf(dockedTypeDescriptor.isHideRepresentativeButtonOnVisible()));
                dockedDescriptorAttributes.addAttribute(null, "idVisibleOnTitleBar", null, null, String.valueOf(dockedTypeDescriptor.isIdVisibleOnTitleBar()));
                dockedDescriptorAttributes.addAttribute(null, "autoHide", null, null, String.valueOf(dockedTypeDescriptor.isAutoHide()));
                writer.dataElement("docked", dockedDescriptorAttributes);
                SlidingTypeDescriptor slidingTypeDescriptor = (SlidingTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.SLIDING);
                AttributesImpl slidingDescriptorAttributes = new AttributesImpl();
                slidingDescriptorAttributes.addAttribute(null, "transparentMode", null, null, String.valueOf(slidingTypeDescriptor.isTransparentMode()));
                slidingDescriptorAttributes.addAttribute(null, "transparentDelay", null, null, String.valueOf(slidingTypeDescriptor.getTransparentDelay()));
                slidingDescriptorAttributes.addAttribute(null, "transparentRatio", null, null, String.valueOf(slidingTypeDescriptor.getTransparentRatio()));
                slidingDescriptorAttributes.addAttribute(null, "enabled", null, null, String.valueOf(slidingTypeDescriptor.isEnabled()));
                slidingDescriptorAttributes.addAttribute(null, "animating", null, null, String.valueOf(slidingTypeDescriptor.isAnimating()));
                slidingDescriptorAttributes.addAttribute(null, "idVisibleOnTitleBar", null, null, String.valueOf(slidingTypeDescriptor.isIdVisibleOnTitleBar()));
                slidingDescriptorAttributes.addAttribute(null, "autoHide", null, null, String.valueOf(slidingTypeDescriptor.isAutoHide()));
                writer.dataElement("sliding", slidingDescriptorAttributes);
                FloatingTypeDescriptor floatingTypeDescriptor = (FloatingTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.FLOATING);
                AttributesImpl floatingDescriptorAttributes = new AttributesImpl();
                floatingDescriptorAttributes.addAttribute(null, "modal", null, null, String.valueOf(floatingTypeDescriptor.isModal()));
                floatingDescriptorAttributes.addAttribute(null, "transparentMode", null, null, String.valueOf(floatingTypeDescriptor.isTransparentMode()));
                floatingDescriptorAttributes.addAttribute(null, "transparentDelay", null, null, String.valueOf(floatingTypeDescriptor.getTransparentDelay()));
                floatingDescriptorAttributes.addAttribute(null, "transparentRatio", null, null, String.valueOf(floatingTypeDescriptor.getTransparentRatio()));
                floatingDescriptorAttributes.addAttribute(null, "enabled", null, null, String.valueOf(floatingTypeDescriptor.isEnabled()));
                floatingDescriptorAttributes.addAttribute(null, "animating", null, null, String.valueOf(floatingTypeDescriptor.isAnimating()));
                floatingDescriptorAttributes.addAttribute(null, "idVisibleOnTitleBar", null, null, String.valueOf(floatingTypeDescriptor.isIdVisibleOnTitleBar()));
                floatingDescriptorAttributes.addAttribute(null, "autoHide", null, null, String.valueOf(floatingTypeDescriptor.isAutoHide()));
                floatingDescriptorAttributes.addAttribute(null, "addToTaskBar", null, null, String.valueOf(floatingTypeDescriptor.isAddToTaskBar()));
                Point point = floatingTypeDescriptor.getLocation();
                Dimension dimension = floatingTypeDescriptor.getSize();
                if (point != null || dimension != null) {
                    AttributesImpl attributes;
                    writer.startElement("floating", floatingDescriptorAttributes);
                    if (point != null) {
                        attributes = new AttributesImpl();
                        attributes.addAttribute(null, "x", null, null, String.valueOf(point.x));
                        attributes.addAttribute(null, "y", null, null, String.valueOf(point.y));
                        writer.dataElement("location", attributes);
                    }
                    if (dimension != null) {
                        attributes = new AttributesImpl();
                        attributes.addAttribute(null, "width", null, null, String.valueOf(dimension.width));
                        attributes.addAttribute(null, "height", null, null, String.valueOf(dimension.height));
                        writer.dataElement("size", attributes);
                    }
                    writer.endElement("floating");
                } else {
                    writer.dataElement("floating", floatingDescriptorAttributes);
                }
                FloatingLiveTypeDescriptor floatingLiveTypeDescriptor = (FloatingLiveTypeDescriptor)toolWindow.getTypeDescriptor(ToolWindowType.FLOATING_LIVE);
                AttributesImpl floatingLiveDescriptorAttributes = new AttributesImpl();
                floatingLiveDescriptorAttributes.addAttribute(null, "transparentMode", null, null, String.valueOf(floatingLiveTypeDescriptor.isTransparentMode()));
                floatingLiveDescriptorAttributes.addAttribute(null, "transparentDelay", null, null, String.valueOf(floatingLiveTypeDescriptor.getTransparentDelay()));
                floatingLiveDescriptorAttributes.addAttribute(null, "transparentRatio", null, null, String.valueOf(floatingLiveTypeDescriptor.getTransparentRatio()));
                floatingLiveDescriptorAttributes.addAttribute(null, "enabled", null, null, String.valueOf(floatingLiveTypeDescriptor.isEnabled()));
                floatingLiveDescriptorAttributes.addAttribute(null, "animating", null, null, String.valueOf(floatingLiveTypeDescriptor.isAnimating()));
                floatingLiveDescriptorAttributes.addAttribute(null, "idVisibleOnTitleBar", null, null, String.valueOf(floatingLiveTypeDescriptor.isIdVisibleOnTitleBar()));
                floatingLiveDescriptorAttributes.addAttribute(null, "autoHide", null, null, String.valueOf(floatingLiveTypeDescriptor.isAutoHide()));
                point = floatingLiveTypeDescriptor.getLocation();
                dimension = floatingLiveTypeDescriptor.getSize();
                if (point != null || dimension != null) {
                    AttributesImpl attributes;
                    writer.startElement("floatingLive", floatingDescriptorAttributes);
                    if (point != null) {
                        attributes = new AttributesImpl();
                        attributes.addAttribute(null, "x", null, null, String.valueOf(point.x));
                        attributes.addAttribute(null, "y", null, null, String.valueOf(point.y));
                        writer.dataElement("location", attributes);
                    }
                    if (dimension != null) {
                        attributes = new AttributesImpl();
                        attributes.addAttribute(null, "width", null, null, String.valueOf(dimension.width));
                        attributes.addAttribute(null, "height", null, null, String.valueOf(dimension.height));
                        writer.dataElement("size", attributes);
                    }
                    writer.endElement("floatingLive");
                } else {
                    writer.dataElement("floatingLive", floatingLiveDescriptorAttributes);
                }
                writer.endElement("descriptors");
                boolean addTabsTag = false;
                for (ToolWindowTab tab : toolWindow.getToolWindowTabs()) {
                    if (tab.getDockableDelegator() == null) continue;
                    Dockable dockable = tab.getDockableDelegator();
                    if (!addTabsTag) {
                        addTabsTag = true;
                        writer.startElement("tabs");
                    }
                    AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute(null, "dockableId", null, null, dockable.getId());
                    attributes.addAttribute(null, "selected", null, null, String.valueOf(tab.isSelected()));
                    attributes.addAttribute(null, "maximized", null, null, String.valueOf(tab.isMaximized()));
                    attributes.addAttribute(null, "minimized", null, null, String.valueOf(tab.isMinimized()));
                    attributes.addAttribute(null, "closeable", null, null, String.valueOf(tab.isCloseable()));
                    attributes.addAttribute(null, "detached", null, null, String.valueOf(tab.isDetached()));
                    attributes.addAttribute(null, "flashing", null, null, String.valueOf(tab.isFlashing()));
                    writer.dataElement("tab", attributes);
                }
                if (addTabsTag) {
                    writer.endElement("tabs");
                }
                writer.endElement("toolWindow");
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ToolWindowManagerElementWriter
    implements ElementWriter<XMLWriter> {
        protected ToolWindowManager manager;
        protected Map<Class, ElementWriter<XMLWriter>> elementWriterMap;

        public ToolWindowManagerElementWriter(ToolWindowManager manager) {
            this.manager = manager;
            this.elementWriterMap = new HashMap<Class, ElementWriter<XMLWriter>>();
            this.populateWriterMap();
        }

        @Override
        public void write(XMLWriter writer, Context params) {
            try {
                DefaultMutableContext context = new DefaultMutableContext();
                context.put(ToolWindowManager.class, this.manager);
                writer.startDocument();
                AttributesImpl mydoggyAttributes = new AttributesImpl();
                mydoggyAttributes.addAttribute(null, "version", null, null, "1.4.2");
                mydoggyAttributes.addAttribute(null, "contentManagerEnabled", null, null, String.valueOf(this.manager.getContentManager().isEnabled()));
                writer.startElement("mydoggy", mydoggyAttributes);
                writer.startElement("toolWindows");
                for (ToolWindow toolWindow : this.manager.getToolWindows()) {
                    context.put(ToolWindow.class, toolWindow);
                    this.getElementWriter(ToolWindow.class).write(writer, context);
                }
                writer.endElement("toolWindows");
                context.put(ToolWindowManagerDescriptor.class, this.manager.getToolWindowManagerDescriptor());
                this.getElementWriter(ToolWindowManagerDescriptor.class).write(writer, context);
                context.put(ContentManager.class, this.manager.getContentManager());
                context.put(ContentManagerUI.class, this.manager.getContentManager().getContentManagerUI());
                ContentManager contentManager = this.manager.getContentManager();
                writer.startElement("contentManagerUI");
                this.getElementWriter(contentManager.getContentManagerUI().getClass()).write(writer, context);
                writer.endElement("contentManagerUI");
                this.getElementWriter(ContentManager.class).write(writer, context);
                this.getElementWriter(ToolWindowAnchor.class).write(writer, context);
                writer.endElement("mydoggy");
                writer.endDocument();
                writer.flush();
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected ElementWriter<XMLWriter> getElementWriter(Class clazz) {
            ElementWriter<XMLWriter> elementWriter = this.elementWriterMap.get(clazz);
            if (elementWriter == null) {
                while (clazz != null) {
                    elementWriter = this.elementWriterMap.get(clazz.getSuperclass());
                    if (elementWriter != null) {
                        return elementWriter;
                    }
                    for (Class<?> interfaceClazz : clazz.getInterfaces()) {
                        elementWriter = this.elementWriterMap.get(interfaceClazz);
                        if (elementWriter == null) continue;
                        return elementWriter;
                    }
                    clazz = clazz.getSuperclass();
                }
            }
            return elementWriter;
        }

        protected void populateWriterMap() {
            this.elementWriterMap.put(ToolWindow.class, new ToolWindowEntityWriter());
            this.elementWriterMap.put(ToolWindowManagerDescriptor.class, new ToolWindowManagerDescriptorEntityWriter());
            this.elementWriterMap.put(ContentManager.class, new ContentManagerEntityWriter());
            this.elementWriterMap.put(TabbedContentManagerUI.class, new TabbedContentManagerUIEntityPWriter());
            this.elementWriterMap.put(MultiSplitContentManagerUI.class, new MultiSplitContentManagerUIEntityPWriter());
            this.elementWriterMap.put(DesktopContentManagerUI.class, new DesktopContentManagerUIEntityWriter());
            this.elementWriterMap.put(ToolWindowAnchor.class, new ToolWindowAnchorEntityWriter());
        }
    }
}

