/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.noos.common.context.MutableContext;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentManagerListener;
import org.noos.xing.mydoggy.ContentManagerUI;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.DockableManagerListener;
import org.noos.xing.mydoggy.PersistenceDelegate;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowBar;
import org.noos.xing.mydoggy.ToolWindowGroup;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.ToolWindowManagerDescriptor;
import org.noos.xing.mydoggy.ToolWindowManagerListener;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.ToolWindowTypeDescriptor;
import org.noos.xing.mydoggy.event.ContentManagerEvent;
import org.noos.xing.mydoggy.event.ToolWindowManagerEvent;
import org.noos.xing.mydoggy.plaf.MyDoggyContent;
import org.noos.xing.mydoggy.plaf.MyDoggyContentManager;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindow;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowBar;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowGroup;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManagerDescriptor;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowTab;
import org.noos.xing.mydoggy.plaf.common.context.DefaultMutableContext;
import org.noos.xing.mydoggy.plaf.descriptors.DefaultDockedTypeDescriptor;
import org.noos.xing.mydoggy.plaf.descriptors.DefaultFloatingLiveTypeDescriptor;
import org.noos.xing.mydoggy.plaf.descriptors.DefaultFloatingTypeDescriptor;
import org.noos.xing.mydoggy.plaf.descriptors.DefaultSlidingTypeDescriptor;
import org.noos.xing.mydoggy.plaf.persistence.xml.XMLPersistenceDelegate;
import org.noos.xing.mydoggy.plaf.support.CleanablePropertyChangeSupport;
import org.noos.xing.mydoggy.plaf.support.ResolvableHashtable;
import org.noos.xing.mydoggy.plaf.support.UserPropertyChangeEvent;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.GlassPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitDockableContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.ShortcutProcessor;
import org.noos.xing.mydoggy.plaf.ui.content.ContentDescriptor;
import org.noos.xing.mydoggy.plaf.ui.content.MyDoggyTabbedContentManagerUI;
import org.noos.xing.mydoggy.plaf.ui.drag.ContentManagerDropTarget;
import org.noos.xing.mydoggy.plaf.ui.drag.ToolWindowCommonMultiSplitDropTarget;
import org.noos.xing.mydoggy.plaf.ui.look.MyDoggyResourceManager;
import org.noos.xing.mydoggy.plaf.ui.util.DockableManager2ToolWindowManagerWrapper;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class MyDoggyToolWindowManager
extends JPanel
implements ToolWindowManager,
PropertyChangeListener {
    protected static boolean firePublic = true;
    public static final Object sync = new Object();
    protected ToolWindowGroup showingGroup;
    protected MyDoggyContentManager contentManager;
    protected Component windowAnchestor;
    protected RootPaneContainer rootPaneContainer;
    protected MyDoggyToolWindowBar[] bars;
    protected Map<Object, ToolWindowDescriptor> tools;
    protected Map<Object, ToolWindowGroup> toolWindowGroups;
    protected Map<Object, ToolWindow> aliases;
    protected Map<String, DockableDescriptor> dockableDescriptorMap;
    protected ToolWindowGroup allToolWindowGroup;
    protected TableLayout contentPaneLayout;
    protected JSplitPane mainSplitPane;
    protected JPanel mainContainer;
    protected MultiSplitDockableContainer toolDockableContainer;
    protected CleanablePropertyChangeSupport propertyChangeSupport;
    protected Object activeToolWindowId;
    protected GlassPanel glassPanel;
    protected Component lastFocusOwner = null;
    protected PersistenceDelegate persistenceDelegate;
    protected DefaultFloatingTypeDescriptor floatingTypeDescriptor;
    protected DefaultDockedTypeDescriptor dockingTypeDescriptor;
    protected DefaultSlidingTypeDescriptor slidingTypeDescriptor;
    protected DefaultFloatingLiveTypeDescriptor floatingLiveTypeDescriptor;
    protected ToolWindowManagerDescriptor toolWindowManagerDescriptor;
    protected EventListenerList twmListeners;
    protected ClassLoader uiClassLoader;
    protected ResourceManagerListener resourceManagerListener;
    protected transient ResourceManager resourceManager;
    protected Component oldMainContent = null;
    protected boolean dockableMainContentMode = false;

    public MyDoggyToolWindowManager() {
        this(Locale.getDefault(), null);
    }

    public MyDoggyToolWindowManager(Locale locale, ClassLoader uiClassLoader) {
        this.uiClassLoader = uiClassLoader;
        this.allToolWindowGroup = new AllToolWindowGroup();
        this.aliases = new HashMap<Object, ToolWindow>();
        this.dockableDescriptorMap = new HashMap<String, DockableDescriptor>();
        this.propertyChangeSupport = new CleanablePropertyChangeSupport(this);
        this.toolWindowManagerDescriptor = new MyDoggyToolWindowManagerDescriptor(this);
        this.toolWindowManagerDescriptor.addPropertyChangeListener((PropertyChangeListener)this);
        this.initUI(locale);
        this.initPersistenceDelegate();
        this.initComponents();
        this.initListeners();
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    public ToolWindowManagerDescriptor getToolWindowManagerDescriptor() {
        return this.toolWindowManagerDescriptor;
    }

    public PersistenceDelegate getPersistenceDelegate() {
        return this.persistenceDelegate;
    }

    public ToolWindow registerToolWindow(String id, String title, Icon icon, Component component, ToolWindowAnchor anchor) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot register tool window with an invalid id. Id cannot be null.");
        }
        if (component == null) {
            throw new IllegalArgumentException("Cannot register tool window with a null component. [id : " + id + "]");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Cannot register tool window with a null anchor. [id : " + id + "]");
        }
        int index = this.tools.size() + 1;
        if (index > 9) {
            index = -1;
        }
        if (this.getDockable(id) != null) {
            throw new IllegalArgumentException("Cannot register tool window with passed id. An already registered dockable exists. [id : " + id + "]");
        }
        MyDoggyToolWindow toolWindow = new MyDoggyToolWindow(this, id, index, anchor, ToolWindowType.DOCKED, title, icon, component, null);
        toolWindow.addPlafPropertyChangeListener(this);
        this.tools.put(toolWindow.getId(), toolWindow.getDescriptor());
        this.fireRegisteredToolEvent(toolWindow);
        return toolWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterToolWindow(String id) {
        ToolWindowDescriptor toolWindowDescriptor = this.tools.get(id);
        if (toolWindowDescriptor != null) {
            try {
                MyDoggyToolWindow toolWindow = toolWindowDescriptor.getToolWindow();
                this.removeIfDockableDelegator((Dockable)toolWindow);
                toolWindow.setFlashing(false);
                toolWindow.setMaximized(false);
                toolWindow.setAvailable(false);
                for (ToolWindowTab toolWindowTab : toolWindowDescriptor.getToolWindow().getToolWindowTabs()) {
                    toolWindow.removeToolWindowTab(toolWindowTab);
                }
                this.tools.remove(toolWindowDescriptor.getToolWindow().getId());
                Iterator<ToolWindow> iterator = this.aliases.values().iterator();
                while (iterator.hasNext()) {
                    ToolWindow aliasedToolWindow = iterator.next();
                    if (aliasedToolWindow != toolWindow) continue;
                    iterator.remove();
                }
                this.fireUnregisteredToolEvent(toolWindowDescriptor.getToolWindow());
            }
            finally {
                toolWindowDescriptor.cleanup();
            }
        } else {
            throw new IllegalArgumentException("Doesn't exist a tool window with passed id. [id : " + id + "]");
        }
    }

    public void unregisterAllToolWindow() {
        for (ToolWindow toolWindow : this.getToolWindows()) {
            this.unregisterToolWindow(toolWindow.getId());
        }
        this.aliases.clear();
    }

    public void addAlias(ToolWindow toolWindow, Object alias) {
        if (this.tools.containsKey(alias)) {
            throw new IllegalArgumentException("There is a tool whose id is the passed alias. Cannot add that alias.");
        }
        this.aliases.put(alias, toolWindow);
    }

    public Object[] getAliases(ToolWindow toolWindow) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<Object, ToolWindow> entry : this.aliases.entrySet()) {
            if (entry.getValue() != toolWindow) continue;
            result.add(entry.getKey());
        }
        return result.toArray();
    }

    public ToolWindow getToolWindowByAlias(Object alias) {
        return this.aliases.get(alias);
    }

    public ToolWindow[] getToolWindows() {
        ArrayList<MyDoggyToolWindow> result = new ArrayList<MyDoggyToolWindow>();
        for (ToolWindowDescriptor tool : this.tools.values()) {
            result.add(tool.getToolWindow());
        }
        return result.toArray(new ToolWindow[result.size()]);
    }

    public Object getActiveToolWindowId() {
        return this.activeToolWindowId;
    }

    public ToolWindow getToolWindow(Object key) {
        if (key == null) {
            return null;
        }
        ToolWindowDescriptor descriptor = this.tools.get(key);
        if (descriptor == null) {
            return this.aliases.get(key);
        }
        return descriptor.getToolWindow();
    }

    public ToolWindow getToolWindow(int index) {
        if (index != -1 && index <= 0 && index > 9) {
            throw new IllegalArgumentException("Invalid index. Valid index range is [-1, 1-9]. [index : " + index + "]");
        }
        for (ToolWindow toolWindow : this.getToolWindows()) {
            if (toolWindow.getIndex() != index) continue;
            return toolWindow;
        }
        return null;
    }

    public ToolWindow[] getToolsByAnchor(ToolWindowAnchor anchor) {
        ArrayList<MyDoggyToolWindow> result = new ArrayList<MyDoggyToolWindow>();
        for (ToolWindowDescriptor tool : this.tools.values()) {
            if (!tool.getToolWindow().getAnchor().equals((Object)anchor)) continue;
            result.add(tool.getToolWindow());
        }
        return result.toArray(new ToolWindow[result.size()]);
    }

    public ToolWindowGroup getToolWindowGroup() {
        return this.allToolWindowGroup;
    }

    public ToolWindowGroup getToolWindowGroup(String name) {
        return this.toolWindowGroups.get(name);
    }

    public ToolWindowGroup[] getToolWindowGroups() {
        Collection<ToolWindowGroup> c = this.toolWindowGroups.values();
        return c.toArray(new ToolWindowGroup[c.size()]);
    }

    public boolean removeToolWindowGroup(String name) {
        if (name == null) {
            return false;
        }
        ToolWindowGroup group = this.toolWindowGroups.remove(name);
        if (group != null) {
            this.fireRemovedGroupEvent(group);
            return true;
        }
        return false;
    }

    public boolean removeToolWindowGroup(ToolWindowGroup toolWindowGroup) {
        return toolWindowGroup != null && this.removeToolWindowGroup(toolWindowGroup.getName());
    }

    public boolean containsGroup(String name) {
        return this.allToolWindowGroup.getName().equals(name) || this.toolWindowGroups.containsKey(name);
    }

    public ToolWindowTypeDescriptor getTypeDescriptorTemplate(ToolWindowType type) {
        switch (type) {
            case FLOATING: 
            case FLOATING_FREE: {
                if (this.floatingTypeDescriptor == null) {
                    this.floatingTypeDescriptor = new DefaultFloatingTypeDescriptor();
                }
                return this.floatingTypeDescriptor;
            }
            case FLOATING_LIVE: {
                if (this.floatingLiveTypeDescriptor == null) {
                    this.floatingLiveTypeDescriptor = new DefaultFloatingLiveTypeDescriptor();
                }
                return this.floatingLiveTypeDescriptor;
            }
            case DOCKED: {
                if (this.dockingTypeDescriptor == null) {
                    this.dockingTypeDescriptor = new DefaultDockedTypeDescriptor(this.resourceManager);
                }
                return this.dockingTypeDescriptor;
            }
            case SLIDING: {
                if (this.slidingTypeDescriptor == null) {
                    this.slidingTypeDescriptor = new DefaultSlidingTypeDescriptor();
                }
                return this.slidingTypeDescriptor;
            }
        }
        throw new IllegalStateException("Doen't exist a TypeDescriptor for. [type :" + type + "]");
    }

    public Dockable getDockable(Object id) {
        ToolWindow result = this.getToolWindow(id);
        if (result == null) {
            for (ToolWindow toolWindow : this.getToolWindows()) {
                for (ToolWindowTab tab : toolWindow.getToolWindowTabs()) {
                    if (!tab.getId().equals(id)) continue;
                    result = tab;
                    break;
                }
                if (result != null) break;
            }
            if (result == null) {
                result = this.getContentManager().getContent(id);
            }
        }
        return result;
    }

    public ToolWindowBar getToolWindowBar(ToolWindowAnchor anchor) {
        return this.getBar(anchor);
    }

    public void addToolWindowManagerListener(ToolWindowManagerListener listener) {
        this.twmListeners.add(ToolWindowManagerListener.class, listener);
    }

    public void removeToolWindowManagerListener(ToolWindowManagerListener listener) {
        this.twmListeners.remove(ToolWindowManagerListener.class, listener);
    }

    public ToolWindowManagerListener[] getToolWindowManagerListeners() {
        return (ToolWindowManagerListener[])this.twmListeners.getListeners(ToolWindowManagerListener.class);
    }

    public void addDockableManagerListener(DockableManagerListener listener) {
        this.addToolWindowManagerListener(new DockableManager2ToolWindowManagerWrapper(listener));
    }

    public void removeDockableManagerListener(DockableManagerListener listener) {
        for (ToolWindowManagerListener managerListener : this.getToolWindowManagerListeners()) {
            if (!(managerListener instanceof DockableManager2ToolWindowManagerWrapper) || ((DockableManager2ToolWindowManagerWrapper)managerListener).getListener() != listener) continue;
            this.removeToolWindowManagerListener(managerListener);
        }
    }

    public DockableManagerListener[] getDockableManagerListeners() {
        ArrayList<DockableManagerListener> listeners = new ArrayList<DockableManagerListener>();
        for (ToolWindowManagerListener managerListener : this.getToolWindowManagerListeners()) {
            if (!(managerListener instanceof DockableManager2ToolWindowManagerWrapper)) continue;
            listeners.add(((DockableManager2ToolWindowManagerWrapper)managerListener).getListener());
        }
        return listeners.toArray(new DockableManagerListener[listeners.size()]);
    }

    public synchronized void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (source instanceof DockableDescriptor) {
            DockableDescriptor descriptor = (DockableDescriptor)source;
            if (descriptor.getDockableType() != DockableDescriptor.DockableType.CUSTOM && this.getDockable(descriptor.getDockable().getId()) != descriptor.getDockable()) {
                throw new RuntimeException("Manager doesn't contain that ToolWindow. [id : " + descriptor.getDockable().getId() + "]");
            }
        } else if (!(source instanceof MyDoggyToolWindowBar || source instanceof MyDoggyToolWindowManagerDescriptor || source instanceof MyDoggyToolWindowManager || source instanceof MyDoggyToolWindowTab || source instanceof ToolWindowTypeDescriptor || source instanceof ContentManager)) {
            throw new RuntimeException("Illegal Source : " + source);
        }
        boolean fired = this.propertyChangeSupport.firePropertyChange(evt);
    }

    public void removeNotify() {
        super.removeNotify();
        for (ToolWindow toolWindow : this.getToolWindows()) {
            if (toolWindow.getType() != ToolWindowType.FLOATING || !toolWindow.isVisible()) continue;
            toolWindow.setVisible(false);
        }
        for (ToolWindow toolWindow : this.getContentManager().getContents()) {
            toolWindow.setDetached(false);
        }
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "manager.window.anchestor", this.windowAnchestor, null));
    }

    public void addNotify() {
        super.addNotify();
        this.windowAnchestor = SwingUtil.getWindowAncestor(this);
        if (!(this.windowAnchestor instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("WindowAnchestor must implement RootPaneContainer");
        }
        this.rootPaneContainer = (RootPaneContainer)((Object)this.windowAnchestor);
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "manager.window.anchestor", null, this.windowAnchestor));
    }

    public Component getWindowAnchestor() {
        return this.windowAnchestor;
    }

    public JLayeredPane getLayeredPane() {
        return this.rootPaneContainer != null ? this.rootPaneContainer.getLayeredPane() : null;
    }

    public RootPaneContainer getRootPaneContainer() {
        return this.rootPaneContainer;
    }

    public void setPersistenceDelegate(PersistenceDelegate persistenceDelegate) {
        this.persistenceDelegate = persistenceDelegate;
    }

    public void setUserResourceBundle(Locale locale, String bundle, ClassLoader classLoader) {
        this.resourceManager.setUserBundle(locale, bundle, classLoader);
    }

    public void setMainSplitPane(ToolWindowAnchor anchor) {
        switch (anchor) {
            case LEFT: {
                this.mainSplitPane = this.getBar(anchor).getSplitPane();
                this.mainSplitPane.setRightComponent(this.mainContainer);
                break;
            }
            case RIGHT: {
                this.mainSplitPane = this.getBar(anchor).getSplitPane();
                this.mainSplitPane.setLeftComponent(this.mainContainer);
                break;
            }
            case TOP: {
                this.mainSplitPane = this.getBar(anchor).getSplitPane();
                this.mainSplitPane.setBottomComponent(this.mainContainer);
                break;
            }
            case BOTTOM: {
                this.mainSplitPane = this.getBar(anchor).getSplitPane();
                this.mainSplitPane.setTopComponent(this.mainContainer);
            }
        }
    }

    public MyDoggyToolWindowBar getBar(ToolWindowAnchor anchor) {
        return this.bars[anchor.ordinal()];
    }

    public ToolWindowGroup getShowingGroup() {
        return this.showingGroup;
    }

    public ToolWindowDescriptor getDescriptor(ToolWindow toolWindow) {
        return this.tools.get(toolWindow.getId());
    }

    public void setCornerComponent(ToolWindowManagerDescriptor.Corner corner, Component component) {
        switch (corner) {
            case NORD_WEST: {
                for (Component cmp : this.getComponents()) {
                    if (this.contentPaneLayout.getConstraints((Component)cmp).row1 != 0 || this.contentPaneLayout.getConstraints((Component)cmp).col1 != 0) continue;
                    this.remove(cmp);
                }
                this.add(component, "0,0,c,c");
                break;
            }
            case SOUTH_WEST: {
                for (Component cmp : this.getComponents()) {
                    if (this.contentPaneLayout.getConstraints((Component)cmp).row1 != 2 || this.contentPaneLayout.getConstraints((Component)cmp).col1 != 0) continue;
                    this.remove(cmp);
                }
                this.add(component, "0,2,c,c");
                break;
            }
            case NORD_EAST: {
                for (Component cmp : this.getComponents()) {
                    if (this.contentPaneLayout.getConstraints((Component)cmp).row1 != 0 || this.contentPaneLayout.getConstraints((Component)cmp).col1 != 2) continue;
                    this.remove(cmp);
                }
                this.add(component, "2,0,c,c");
                break;
            }
            case SOUTH_EAST: {
                for (Component cmp : this.getComponents()) {
                    if (this.contentPaneLayout.getConstraints((Component)cmp).row1 != 2 || this.contentPaneLayout.getConstraints((Component)cmp).col1 != 2) continue;
                    this.remove(cmp);
                }
                this.add(component, "2,2,c,c");
            }
        }
    }

    public GlassPanel getGlassPanel() {
        return this.glassPanel;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        if (this.resourceManager != null) {
            this.resourceManager.removePropertyChangeListener(this.resourceManagerListener);
        }
        if (this.resourceManagerListener == null) {
            this.resourceManagerListener = new ResourceManagerListener();
        }
        this.resourceManager = resourceManager;
        resourceManager.addPropertyChangeListener(this.resourceManagerListener);
        this.propertyChange(new PropertyChangeEvent(this, "resourceManager", null, resourceManager));
    }

    public ToolWindowAnchor getToolWindowAnchor(Point p) {
        Rectangle b = this.getBounds();
        int leftLength = this.getBar(ToolWindowAnchor.LEFT).getLength();
        int rightLength = this.getBar(ToolWindowAnchor.RIGHT).getLength();
        int topLength = this.getBar(ToolWindowAnchor.TOP).getLength();
        int bottomLength = this.getBar(ToolWindowAnchor.BOTTOM).getLength();
        if (p.x <= leftLength && p.y >= topLength && p.y <= b.height - bottomLength) {
            return ToolWindowAnchor.LEFT;
        }
        if (p.x >= b.width - rightLength && p.y >= topLength && p.y <= b.height - bottomLength) {
            return ToolWindowAnchor.RIGHT;
        }
        if (p.y <= topLength && p.x >= leftLength && p.x <= b.width - rightLength) {
            return ToolWindowAnchor.TOP;
        }
        if (p.y >= b.height - bottomLength && p.x >= leftLength && p.x <= b.width - rightLength) {
            return ToolWindowAnchor.BOTTOM;
        }
        return null;
    }

    public void removeIfDockableDelegator(Dockable dockable) {
        block0: for (ToolWindow toolWindow : this.getToolWindows()) {
            for (ToolWindowTab tab : toolWindow.getToolWindowTabs()) {
                if (tab.getDockableDelegator() != dockable) continue;
                toolWindow.removeToolWindowTab(tab);
                continue block0;
            }
        }
        for (ToolWindow toolWindow : this.contentManager.getContents()) {
            if (toolWindow.getDockableDelegator() != dockable) continue;
            this.contentManager.removeContent((Content)toolWindow);
            break;
        }
    }

    public void addInternalPropertyChangeListener(String property, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(property, listener);
    }

    public void setMainContent(Component content) {
        if (content == null) {
            this.resetMainContent();
        } else if (this.dockableMainContentMode) {
            this.oldMainContent = content;
        } else {
            this.mainContainer.setOpaque(false);
            this.mainContainer.removeAll();
            this.mainContainer.add(content, "0,0,FULL,FULL");
            this.mainSplitPane.invalidate();
            this.mainSplitPane.validate();
            SwingUtil.repaint(this.mainSplitPane);
        }
    }

    public void resetMainContent() {
        if (this.dockableMainContentMode) {
            this.oldMainContent = null;
        } else {
            this.mainContainer.removeAll();
            SwingUtil.repaint(this.mainSplitPane);
            this.mainContainer.setOpaque(true);
        }
    }

    public Container getMainContainer() {
        return this.mainContainer;
    }

    public Component getMainContent() {
        return this.mainContainer.getComponentCount() == 0 ? null : this.mainContainer.getComponent(0);
    }

    public void setDockableMainContentMode(boolean enable) {
        if (enable) {
            this.toolDockableContainer = new MultiSplitDockableContainer(this, 0);
            this.toolDockableContainer.setStoreLayout(false);
            ContentPanel contentPanel = new ContentPanel("toolWindow.container.");
            contentPanel.setDropTarget(new ToolWindowCommonMultiSplitDropTarget(contentPanel, this));
            contentPanel.setComponent(this.toolDockableContainer);
            this.oldMainContent = this.getMainContent();
            this.setMainContent(contentPanel);
            this.dockableMainContentMode = true;
        } else {
            this.dockableMainContentMode = false;
            this.setMainContent(this.oldMainContent);
        }
    }

    public Rectangle getBoundsToScreen(Rectangle bounds, Component ref) {
        Point location = bounds.getLocation();
        SwingUtilities.convertPointToScreen(location, ref);
        bounds.setLocation(location);
        bounds.y += this.getJMenuBarExtraHeight();
        return bounds;
    }

    protected void initPersistenceDelegate() {
        this.persistenceDelegate = new XMLPersistenceDelegate(this);
    }

    protected void initComponents() {
        this.twmListeners = new EventListenerList();
        this.initContentManager();
        this.resourceManager.applyCustomization("TOOL_WINDOW_MANAGER", this, this.getContext());
        this.bars = new MyDoggyToolWindowBar[4];
        this.tools = new LinkedHashMap<Object, ToolWindowDescriptor>();
        this.toolWindowGroups = new ResolvableHashtable<Object, ToolWindowGroup>(new ResolvableHashtable.Resolver<ToolWindowGroup>(){

            @Override
            public ToolWindowGroup get(Object key) {
                MyDoggyToolWindowGroup group = new MyDoggyToolWindowGroup(MyDoggyToolWindowManager.this, key.toString(), false);
                MyDoggyToolWindowManager.this.toolWindowGroups.put(key, group);
                MyDoggyToolWindowManager.this.fireAddedGroupEvent(group);
                return group;
            }
        });
        this.contentPaneLayout = new ExtendedTableLayout(new double[][]{{0.0, -1.0, 0.0}, {0.0, -1.0, 0.0}});
        this.setLayout((LayoutManager)this.contentPaneLayout);
        this.addBar(ToolWindowAnchor.LEFT, 1, "0,1", "0,0,FULL,FULL");
        this.addBar(ToolWindowAnchor.RIGHT, 1, "2,1", "2,0,FULL,FULL");
        this.addBar(ToolWindowAnchor.TOP, 0, "1,0", "2,2,FULL,FULL");
        this.addBar(ToolWindowAnchor.BOTTOM, 0, "1,2", "0,2,FULL,FULL");
        this.mainContainer = (JPanel)this.resourceManager.createComponent("TOOL_WINDOW_MANAGER_CONTENT_CONTAINER", this.getContext());
        this.mainContainer.setName("toolWindowManager.mainContainer");
        this.mainContainer.setLayout((LayoutManager)((Object)new ExtendedTableLayout(new double[][]{{-1.0}, {-1.0}})));
        this.mainContainer.setFocusCycleRoot(true);
        this.getBar(ToolWindowAnchor.BOTTOM).getSplitPane().setTopComponent(this.getBar(ToolWindowAnchor.TOP).getSplitPane());
        this.getBar(ToolWindowAnchor.TOP).getSplitPane().setBottomComponent(this.getBar(ToolWindowAnchor.LEFT).getSplitPane());
        this.getBar(ToolWindowAnchor.LEFT).getSplitPane().setRightComponent(this.getBar(ToolWindowAnchor.RIGHT).getSplitPane());
        this.getBar(ToolWindowAnchor.RIGHT).getSplitPane().setResizeWeight(1.0);
        this.add((Component)this.getBar(ToolWindowAnchor.BOTTOM).getSplitPane(), "1,1,FULL,FULL");
        this.mainSplitPane = this.getBar(ToolWindowAnchor.RIGHT).getSplitPane();
        this.mainSplitPane.addPropertyChangeListener("UI", new UpdateUIChangeListener());
        this.mainSplitPane.setLeftComponent(this.mainContainer);
    }

    protected void initContentManager() {
        this.contentManager = new MyDoggyContentManager(this);
        this.contentManager.setContentManagerUI((ContentManagerUI)new MyDoggyTabbedContentManagerUI());
        this.contentManager.addPropertyChangeListener(this);
        this.contentManager.addContentManagerListener(new InternalContentMananagerListener());
    }

    protected void initGlassPane() {
        this.glassPanel = new GlassPanel(this.resourceManager, this.rootPaneContainer);
    }

    protected void initListeners() {
        AvailablePropertyChangeListener availablePropertyChangeListener = new AvailablePropertyChangeListener();
        this.propertyChangeSupport.addPropertyChangeListener("available", availablePropertyChangeListener);
        this.propertyChangeSupport.addPropertyChangeListener("representativeAnchorButtonVisible", availablePropertyChangeListener);
        this.propertyChangeSupport.addPropertyChangeListener("showUnavailableTools", new ShowUnavailableToolsPropertyChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible", new VisiblePropertyChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("active", new ActivePropertyChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("anchor", new AnchorPropertyChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("type", new TypePropertyChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("autoHide", new AutoHideChangeListener());
        MaximizedChangeListener maximizedChangeListener = new MaximizedChangeListener();
        this.propertyChangeSupport.addPropertyChangeListener("maximized", maximizedChangeListener);
        this.propertyChangeSupport.addPropertyChangeListener("maximized.before", maximizedChangeListener);
        this.propertyChangeSupport.addPropertyChangeListener("index", new IndexChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("icon", new IconChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("numberingEnabled", new NumberingEnabledChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("tempShowed", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                for (ToolWindowDescriptor tool : MyDoggyToolWindowManager.this.tools.values()) {
                    tool.getToolWindowContainer().propertyChange(evt);
                }
            }
        });
        this.propertyChangeSupport.addPropertyChangeListener("anchor.index", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ToolWindowDescriptor descriptor = (ToolWindowDescriptor)evt.getSource();
                if (descriptor.getToolWindow().getType() == ToolWindowType.DOCKED) {
                    MyDoggyToolWindowManager.this.getBar(descriptor.getToolWindow().getAnchor()).propertyChange(evt);
                }
            }
        });
        this.propertyChangeSupport.addPropertyChangeListener("manager.window.anchestor", new AnchestorClosedChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("resourceManager", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MyDoggyToolWindowManager.this.glassPanel.setResourceManager((ResourceManager)evt.getNewValue());
            }
        });
        this.propertyChangeSupport.addPropertyChangeListener("enabled", new ContentMananagerEnabledChangeListener());
        this.propertyChangeSupport.addPropertyChangeListener("length", new BarLengthListener());
        this.initKeyboardFocusManagerListeners();
        this.mainContainer.setDropTarget(new ContentManagerDropTarget(this.mainContainer, this, this.resourceManager));
    }

    protected void initKeyboardFocusManagerListeners() {
        this.propertyChangeSupport.addPropertyChangeListener("manager.window.anchestor", new PropertyChangeListener(){
            final ShortcutProcessor shortcutProcessor;
            final FocusOwnerChangeListener focusOwnerChangeListener;
            {
                this.shortcutProcessor = new ShortcutProcessor(MyDoggyToolWindowManager.this, MyDoggyToolWindowManager.this);
                this.focusOwnerChangeListener = new FocusOwnerChangeListener();
            }

            public void propertyChange(PropertyChangeEvent evt) {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                if (evt.getNewValue() != null) {
                    keyboardFocusManager.addKeyEventPostProcessor(this.shortcutProcessor);
                    keyboardFocusManager.addPropertyChangeListener("focusOwner", this.focusOwnerChangeListener);
                    MyDoggyToolWindowManager.this.initGlassPane();
                } else {
                    keyboardFocusManager.removeKeyEventPostProcessor(this.shortcutProcessor);
                    for (PropertyChangeListener listener : keyboardFocusManager.getPropertyChangeListeners("focusOwner")) {
                        if (!listener.getClass().getPackage().getName().startsWith(MyDoggyToolWindowManager.this.getClass().getPackage().getName())) continue;
                        keyboardFocusManager.removePropertyChangeListener("focusOwner", listener);
                    }
                }
            }
        });
    }

    protected void initUI(Locale locale) {
        Properties properties = SwingUtil.loadPropertiesFile("mydoggyplaf.properties", this.uiClassLoader);
        String className = properties.getProperty("ResourceManager.class");
        if (className == null) {
            System.err.println("Cannot find ResourceManager.class property value. Use default.");
            className = MyDoggyResourceManager.class.getName();
        }
        try {
            this.setResourceManager((ResourceManager)SwingUtil.newObject(className));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setResourceManager(new MyDoggyResourceManager());
        }
        this.resourceManager.setLocale(locale);
    }

    protected JSplitPane renderSplitPane(int orientation) {
        return (JSplitPane)this.resourceManager.createComponent("ANCHOR_SPLIT_PANE", this.getContext("newOrientation", orientation));
    }

    protected JSplitPane addBar(ToolWindowAnchor anchor, int splitPaneOrientation, String barConstraints, String cornerConstraints) {
        MyDoggyToolWindowBar myDoggyToolWindowBar = new MyDoggyToolWindowBar(this, this.renderSplitPane(splitPaneOrientation), anchor);
        myDoggyToolWindowBar.addPropertyChangeListener(this);
        this.bars[anchor.ordinal()] = myDoggyToolWindowBar;
        this.add((Component)myDoggyToolWindowBar.getContainer(), barConstraints);
        this.add(this.resourceManager.createComponent("CORNER_CONTENT_PANE", this.getContext()), cornerConstraints);
        return myDoggyToolWindowBar.getSplitPane();
    }

    protected void fireRegisteredToolEvent(ToolWindow toolWindow) {
        ToolWindowManagerEvent event = new ToolWindowManagerEvent((ToolWindowManager)this, ToolWindowManagerEvent.ActionId.TOOL_REGISTERED, toolWindow);
        for (ToolWindowManagerListener listener : (ToolWindowManagerListener[])this.twmListeners.getListeners(ToolWindowManagerListener.class)) {
            listener.toolWindowRegistered(event);
        }
    }

    protected void fireUnregisteredToolEvent(ToolWindow toolWindow) {
        ToolWindowManagerEvent event = new ToolWindowManagerEvent((ToolWindowManager)this, ToolWindowManagerEvent.ActionId.TOOL_UNREGISTERED, toolWindow);
        for (ToolWindowManagerListener listener : (ToolWindowManagerListener[])this.twmListeners.getListeners(ToolWindowManagerListener.class)) {
            listener.toolWindowUnregistered(event);
        }
    }

    protected void fireAddedGroupEvent(ToolWindowGroup toolWindowGroup) {
        ToolWindowManagerEvent event = new ToolWindowManagerEvent((ToolWindowManager)this, ToolWindowManagerEvent.ActionId.GROUP_ADDED, toolWindowGroup);
        for (ToolWindowManagerListener listener : (ToolWindowManagerListener[])this.twmListeners.getListeners(ToolWindowManagerListener.class)) {
            listener.toolWindowGroupAdded(event);
        }
    }

    protected void fireRemovedGroupEvent(ToolWindowGroup toolWindowGroup) {
        ToolWindowManagerEvent event = new ToolWindowManagerEvent((ToolWindowManager)this, ToolWindowManagerEvent.ActionId.GROUP_REMOVED, toolWindowGroup);
        for (ToolWindowManagerListener listener : (ToolWindowManagerListener[])this.twmListeners.getListeners(ToolWindowManagerListener.class)) {
            listener.toolWindowGroupRemoved(event);
        }
    }

    void syncPanel(ToolWindowAnchor anchor) {
        boolean revalidate = false;
        MyDoggyToolWindowBar toolWindowBar = this.getBar(anchor);
        if (anchor == ToolWindowAnchor.LEFT) {
            if (toolWindowBar.getAvailableTools() == 0 && !toolWindowBar.isTempShowed() && this.contentPaneLayout.getColumn(0) != 0.0) {
                this.contentPaneLayout.setColumn(0, 0.0);
                revalidate = true;
            } else if ((toolWindowBar.getAvailableTools() != 0 || toolWindowBar.isTempShowed()) && this.contentPaneLayout.getColumn(0) == 0.0) {
                this.contentPaneLayout.setColumn(0, (double)this.getBar(ToolWindowAnchor.LEFT).getLength());
                revalidate = true;
            }
        } else if (anchor == ToolWindowAnchor.RIGHT) {
            if (toolWindowBar.getAvailableTools() == 0 && !toolWindowBar.isTempShowed() && this.contentPaneLayout.getColumn(2) != 0.0) {
                this.contentPaneLayout.setColumn(2, 0.0);
                revalidate = true;
            } else if ((toolWindowBar.getAvailableTools() != 0 || toolWindowBar.isTempShowed()) && this.contentPaneLayout.getColumn(2) == 0.0) {
                this.contentPaneLayout.setColumn(2, (double)this.getBar(ToolWindowAnchor.RIGHT).getLength());
                revalidate = true;
            }
        } else if (anchor == ToolWindowAnchor.TOP) {
            if (toolWindowBar.getAvailableTools() == 0 && !toolWindowBar.isTempShowed() && this.contentPaneLayout.getRow(0) != 0.0) {
                this.contentPaneLayout.setRow(0, 0.0);
                revalidate = true;
            } else if ((toolWindowBar.getAvailableTools() != 0 || toolWindowBar.isTempShowed()) && this.contentPaneLayout.getRow(0) == 0.0) {
                this.contentPaneLayout.setRow(0, (double)this.getBar(ToolWindowAnchor.TOP).getLength());
                revalidate = true;
            }
        } else if (anchor == ToolWindowAnchor.BOTTOM) {
            if (toolWindowBar.getAvailableTools() == 0 && !toolWindowBar.isTempShowed() && this.contentPaneLayout.getRow(2) != 0.0) {
                this.contentPaneLayout.setRow(2, 0.0);
                revalidate = true;
            } else if ((toolWindowBar.getAvailableTools() != 0 || toolWindowBar.isTempShowed()) && this.contentPaneLayout.getRow(2) == 0.0) {
                this.contentPaneLayout.setRow(2, (double)this.getBar(ToolWindowAnchor.BOTTOM).getLength());
                revalidate = true;
            }
        }
        if (revalidate) {
            SwingUtil.repaint(this);
        }
    }

    void setShowingGroup(ToolWindowGroup toolWindowGroup) {
        this.showingGroup = toolWindowGroup;
    }

    void setShowingGroup() {
        if (this.showingGroup == null) {
            this.setShowingGroup(this.allToolWindowGroup);
        }
    }

    void resetShowingGroup() {
        if (this.showingGroup == this.getToolWindowGroup()) {
            this.showingGroup = null;
        }
    }

    boolean isShowingGroup() {
        return this.showingGroup == this.allToolWindowGroup;
    }

    public boolean isWindowFocused() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner != null) {
            return SwingUtil.getWindowAncestor(focusOwner) == this.windowAnchestor;
        }
        return false;
    }

    public int getJMenuBarExtraHeight() {
        JMenuBar jMenuBar = this.getRootPane().getJMenuBar();
        if (jMenuBar != null && jMenuBar.isVisible()) {
            return jMenuBar.getHeight();
        }
        return 0;
    }

    public DockableDescriptor getDockableDescriptor(String id) {
        return this.dockableDescriptorMap.get(id);
    }

    public void putDockableDescriptor(String id, DockableDescriptor dockableDescriptor) {
        this.dockableDescriptorMap.put(id, dockableDescriptor);
    }

    public void removeDockableDescriptor(String id) {
        DockableDescriptor descriptor = this.dockableDescriptorMap.remove(id);
        if (descriptor != null) {
            descriptor.cleanup();
        }
    }

    public void setTempShowed(boolean tempShowed) {
        this.getBar(ToolWindowAnchor.LEFT).setTempShowed(tempShowed);
        this.getBar(ToolWindowAnchor.RIGHT).setTempShowed(tempShowed);
        this.getBar(ToolWindowAnchor.TOP).setTempShowed(tempShowed);
        this.getBar(ToolWindowAnchor.BOTTOM).setTempShowed(tempShowed);
    }

    public DockableDescriptor createDescriptor(Dockable dockable) {
        if (dockable instanceof ToolWindow) {
            return new ToolWindowDescriptor(this, (MyDoggyToolWindow)dockable);
        }
        if (dockable instanceof Content) {
            return new ContentDescriptor(this, (Content)dockable);
        }
        throw new IllegalArgumentException("Invalid dockable. [dockable : " + dockable + "]");
    }

    public Dockable getDockableWrapper(Dockable dockable) {
        for (ToolWindow toolWindow : this.getToolWindows()) {
            for (ToolWindowTab tab : toolWindow.getToolWindowTabs()) {
                if (tab.getDockableDelegator() != dockable) continue;
                return tab;
            }
        }
        for (ToolWindow toolWindow : this.contentManager.getContents()) {
            if (toolWindow.getDockableDelegator() != dockable) continue;
            return toolWindow;
        }
        return null;
    }

    public MutableContext getContext() {
        DefaultMutableContext context = new DefaultMutableContext();
        context.put(ToolWindowManager.class, this);
        context.put(ResourceManager.class, this.getResourceManager());
        return context;
    }

    public MutableContext getContext(Object ... entries) {
        DefaultMutableContext context = new DefaultMutableContext(entries);
        context.put(ToolWindowManager.class, this);
        context.put(ResourceManager.class, this.getResourceManager());
        return context;
    }

    public void ensureContentVisible(Content content) {
        for (ToolWindowDescriptor t : this.tools.values()) {
            if (!t.getToolWindow().isMaximized() || t.isFloatingWindow() || t.getToolWindow().isDetached()) continue;
            t.getToolWindow().setMaximized(false);
        }
        if (this.mainContainer.getWidth() < 50 || this.mainContainer.getHeight() < 50) {
            this.mainSplitPane.setDividerLocation(0.5);
            for (int i = 0; i < this.bars.length; ++i) {
                this.bars[i].getSplitPane().setDividerLocation(0.5);
            }
        }
    }

    class AllToolWindowGroup
    extends MyDoggyToolWindowGroup {
        AllToolWindowGroup() {
            super(MyDoggyToolWindowManager.this, "all", false);
        }

        public void addToolWindow(ToolWindow toolWindow) {
            throw new IllegalStateException("Cannot call this method!!!");
        }

        public boolean removeToolWindow(ToolWindow toolWindow) {
            throw new IllegalStateException("Cannot call this method!!!");
        }

        public ToolWindow[] getToolsWindow() {
            return MyDoggyToolWindowManager.this.getToolWindows();
        }

        public boolean containesToolWindow(ToolWindow toolWindow) {
            return true;
        }

        public void setImplicit(boolean implicit) {
            throw new IllegalStateException("Cannot call this method on this instance.");
        }

        public boolean isImplicit() {
            return false;
        }

        public String toString() {
            return "MyDoggyToolWindowGroup{name='all', tools=" + this.tools + '}';
        }
    }

    protected class InternalContentMananagerListener
    implements ContentManagerListener,
    PropertyChangeListener {
        protected InternalContentMananagerListener() {
        }

        public void contentAdded(ContentManagerEvent event) {
            MyDoggyContent content = (MyDoggyContent)event.getContent();
            MyDoggyToolWindowManager.this.ensureContentVisible(content);
            content.addPlafPropertyChangeListener("ensureVisible", this);
        }

        public void contentRemoved(ContentManagerEvent event) {
            MyDoggyContent content = (MyDoggyContent)event.getContent();
            content.removePlafPropertyChangeListener(this);
        }

        public void contentSelected(ContentManagerEvent event) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            MyDoggyToolWindowManager.this.ensureContentVisible((Content)evt.getNewValue());
        }
    }

    protected class ContentMananagerEnabledChangeListener
    implements PropertyChangeListener {
        protected ContentMananagerEnabledChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof ContentManager) {
                MyDoggyToolWindowGroup group = new MyDoggyToolWindowGroup(MyDoggyToolWindowManager.this, "temp", true);
                for (ToolWindow toolWindow : MyDoggyToolWindowManager.this.getToolWindows()) {
                    if (!toolWindow.isVisible() || toolWindow.getType() != ToolWindowType.DOCKED) continue;
                    group.addToolWindow(toolWindow);
                }
                if (group.getToolsWindow().length > 0) {
                    try {
                        firePublic = false;
                        group.setVisible(false);
                        MyDoggyToolWindowManager.this.setDockableMainContentMode((Boolean)evt.getNewValue() == false);
                        group.setVisible(true);
                    }
                    finally {
                        firePublic = true;
                    }
                } else {
                    MyDoggyToolWindowManager.this.setDockableMainContentMode((Boolean)evt.getNewValue() == false);
                }
            }
        }
    }

    protected class AnchestorClosedChangeListener
    implements PropertyChangeListener {
        protected AnchestorClosedChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            for (ToolWindowDescriptor tool : MyDoggyToolWindowManager.this.tools.values()) {
                tool.getToolWindowContainer().propertyChange(evt);
            }
        }
    }

    protected class FocusOwnerChangeListener
    implements PropertyChangeListener {
        protected FocusOwnerChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Component newFocusOwner = (Component)evt.getNewValue();
            if (newFocusOwner != null && SwingUtilities.isDescendingFrom(newFocusOwner, MyDoggyToolWindowManager.this.mainContainer)) {
                MyDoggyToolWindowManager.this.lastFocusOwner = newFocusOwner;
            }
        }
    }

    protected class BarLengthListener
    implements PropertyChangeListener {
        protected BarLengthListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowBar bar = (ToolWindowBar)evt.getSource();
            switch (bar.getAnchor()) {
                case LEFT: {
                    if (MyDoggyToolWindowManager.this.contentPaneLayout.getColumn(0) == 0.0) break;
                    MyDoggyToolWindowManager.this.contentPaneLayout.setColumn(0, (double)bar.getLength());
                    break;
                }
                case RIGHT: {
                    if (MyDoggyToolWindowManager.this.contentPaneLayout.getColumn(2) == 0.0) break;
                    MyDoggyToolWindowManager.this.contentPaneLayout.setColumn(2, (double)bar.getLength());
                    break;
                }
                case TOP: {
                    if (MyDoggyToolWindowManager.this.contentPaneLayout.getRow(0) == 0.0) break;
                    MyDoggyToolWindowManager.this.contentPaneLayout.setRow(0, (double)bar.getLength());
                    break;
                }
                case BOTTOM: {
                    if (MyDoggyToolWindowManager.this.contentPaneLayout.getRow(2) == 0.0) break;
                    MyDoggyToolWindowManager.this.contentPaneLayout.setRow(2, (double)bar.getLength());
                }
            }
            SwingUtil.repaint(MyDoggyToolWindowManager.this);
        }
    }

    protected class ResourceManagerListener
    implements PropertyChangeListener {
        protected ResourceManagerListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            SwingUtil.repaint(MyDoggyToolWindowManager.this);
        }
    }

    protected class MaximizedChangeListener
    implements PropertyChangeListener {
        protected MaximizedChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor toolWindowDescriptor = (ToolWindowDescriptor)evt.getSource();
            toolWindowDescriptor.getToolWindowContainer().propertyChange(evt);
            MyDoggyToolWindowManager.this.getBar(toolWindowDescriptor.getToolWindow().getAnchor()).propertyChange(evt);
            MyDoggyToolWindowManager.this.syncPanel(toolWindowDescriptor.getToolWindow().getAnchor());
        }
    }

    protected class UpdateUIChangeListener
    implements PropertyChangeListener {
        protected UpdateUIChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            MyDoggyToolWindowManager.this.contentManager.updateUI();
            for (ToolWindowDescriptor descriptor : MyDoggyToolWindowManager.this.tools.values()) {
                descriptor.updateUI();
            }
        }
    }

    protected class NumberingEnabledChangeListener
    implements PropertyChangeListener {
        protected NumberingEnabledChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            for (ToolWindowDescriptor descriptor : MyDoggyToolWindowManager.this.tools.values()) {
                descriptor.propertyChange(evt);
            }
        }
    }

    protected class IconChangeListener
    implements PropertyChangeListener {
        protected IconChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor descriptor = (ToolWindowDescriptor)evt.getSource();
            descriptor.propertyChange(evt);
            MyDoggyToolWindowManager.this.getBar(descriptor.getToolWindow().getAnchor()).propertyChange(evt);
        }
    }

    protected class IndexChangeListener
    implements PropertyChangeListener {
        protected IndexChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor descriptor = (ToolWindowDescriptor)evt.getSource();
            MyDoggyToolWindow modifiedTool = descriptor.getToolWindow();
            int newIndex = (Integer)evt.getNewValue();
            if (newIndex > 0) {
                for (ToolWindow toolWindow : MyDoggyToolWindowManager.this.getToolWindows()) {
                    if (toolWindow == modifiedTool || toolWindow.getIndex() != newIndex) continue;
                    toolWindow.setIndex(-1);
                    break;
                }
            }
            descriptor.propertyChange(evt);
            MyDoggyToolWindowManager.this.getBar(modifiedTool.getAnchor()).propertyChange(evt);
        }
    }

    protected class TypePropertyChangeListener
    implements PropertyChangeListener {
        protected TypePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor window = (ToolWindowDescriptor)evt.getSource();
            MyDoggyToolWindowManager.this.getBar(window.getToolWindow().getAnchor()).propertyChange(evt);
            for (ToolWindowDescriptor tool : MyDoggyToolWindowManager.this.tools.values()) {
                tool.getToolWindowContainer().propertyChange(evt);
            }
            MyDoggyToolWindowManager.this.syncPanel(window.getToolWindow().getAnchor());
        }
    }

    protected static class AutoHideChangeListener
    implements PropertyChangeListener {
        protected AutoHideChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ((ToolWindowDescriptor)evt.getSource()).getToolWindowContainer().propertyChange(evt);
        }
    }

    protected class AnchorPropertyChangeListener
    implements PropertyChangeListener {
        protected AnchorPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowType toolType;
            ToolWindowDescriptor descriptor = (ToolWindowDescriptor)evt.getSource();
            ToolWindowAnchor oldAnchor = (ToolWindowAnchor)evt.getOldValue();
            ToolWindowAnchor newAnchor = (ToolWindowAnchor)evt.getNewValue();
            boolean force = false;
            if (oldAnchor == null) {
                oldAnchor = newAnchor;
                force = true;
            }
            if ((toolType = descriptor.getToolWindow().getType()) == ToolWindowType.FLOATING || toolType == ToolWindowType.FLOATING_FREE || toolType == ToolWindowType.FLOATING_LIVE || force || !descriptor.getToolWindow().isAvailable()) {
                UserPropertyChangeEvent avEvent = new UserPropertyChangeEvent(evt.getSource(), "available", true, false, new Object[]{-1, true});
                MyDoggyToolWindowManager.this.getBar(oldAnchor).propertyChange(avEvent);
                MyDoggyToolWindowManager.this.syncPanel(oldAnchor);
                assert (evt instanceof UserPropertyChangeEvent);
                avEvent = new UserPropertyChangeEvent(evt.getSource(), "available", false, true, new Object[]{((UserPropertyChangeEvent)evt).getUserObject(), true});
                MyDoggyToolWindowManager.this.getBar(newAnchor).propertyChange(avEvent);
                MyDoggyToolWindowManager.this.syncPanel(newAnchor);
            }
            for (ToolWindowDescriptor tool : MyDoggyToolWindowManager.this.tools.values()) {
                tool.getToolWindowContainer().propertyChange(evt);
            }
            MyDoggyToolWindowManager.this.syncPanel(oldAnchor);
            MyDoggyToolWindowManager.this.syncPanel(newAnchor);
            if (force) {
                // empty if block
            }
        }
    }

    protected class ActivePropertyChangeListener
    implements PropertyChangeListener {
        protected ActivePropertyChangeListener() {
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor descriptor = (ToolWindowDescriptor)evt.getSource();
            PropertyChangeEvent event = new PropertyChangeEvent(evt.getSource(), "active.before", evt.getOldValue(), evt.getNewValue());
            for (MyDoggyToolWindowBar bar : MyDoggyToolWindowManager.this.bars) {
                bar.propertyChange(event);
            }
            MyDoggyToolWindowManager.this.getBar(descriptor.getToolWindow().getAnchor()).propertyChange(evt);
            if (Boolean.FALSE.equals(evt.getNewValue())) {
                MyDoggyToolWindowManager.this.activeToolWindowId = null;
                if (MyDoggyToolWindowManager.this.lastFocusOwner != null) {
                    boolean shouldRequest = true;
                    for (MyDoggyToolWindowBar bar : MyDoggyToolWindowManager.this.bars) {
                        if (!bar.valueAdjusting || MyDoggyToolWindowManager.this.getBar(descriptor.getToolWindow().getAnchor()) != bar) continue;
                        shouldRequest = false;
                        break;
                    }
                    if (shouldRequest) {
                        SwingUtil.requestFocus(MyDoggyToolWindowManager.this.lastFocusOwner);
                    }
                }
            } else {
                MyDoggyToolWindowManager.this.activeToolWindowId = descriptor.getToolWindow().getId();
            }
        }
    }

    protected class VisiblePropertyChangeListener
    implements PropertyChangeListener {
        boolean showingGroupValueAdj = false;

        protected VisiblePropertyChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            SwingUtil.revalidate(MyDoggyToolWindowManager.this);
            ToolWindowDescriptor descriptor = (ToolWindowDescriptor)evt.getSource();
            PropertyChangeEvent event = new PropertyChangeEvent(evt.getSource(), "visible.before", evt.getOldValue(), evt.getNewValue());
            for (MyDoggyToolWindowBar bar : MyDoggyToolWindowManager.this.bars) {
                bar.propertyChange(event);
            }
            MyDoggyToolWindowManager.this.getBar(descriptor.getToolWindow().getAnchor()).propertyChange(evt);
            MyDoggyToolWindowManager.this.syncPanel(descriptor.getToolWindow().getAnchor());
            Object object = sync;
            synchronized (object) {
                if ((MyDoggyToolWindowManager.this.showingGroup == null || MyDoggyToolWindowManager.this.showingGroup == MyDoggyToolWindowManager.this.getToolWindowGroup()) && Boolean.TRUE.equals(evt.getNewValue()) && !this.showingGroupValueAdj) {
                    this.showingGroupValueAdj = true;
                    try {
                        for (ToolWindowGroup group : MyDoggyToolWindowManager.this.getToolWindowGroups()) {
                            if (!group.isImplicit() || !group.containesToolWindow((ToolWindow)descriptor.getToolWindow())) continue;
                            for (ToolWindow tool : group.getToolsWindow()) {
                                if (tool == descriptor.getToolWindow()) continue;
                                tool.aggregate();
                            }
                            break;
                        }
                    }
                    finally {
                        this.showingGroupValueAdj = false;
                    }
                }
            }
        }
    }

    protected class ShowUnavailableToolsPropertyChangeListener
    implements PropertyChangeListener {
        protected ShowUnavailableToolsPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            for (MyDoggyToolWindowBar bar : MyDoggyToolWindowManager.this.bars) {
                bar.propertyChange(evt);
            }
            MyDoggyToolWindowManager.this.syncPanel(ToolWindowAnchor.LEFT);
            MyDoggyToolWindowManager.this.syncPanel(ToolWindowAnchor.RIGHT);
            MyDoggyToolWindowManager.this.syncPanel(ToolWindowAnchor.TOP);
            MyDoggyToolWindowManager.this.syncPanel(ToolWindowAnchor.BOTTOM);
        }
    }

    protected class AvailablePropertyChangeListener
    implements PropertyChangeListener {
        protected AvailablePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            DockableDescriptor descriptor = (DockableDescriptor)evt.getSource();
            ToolWindowAnchor target = descriptor.getAnchor();
            MyDoggyToolWindowManager.this.getBar(target).propertyChange(evt);
            MyDoggyToolWindowManager.this.syncPanel(target);
        }
    }
}

